/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.audio;

public class DFPWM {
    private final int RESP_INC = 7;
    private final int RESP_DEC = 20;
    private final int LPF_STRENGTH = 100;
    private int response = 0;
    private int level = 0;
    private boolean lastbit = false;
    private int flastlevel = 0;
    private int lpflevel = 0;

    private void ctx_update(boolean curbit) {
        int rdelta;
        int rtarget;
        int target = curbit ? 127 : -128;
        int nlevel = this.level + (this.response * (target - this.level) + 128 >> 8);
        if (nlevel == this.level && this.level != target) {
            nlevel += target == 127 ? 1 : -1;
        }
        if (curbit == this.lastbit) {
            rtarget = 255;
            rdelta = 7;
        } else {
            rtarget = 0;
            rdelta = 20;
        }
        int nresponse = this.response + (rdelta * (rtarget - this.response) + 128 >> 8);
        if (nresponse == this.response && this.response != rtarget) {
            nresponse += rtarget == 255 ? 1 : -1;
        }
        this.level = nlevel;
        this.response = nresponse;
        this.lastbit = curbit;
    }

    public void decompress(byte[] dest, byte[] src, int destoffs, int srcoffs, int len) {
        for (int i = 0; i < len; ++i) {
            if (srcoffs >= src.length) {
                return;
            }
            int d = src[srcoffs++];
            d &= 0xFF;
            for (int j = 0; j < 8; ++j) {
                boolean curbit = (d & 1) != 0;
                boolean lastbit = this.lastbit;
                this.ctx_update(curbit);
                d >>= 1;
                int blevel = curbit == lastbit ? this.level : this.flastlevel + this.level >> 1;
                this.flastlevel = this.level;
                this.lpflevel += 100 * (blevel - this.lpflevel) + 128 >> 8;
                dest[destoffs++] = (byte)this.lpflevel;
            }
        }
    }

    public void compress(byte[] dest, byte[] src, int destoffs, int srcoffs, int len) {
        for (int i = 0; i < len; ++i) {
            int d = 0;
            for (int j = 0; j < 8; ++j) {
                byte inlevel;
                if (srcoffs >= src.length) {
                    return;
                }
                boolean curbit = (inlevel = src[srcoffs++]) > this.level || inlevel == this.level && this.level == 127;
                d = curbit ? (d >> 1) + 128 : d >> 1;
                this.ctx_update(curbit);
            }
            dest[destoffs++] = (byte)d;
        }
    }

    public static void main(String[] args) throws Exception {
        int mode = 0;
        if (args.length >= 1) {
            if (args[0].equals("-e")) {
                mode = 1;
            } else if (args[0].equals("-d")) {
                mode = 2;
            }
        }
        byte[] pcmin = new byte[1024];
        byte[] pcmout = new byte[1024];
        byte[] cmpdata = new byte[128];
        DFPWM incodec = new DFPWM();
        DFPWM outcodec = new DFPWM();
        if (mode == 0) {
            while (true) {
                int amt;
                for (int ctr = 0; ctr < 1024; ctr += amt) {
                    amt = System.in.read(pcmin, ctr, 1024 - ctr);
                    if (amt != -1) continue;
                    return;
                }
                incodec.compress(cmpdata, pcmin, 0, 0, 128);
                outcodec.decompress(pcmout, cmpdata, 0, 0, 128);
                System.out.write(pcmout, 0, 1024);
            }
        }
        if (mode == 1) {
            while (true) {
                int amt;
                for (int ctr = 0; ctr < 1024; ctr += amt) {
                    amt = System.in.read(pcmin, ctr, 1024 - ctr);
                    if (amt != -1) continue;
                    return;
                }
                incodec.compress(cmpdata, pcmin, 0, 0, 128);
                System.out.write(cmpdata, 0, 128);
            }
        }
        if (mode == 2) {
            while (true) {
                int amt;
                for (int ctr = 0; ctr < 128; ctr += amt) {
                    amt = System.in.read(cmpdata, ctr, 128 - ctr);
                    if (amt != -1) continue;
                    return;
                }
                outcodec.decompress(pcmout, cmpdata, 0, 0, 128);
                System.out.write(pcmout, 0, 1024);
            }
        }
    }
}

