/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import pcl.opensecurity.ContentRegistry;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.client.sounds.ISoundTile;
import pcl.opensecurity.entity.EntityEnergyBolt;
import pcl.opensecurity.items.ItemCooldownUpgrade;
import pcl.opensecurity.items.ItemDamageUpgrade;
import pcl.opensecurity.items.ItemEnergyUpgrade;
import pcl.opensecurity.items.ItemMovementUpgrade;
import pcl.opensecurity.tileentity.TileEntityMachineBase;

public class TileEntityEnergyTurret
extends TileEntityMachineBase
implements Environment,
IInventory,
ISoundTile {
    static final float maxShaftLengthForOneBlock = 0.5f;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public float setpointYaw = 0.0f;
    public float setpointPitch = 0.0f;
    public float shaft = 1.0f;
    public float setShaft = 1.0f;
    public float barrel = 1.0f;
    public int tickCool = 0;
    public boolean onPoint = true;
    private float movePerTick = 0.005f;
    public Boolean shouldPlay = false;
    public String soundName = "turretMove";
    public float volume = 1.0f;
    public int soundTicks = 0;
    public boolean power = true;
    public boolean armed = true;
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(TileEntityEnergyTurret.getComponentName()).withConnector(32.0).create();
    private ItemStack[] ItemStacks = new ItemStack[12];

    public TileEntityEnergyTurret() {
        this.setSound(this.soundName);
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.write(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.read(tag);
    }

    @Override
    public boolean shouldPlaySound() {
        return this.shouldPlay;
    }

    @Override
    public String getSoundName() {
        return this.soundName;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public ResourceLocation setSound(String sound) {
        this.setSoundRes(new ResourceLocation("opensecurity:" + sound));
        return this.getSoundRes();
    }

    public boolean isUpright() {
        return this.field_145850_b == null ? true : 1 != this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setShouldStart(boolean b) {
        this.shouldPlay = b;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean upright = this.isUpright();
        boolean shaftLengthValid = true;
        boolean moveSound = false;
        this.movePerTick = 4.0f;
        float maxShaft = this.getMaxAvailableShaftLength(this.shaft);
        if (this.shaft > maxShaft) {
            shaftLengthValid = false;
            if (this.setShaft > maxShaft) {
                this.setShaft(maxShaft);
            }
        }
        if (this.node != null) {
            if (this.node.network() == null) {
                Network.joinOrCreateNetwork((TileEntity)this);
            }
            if (this.power && !this.node.tryChangeBuffer(-10.0)) {
                this.doPowerOff();
            }
        }
        if (this.ItemStacks[2] != null && this.ItemStacks[2].func_77973_b() instanceof ItemMovementUpgrade) {
            this.movePerTick += 2.5f;
        }
        if (this.ItemStacks[3] != null && this.ItemStacks[3].func_77973_b() instanceof ItemMovementUpgrade) {
            this.movePerTick += 2.5f;
        }
        if (this.ItemStacks[4] != null && this.ItemStacks[4].func_77973_b() instanceof ItemCooldownUpgrade) {
            --this.tickCool;
            --this.tickCool;
            --this.tickCool;
        }
        if (this.ItemStacks[5] != null && this.ItemStacks[5].func_77973_b() instanceof ItemCooldownUpgrade) {
            --this.tickCool;
            --this.tickCool;
            --this.tickCool;
        }
        --this.tickCool;
        float tmpSetPitch = this.setpointPitch;
        float ms = 0.0f;
        float my = 0.0f;
        float mp = 0.0f;
        if (this.power || !shaftLengthValid) {
            if (Float.isNaN(this.shaft) || Float.isInfinite(this.shaft)) {
                this.shaft = 0.0f;
            }
            float ds = this.setShaft - this.shaft;
            ms = Math.min(0.05f, Math.abs(ds));
            this.shaft += ms * Math.signum(ds);
            if (ms > 0.0f) {
                moveSound = true;
            }
        }
        if (this.power) {
            float dy;
            if (Float.isNaN(this.yaw) || Float.isInfinite(this.yaw)) {
                this.yaw = 0.0f;
            }
            if ((dy = (this.setpointYaw - this.yaw) % 360.0f) > 180.0f) {
                dy -= 360.0f;
            } else if (dy < -180.0f) {
                dy = 360.0f + dy;
            }
            my = Math.min(this.movePerTick, Math.abs(dy));
            this.yaw += my * Math.signum(dy);
            this.yaw %= 360.0f;
            if (this.yaw < 0.0f) {
                this.yaw += 360.0f;
            }
            if (my > 0.0f) {
                moveSound = true;
            }
        } else {
            tmpSetPitch = -90.0f;
            this.movePerTick = 6.0f;
        }
        if (upright) {
            tmpSetPitch = Math.min(tmpSetPitch, (float)(Math.atan(this.shaft) * 360.0 / Math.PI));
            tmpSetPitch = Math.max(tmpSetPitch, (float)(-Math.atan(this.shaft) * 180.0 / Math.PI));
        } else {
            tmpSetPitch = Math.min(tmpSetPitch, (float)(Math.atan(this.shaft) * 180.0 / Math.PI));
            tmpSetPitch = Math.max(tmpSetPitch, (float)(-Math.atan(this.shaft) * 360.0 / Math.PI));
        }
        if (Float.isNaN(this.pitch) || Float.isInfinite(this.pitch)) {
            this.pitch = 0.0f;
        }
        float dp = tmpSetPitch - this.pitch;
        mp = Math.min(this.movePerTick, Math.abs(dp));
        if (this.power && mp > 0.0f) {
            moveSound = true;
        }
        this.pitch += mp * Math.signum(dp);
        if (this.pitch < -90.0f) {
            this.pitch = -90.0f;
        } else if (this.pitch > 90.0f) {
            this.pitch = 90.0f;
        }
        if (this.power) {
            if (this.armed) {
                if (this.barrel < 1.0f) {
                    this.barrel = Math.min(1.0f, this.barrel + 0.1f);
                    moveSound = true;
                }
            } else if (this.barrel > 0.0f) {
                this.barrel = Math.max(0.0f, this.barrel - 0.1f);
                moveSound = true;
            }
        }
        if (moveSound) {
            if (this.soundTicks == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "opensecurity:turretMove", 0.5f, 1.0f);
            }
            ++this.soundTicks;
            if (this.soundTicks > 5) {
                this.soundTicks = 0;
            }
        } else {
            this.soundTicks = 0;
        }
    }

    @Callback(doc="function():number -- Current real yaw", direct=true)
    public Object[] getYaw(Context context, Arguments args) {
        return new Object[]{Float.valueOf(this.yaw)};
    }

    @Callback(doc="function():number -- Current real pitch", direct=true)
    public Object[] getPitch(Context context, Arguments args) {
        return new Object[]{Float.valueOf(this.pitch)};
    }

    @Callback(doc="function():boolean -- Returns whether the gun has reached the set position", direct=true)
    public Object[] isOnTarget(Context context, Arguments args) {
        double dYaw;
        double dPitch = Math.abs(this.pitch - this.setpointPitch);
        double delta = dPitch + (dYaw = (double)Math.abs(this.yaw - this.setpointYaw));
        boolean onPoint = delta < 0.5;
        return new Object[]{onPoint, delta};
    }

    @Callback(doc="function():boolean -- Returns whether the gun is ready to fire again (cooled down and armed)", direct=true)
    public Object[] isReady(Context context, Arguments args) {
        return new Object[]{this.tickCool <= 0 && this.armed && this.barrel == 1.0f};
    }

    @Callback(doc="function():boolean,number -- Returns whether the gun is powered", direct=true)
    public Object[] isPowered(Context context, Arguments args) {
        return new Object[]{this.power};
    }

    float getMaxAvailableShaftLength(float newExt) {
        if (newExt < 0.0f) {
            newExt = 0.0f;
        }
        if (newExt > 2.0f) {
            newExt = 2.0f;
        }
        int otherY = this.field_145848_d + (this.isUpright() ? 1 : -1);
        if (newExt > 0.5f && (otherY < 0 || otherY > 255 || !this.field_145850_b.func_147437_c(this.field_145851_c, otherY, this.field_145849_e))) {
            return 0.5f;
        }
        return newExt;
    }

    float setShaft(float newlen) {
        float most;
        if (newlen < 0.0f) {
            newlen = 0.0f;
        }
        if (newlen > (most = this.getMaxAvailableShaftLength(newlen))) {
            newlen = most;
        }
        if (this.setShaft != newlen) {
            this.setShaft = newlen;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
        return newlen;
    }

    void setYaw(float value) {
        this.setpointYaw = value % 360.0f;
        if (this.setpointYaw < 0.0f) {
            this.setpointYaw += 360.0f;
        }
    }

    void setPitch(float value) {
        this.setpointPitch = value;
        if (this.setpointPitch < -90.0f) {
            this.setpointPitch = -90.0f;
        } else if (this.setpointPitch > 90.0f) {
            this.setpointPitch = 90.0f;
        }
    }

    @Callback(doc="function(length:boolean):number -- Extends gun shaft (0-2)")
    public Object[] extendShaft(Context context, Arguments args) throws Exception {
        float setTo = this.setShaft((float)args.checkDouble(0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return new Object[]{Float.valueOf(setTo)};
    }

    @Callback(doc="function():boolean -- Get gun shaft extension", direct=true)
    public Object[] getShaftLength(Context context, Arguments args) throws Exception {
        return new Object[]{Float.valueOf(this.shaft)};
    }

    @Callback(doc="function(yaw:number, pitch:number) -- Changes the gun's setpoint (Yaw ranges (0.0..360) Pitch ranges (-45..90))")
    public Object[] moveTo(Context context, Arguments args) throws Exception {
        if (this.power) {
            this.soundName = "turretMove";
            this.setSound(this.soundName);
            this.setShouldStart(true);
            this.setYaw((float)args.checkDouble(0));
            this.setPitch((float)args.checkDouble(1));
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return new Object[]{true};
        }
        throw new Exception("powered off");
    }

    @Callback(doc="function(yaw:number, pitch:number) -- Changes the gun's setpoint in radians")
    public Object[] moveToRadians(Context context, Arguments args) throws Exception {
        if (this.power) {
            this.soundName = "turretMove";
            this.setSound(this.soundName);
            this.setShouldStart(true);
            double rad = args.checkDouble(0);
            double deg = rad * 180.0 / Math.PI;
            double rad2 = args.checkDouble(1);
            double deg2 = rad2 * 180.0 / Math.PI;
            this.setYaw((float)deg);
            this.setPitch((float)deg2);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return new Object[]{true};
        }
        throw new Exception("powered off");
    }

    @Callback
    public Object[] setArmed(Context context, Arguments args) {
        boolean newArmed = args.checkBoolean(0);
        if (this.armed != newArmed) {
            this.armed = newArmed;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
        return new Object[]{true};
    }

    @Callback
    public Object[] powerOn(Context context, Arguments args) {
        this.power = true;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        return new Object[]{true};
    }

    void doPowerOff() {
        this.power = false;
        this.setPitch(this.pitch);
        this.setYaw(this.yaw);
        this.setShaft(this.shaft);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Callback
    public Object[] powerOff(Context context, Arguments args) {
        this.doPowerOff();
        return new Object[]{true};
    }

    @Callback(doc="function():table -- Fires the gun.  More damage means longer cooldown and more energy draw. Returns true for success and throws error with a message for failure")
    public Object[] fire(Context context, Arguments args) throws Exception {
        if (this.power) {
            if (!this.armed || this.barrel < 1.0f) {
                throw new Exception("Not armed");
            }
            float p = this.getRealPitch();
            float a = this.getRealYaw() + (float)Math.PI;
            float damage = 3.0f;
            if (this.ItemStacks[0] != null && this.ItemStacks[0].func_77973_b() instanceof ItemDamageUpgrade) {
                damage *= 3.0f;
            }
            if (this.ItemStacks[1] != null && this.ItemStacks[1].func_77973_b() instanceof ItemDamageUpgrade) {
                damage *= 3.0f;
            }
            float energy = damage;
            if (this.ItemStacks[6] != null && this.ItemStacks[6].func_77973_b() instanceof ItemEnergyUpgrade) {
                energy *= 0.7f;
            }
            if (this.ItemStacks[7] != null && this.ItemStacks[7].func_77973_b() instanceof ItemEnergyUpgrade) {
                energy *= 0.7f;
            }
            if (this.tickCool > 0) {
                throw new Exception("gun hasn't cooled");
            }
            if (!this.node.tryChangeBuffer((double)(-energy * 25.0f))) {
                throw new Exception("not enough energy");
            }
            this.tickCool = 200;
            EntityEnergyBolt bolt = new EntityEnergyBolt(this.field_145850_b);
            float dY = 0.5f + (this.isUpright() ? 1.0f : -1.0f) * (0.125f + this.shaft * 0.375f);
            bolt.func_70107_b((float)this.field_145851_c + 0.5f, (float)this.field_145848_d + dY, (float)this.field_145849_e + 0.5f);
            bolt.setHeading(a, p);
            bolt.setDamage(damage);
            this.soundName = "turretFire";
            this.setSound(this.soundName);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "opensecurity:" + this.soundName, 0.5f, 1.0f);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            this.field_145850_b.func_72838_d((Entity)bolt);
            return new Object[]{true};
        }
        throw new Exception("powered off");
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.read(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.write(tag);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    private static String getComponentName() {
        return "os_energyturret";
    }

    private void write(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            tag.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        tag.func_74757_a("powered", this.power);
        tag.func_74757_a("armed", this.armed);
        tag.func_74776_a("yaw", this.yaw);
        tag.func_74776_a("syaw", this.setpointYaw);
        tag.func_74776_a("pitch", this.pitch);
        tag.func_74776_a("spitch", this.setpointPitch);
        tag.func_74776_a("shaft", this.shaft);
        tag.func_74776_a("sshaft", this.setShaft);
        tag.func_74776_a("barrel", this.barrel);
        tag.func_74768_a("cool", this.tickCool);
        this.writeSyncableDataToNBT(tag);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.ItemStacks.length; ++var3) {
            if (this.ItemStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.ItemStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        tag.func_74782_a("Items", (NBTBase)var2);
    }

    private void read(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (this.node != null && this.node.host() == this) {
            this.node.load(tag.func_74775_l("oc:node"));
        }
        this.power = tag.func_74767_n("powered");
        this.armed = tag.func_74767_n("armed");
        this.yaw = tag.func_74760_g("yaw");
        this.setpointYaw = tag.func_74760_g("syaw");
        this.pitch = tag.func_74760_g("pitch");
        this.setpointPitch = tag.func_74760_g("spitch");
        this.shaft = tag.func_74760_g("shaft");
        this.setShaft = tag.func_74760_g("sshaft");
        this.barrel = tag.func_74760_g("barrel");
        this.tickCool = tag.func_74762_e("cool");
        this.readSyncableDataFromNBT(tag);
        NBTTagList var2 = tag.func_150295_c("Items", (int)tag.func_74732_a());
        this.ItemStacks = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.ItemStacks.length) continue;
            this.ItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    private void readSyncableDataFromNBT(NBTTagCompound tag) {
        this.soundName = tag.func_74779_i("soundName");
        this.volume = tag.func_74760_g("volume");
    }

    private void writeSyncableDataToNBT(NBTTagCompound tag) {
        tag.func_74778_a("soundName", this.soundName);
        tag.func_74776_a("volume", this.volume);
    }

    public float getRealYaw() {
        if (OpenSecurity.cfg.turretReverseRotation) {
            return (float)Math.PI * (0.0f - this.yaw) / 180.0f;
        }
        return (float)Math.PI * this.yaw / 180.0f;
    }

    public float getRealPitch() {
        return (float)Math.PI * this.pitch / 180.0f;
    }

    public Node node() {
        return this.node;
    }

    public void onConnect(Node arg0) {
    }

    public void onDisconnect(Node arg0) {
    }

    public void onMessage(Message arg0) {
    }

    @Override
    public boolean playSoundNow() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public int func_70302_i_() {
        return this.ItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.ItemStacks[i];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        if (this.func_70301_a(i) != null) {
            ItemStack var2 = this.func_70301_a(i);
            this.func_70299_a(i, null);
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.ItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "os_energyturret";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if ((slot == 0 || slot == 1) && item.func_77973_b() == ContentRegistry.damageUpgradeItem) {
            return true;
        }
        if ((slot == 2 || slot == 3) && item.func_77973_b() == ContentRegistry.movementUpgradeItem) {
            return true;
        }
        if ((slot == 4 || slot == 5) && item.func_77973_b() == ContentRegistry.cooldownUpgradeItem) {
            return true;
        }
        return (slot == 6 || slot == 7) && item.func_77973_b() == ContentRegistry.energyUpgradeItem;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isUpright()) {
            return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 0.75 + (double)this.shaft * 0.5), (double)(this.field_145849_e + 1));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)((double)this.field_145848_d + 0.25 - (double)this.shaft * 0.5), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }
}

