/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pcl.opensecurity.CommonProxy;
import pcl.opensecurity.Config;
import pcl.opensecurity.ContentRegistry;
import pcl.opensecurity.gui.OSGUIHandler;
import pcl.opensecurity.networking.HandlerKeypadButton;
import pcl.opensecurity.networking.OSPacketHandler;
import pcl.opensecurity.networking.PacketBoltFire;
import pcl.opensecurity.networking.PacketKeypadButton;

@Mod(modid="opensecurity", name="OpenSecurity", version="1.2.0-GTNH", dependencies="required-after:OpenComputers")
public class OpenSecurity {
    public static final String MODID = "opensecurity";
    public static File alarmSounds;
    @Mod.Instance(value="opensecurity")
    public static OpenSecurity instance;
    @SidedProxy(clientSide="pcl.opensecurity.ClientProxy", serverSide="pcl.opensecurity.CommonProxy")
    public static CommonProxy proxy;
    public static Config cfg;
    public static boolean debug;
    public static int rfidRange;
    public static boolean returnRealUUID;
    public static boolean enableplaySoundAt;
    public static boolean ignoreUUIDs;
    public static boolean registerBlockBreakEvent;
    public static final Logger logger;
    public static List<String> alarmList;
    public static SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        long time = System.nanoTime();
        cfg = new Config(new Configuration(event.getSuggestedConfigurationFile()));
        alarmSounds = new File("./mods/OpenSecurity/sounds/alarms/");
        File[] listOfFiles = alarmSounds.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                System.out.println("File " + listOfFiles[i].getName());
                alarmList.add(listOfFiles[i].getName());
            }
        }
        rfidRange = OpenSecurity.cfg.rfidMaxRange;
        returnRealUUID = OpenSecurity.cfg.returnRealUUID;
        enableplaySoundAt = OpenSecurity.cfg.enableplaySoundAt;
        ignoreUUIDs = OpenSecurity.cfg.ignoreUUIDs;
        registerBlockBreakEvent = OpenSecurity.cfg.registerBlockBreak;
        if ((event.getSourceFile().getName().endsWith(".jar") || debug) && event.getSide().isClient() && OpenSecurity.cfg.enableMUD) {
            logger.info("Registering mod with OpenUpdater");
            try {
                Class.forName("pcl.mud.OpenUpdater").getDeclaredMethod("registerMod", ModContainer.class, URL.class, URL.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), new URL("http://PC-Logix.com/OpenSecurity/get_latest_build.php?mcver=1.7.10"), new URL("http://PC-Logix.com/OpenSecurity/changelog.php?mcver=1.7.10"));
            }
            catch (Throwable e) {
                logger.info("OpenUpdater is not installed, not registering.");
            }
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new OSGUIHandler());
        network = NetworkRegistry.INSTANCE.newSimpleChannel("OpenSecurity");
        int packetID = 0;
        network.registerMessage(OSPacketHandler.PacketHandler.class, OSPacketHandler.class, packetID++, Side.SERVER);
        network.registerMessage(PacketBoltFire.class, PacketBoltFire.class, packetID++, Side.CLIENT);
        network.registerMessage(HandlerKeypadButton.class, PacketKeypadButton.class, packetID++, Side.CLIENT);
        logger.info("Registered " + packetID + " packets");
        ContentRegistry.preInit();
        logger.info("Finished pre-init in %d ms", new Object[]{(System.nanoTime() - time) / 1000000L});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        long time = System.nanoTime();
        proxy.registerRenderers();
        proxy.registerSounds();
        ContentRegistry.init();
        logger.info("Finished init in %d ms", new Object[]{(System.nanoTime() - time) / 1000000L});
    }

    static {
        cfg = null;
        debug = false;
        returnRealUUID = false;
        enableplaySoundAt = false;
        ignoreUUIDs = false;
        registerBlockBreakEvent = true;
        logger = LogManager.getFormatterLogger((String)MODID);
        alarmList = new ArrayList<String>();
    }
}

