/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.ammo;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.expanded.IBaubleExpanded;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tconstruct.compat.LoadedMods;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.ammo.ArrowAmmo;

@Optional.InterfaceList(value={@Optional.Interface(modid="Baubles|Expanded", iface="baubles.api.expanded.IBaubleExpanded"), @Optional.Interface(modid="Baubles", iface="baubles.api.IBauble")})
public class BoltAmmo
extends AmmoItem
implements IBauble,
IBaubleExpanded {
    public BoltAmmo() {
        super(0, "Bolts");
    }

    @Override
    public String getIconSuffix(int partType) {
        String string;
        switch (partType) {
            case 0: {
                string = "_bolt_head";
                break;
            }
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = "_bolt_shaft";
                break;
            }
            case 3: {
                string = "_bolt_fletching";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getEffectSuffix() {
        return "_bolt_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "bolt";
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
        this.handleStrings.put(index, location[2]);
    }

    @Override
    public void registerAlternatePartPaths(int index, String[] location) {
        this.accessoryStrings.put(index, location[3]);
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.partBolt;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.partBolt;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.fletching;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"ammo", "projectile", "weapon"};
    }

    @Override
    public void buildTool(int id, String name, List<ItemStack> list) {
        ItemStack handleStack;
        if (TConstructRegistry.getArrowMaterial(id) == null) {
            return;
        }
        ItemStack headStack = DualMaterialToolPart.createDualMaterial(this.getHeadItem(), id, 2);
        ItemStack tool = ToolBuilder.instance.buildTool(headStack, handleStack = new ItemStack(this.getAccessoryItem(), 1, 0), null, null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    @Override
    protected int getDefaultColor(int renderPass, int materialID) {
        if (renderPass != 2) {
            return super.getDefaultColor(renderPass, materialID);
        }
        CustomMaterial mat = TConstructRegistry.getCustomMaterial(materialID, FletchingMaterial.class);
        if (mat == null) {
            mat = TConstructRegistry.getCustomMaterial(materialID, FletchlingLeafMaterial.class);
        }
        if (mat == null) {
            return 0xFFFFFF;
        }
        return mat.color;
    }

    @Override
    public String getAbilityNameForType(int type, int part) {
        if (part >= 2) {
            return "";
        }
        return super.getAbilityNameForType(type, part);
    }

    @Optional.Method(modid="Baubles|Expanded")
    public String[] getBaubleTypes(ItemStack itemstack) {
        return new String[]{"quiver"};
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        this.func_77663_a(itemstack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> lines, boolean advanced) {
        super.func_77624_a(stack, player, lines, advanced);
        if (LoadedMods.baubles) {
            ArrowAmmo.addBaubleInformation(lines);
        }
    }
}

