/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.ammo;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.expanded.IBaubleExpanded;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import tconstruct.TConstruct;
import tconstruct.compat.LoadedMods;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.weaponry.TinkerWeaponry;

@Optional.InterfaceList(value={@Optional.Interface(modid="Baubles|Expanded", iface="baubles.api.expanded.IBaubleExpanded"), @Optional.Interface(modid="Baubles", iface="baubles.api.IBauble")})
public class ArrowAmmo
extends AmmoItem
implements IBauble,
IBaubleExpanded {
    public static ItemStack vanillaArrow;

    public ArrowAmmo() {
        super(0, "Arrows");
    }

    @Override
    public String getIconSuffix(int partType) {
        String string;
        switch (partType) {
            case 0: {
                string = "_arrow_head";
                break;
            }
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = "_arrow_shaft";
                break;
            }
            case 3: {
                string = "_arrow_fletching";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getEffectSuffix() {
        return "_arrow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "arrow";
    }

    @Override
    public void registerPartPaths(int index, String[] location) {
        this.headStrings.put(index, location[0]);
    }

    @Override
    public void registerAlternatePartPaths(int index, String[] location) {
        this.handleStrings.put(index, location[2]);
        this.accessoryStrings.put(index, location[3]);
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.arrowhead;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.partArrowShaft;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.fletching;
    }

    @Override
    public int durabilityTypeHandle() {
        return 0;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"ammo", "projectile", "weapon"};
    }

    @Override
    public void buildTool(int id, String name, List<ItemStack> list) {
        if (TConstructRegistry.getArrowMaterial(id) == null) {
            return;
        }
        ItemStack handleStack = new ItemStack(this.getHandleItem(), 1, 0);
        ItemStack accessoryStack = new ItemStack(this.getAccessoryItem(), 1, 0);
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), handleStack, accessoryStack, null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            list.add(tool);
        }
    }

    @Override
    public void func_150895_a(Item id, CreativeTabs tab, List<ItemStack> list) {
        super.func_150895_a(id, tab, list);
        ItemStack headStack = new ItemStack(this.getHeadItem(), 1, 3);
        ItemStack handleStack = new ItemStack(this.getHandleItem(), 1, 0);
        ItemStack accessoryStack = new ItemStack(this.getAccessoryItem(), 1, 0);
        ItemStack tool = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, null, "");
        if (tool != null) {
            tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
            vanillaArrow = tool;
        } else {
            TConstruct.logger.error("Couldn't build vanilla equivalent of Tinker Arrow");
        }
    }

    @Override
    protected int getDefaultColor(int renderPass, int materialID) {
        if (renderPass != 2) {
            return super.getDefaultColor(renderPass, materialID);
        }
        CustomMaterial mat = TConstructRegistry.getCustomMaterial(materialID, FletchingMaterial.class);
        if (mat == null) {
            TConstructRegistry.getCustomMaterial(materialID, FletchlingLeafMaterial.class);
        }
        if (mat == null) {
            return 0xFFFFFF;
        }
        return mat.color;
    }

    @Override
    public String getAbilityNameForType(int type, int part) {
        if (part == 1 && type == 3) {
            return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"modifier.tool.blaze");
        }
        if (part > 1) {
            return "";
        }
        return super.getAbilityNameForType(type, part);
    }

    @Optional.Method(modid="Baubles|Expanded")
    public String[] getBaubleTypes(ItemStack itemstack) {
        return new String[]{"quiver"};
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        this.func_77663_a(itemstack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> lines, boolean advanced) {
        super.func_77624_a(stack, player, lines, advanced);
        if (LoadedMods.baubles) {
            ArrowAmmo.addBaubleInformation(lines);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="Baubles")
    public static void addBaubleInformation(List<String> lines) {
        if (LoadedMods.baublesExpanded) {
            if (GuiScreen.func_146272_n()) {
                lines.add(StatCollector.func_74838_a((String)"tooltip.compatibleslots"));
                lines.add(StatCollector.func_74838_a((String)"slot.quiver"));
                if (LoadedMods.tiCTooltips) {
                    lines.add("");
                }
            } else if (!LoadedMods.tiCTooltips) {
                lines.add(StatCollector.func_74838_a((String)"tooltip.shiftprompt"));
            }
        } else {
            lines.add(StatCollector.func_74838_a((String)"baubletype.any"));
        }
    }
}

