/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.logic;

import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class FaucetLogic
extends TileEntity
implements IFacingLogic,
IActiveLogic,
IFluidHandler {
    byte direction = 0;
    boolean active;
    public FluidStack liquid;
    public boolean hasRedstonePower = false;

    public boolean activateFaucet() {
        if (this.liquid == null && this.active) {
            FluidStack templiquid;
            int x = this.field_145851_c;
            int z = this.field_145849_e;
            switch (this.getRenderDirection()) {
                case 2: {
                    ++z;
                    break;
                }
                case 3: {
                    --z;
                    break;
                }
                case 4: {
                    ++x;
                    break;
                }
                case 5: {
                    --x;
                }
            }
            TileEntity drainte = this.field_145850_b.func_147438_o(x, this.field_145848_d, z);
            TileEntity tankte = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if (drainte instanceof IFluidHandler && tankte instanceof IFluidHandler && (templiquid = ((IFluidHandler)drainte).drain(this.getForgeDirection(), 144, false)) != null) {
                int drained = ((IFluidHandler)tankte).fill(ForgeDirection.UP, templiquid, false);
                if (drained > 0) {
                    this.liquid = ((IFluidHandler)drainte).drain(this.getForgeDirection(), drained, true);
                    ((IFluidHandler)tankte).fill(ForgeDirection.UP, this.liquid, true);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void func_145845_h() {
        if (this.liquid != null) {
            this.liquid.amount -= 6;
            if (this.liquid.amount <= 0) {
                this.liquid = null;
                if (!this.activateFaucet()) {
                    this.active = false;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
        if (side != 0 && side != 1) {
            this.direction = (byte)side;
        }
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (this.direction > 1) {
            return;
        }
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
                break;
            }
            default: {
                this.direction = (byte)2;
            }
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.liquid = tags.func_74767_n("hasLiquid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l("Fluid")) : null;
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74757_a("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.liquid.writeToNBT(nbt);
            tags.func_74782_a("Fluid", (NBTBase)nbt);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        if (!this.active) {
            this.active = true;
            this.active = this.activateFaucet();
        } else {
            this.active = false;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }
}

