/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.logic;

import cpw.mods.fml.common.eventhandler.Event;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.event.SmelteryCastEvent;
import tconstruct.library.event.SmelteryCastedEvent;
import tconstruct.library.event.SmelteryEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.util.IPattern;

public abstract class CastingBlockLogic
extends InventoryLogic
implements IFluidTank,
IFluidHandler,
ISidedInventory,
IFacingLogic {
    public FluidStack liquid;
    protected byte direction;
    protected int maxCastingDelay = 0;
    protected int castingDelay = 0;
    protected int renderOffset = 0;
    protected int capacity = 0;
    protected boolean needsUpdate;
    protected boolean init = true;
    protected int tick;
    protected final LiquidCasting liquidCasting;

    public CastingBlockLogic(LiquidCasting casting) {
        super(2, 1);
        this.liquidCasting = casting;
    }

    public int updateCapacity() {
        int cost;
        ItemStack inv = this.inventory[0];
        int ret = 144;
        int rec = this.liquidCasting.getCastingAmount(this.liquid, inv);
        if (rec > 0) {
            ret = rec;
        } else if (inv != null && inv.func_77973_b() instanceof IPattern && (cost = ((IPattern)inv.func_77973_b()).getPatternCost(inv)) > 0) {
            ret = (int)((double)ret * ((double)((IPattern)inv.func_77973_b()).getPatternCost(inv) * 0.5));
        }
        return ret;
    }

    public int updateCapacity(int capacity) {
        int ret = 144;
        if (capacity > 0) {
            ret = capacity;
        } else {
            int cost;
            ItemStack inv = this.inventory[0];
            if (inv != null && inv.func_77973_b() instanceof IPattern && (cost = ((IPattern)inv.func_77973_b()).getPatternCost(inv)) > 0) {
                ret = (int)((double)ret * ((double)cost * 0.5));
            }
        }
        return ret;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.liquid != null && this.liquid.getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return this.fill(from, new FluidStack(fluid, 1), false) > 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        FluidStack drained = this.drain(from, new FluidStack(fluid, 1), false);
        return drained != null && drained.amount > 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    public FluidStack getFluid() {
        return this.liquid == null ? null : this.liquid.copy();
    }

    public int getFluidAmount() {
        return this.liquid != null ? this.liquid.amount : 0;
    }

    public int getLiquidAmount() {
        return this.liquid.amount - this.renderOffset;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public abstract SmelteryCastEvent getCastingEvent(CastingRecipe var1, FluidStack var2);

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.liquid == null) {
            CastingRecipe recipe = this.liquidCasting.getCastingRecipe(resource, this.inventory[0]);
            if (recipe == null) {
                return 0;
            }
            SmelteryCastEvent event = this.getCastingEvent(recipe, resource);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return 0;
            }
            this.capacity = this.updateCapacity(recipe.castingMetal.amount);
            if (this.inventory[1] == null) {
                FluidStack copyLiquid = resource.copy();
                if (copyLiquid.amount > this.capacity) {
                    copyLiquid.amount = this.capacity;
                }
                if (doFill) {
                    if (copyLiquid.amount == this.capacity) {
                        this.maxCastingDelay = this.castingDelay = recipe.coolTime;
                    }
                    this.renderOffset = copyLiquid.amount;
                    this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.liquid = copyLiquid;
                    this.needsUpdate = true;
                }
                return copyLiquid.amount;
            }
            return 0;
        }
        if (resource.isFluidEqual(this.liquid)) {
            if (resource.amount + this.liquid.amount >= this.capacity) {
                int roomInTank = this.capacity - this.liquid.amount;
                if (doFill && roomInTank > 0) {
                    this.renderOffset = roomInTank;
                    this.maxCastingDelay = this.castingDelay = this.liquidCasting.getCastingDelay(this.liquid, this.inventory[0]);
                    this.liquid.amount = this.capacity;
                    this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.needsUpdate = true;
                }
                return roomInTank;
            }
            if (doFill) {
                this.renderOffset += resource.amount;
                this.liquid.amount += resource.amount;
                this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.needsUpdate = true;
            }
            return resource.amount;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null || this.liquid.getFluid() == null || this.liquid.getFluidID() <= 0 || this.castingDelay > 0) {
            return null;
        }
        if (this.liquid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.liquid.amount < used) {
            used = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= used;
        }
        FluidStack drained = this.liquid.copy();
        drained.amount = used;
        this.renderOffset = 0;
        if (this.liquid.amount <= 0) {
            this.liquid = null;
        }
        if (doDrain) {
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(drained, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this, used));
        }
        return drained;
    }

    public void interact(EntityPlayer player) {
        if (this.liquid != null) {
            return;
        }
        if (!this.isStackInSlot(0) && !this.isStackInSlot(1)) {
            ItemStack stack = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, this.stackSizeLimit);
            SmelteryEvent.ItemInsertedIntoCasting event = new SmelteryEvent.ItemInsertedIntoCasting(this, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                this.func_70299_a(0, event.item);
            } else {
                player.field_71071_by.func_70441_a(stack);
            }
        } else {
            int slot = 0;
            if (this.isStackInSlot(1)) {
                slot = 1;
            }
            SmelteryEvent.ItemRemovedFromCasting event = new SmelteryEvent.ItemRemovedFromCasting(this, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_70301_a(slot), player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            ItemStack output = event.item;
            AbilityHelper.spawnItemAtPlayer(player, output);
            this.inventory[slot] = null;
        }
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return stack;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (this.liquid != null) {
            return false;
        }
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return slot == 1;
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return null;
    }

    protected String getDefaultName() {
        return null;
    }

    public String func_145825_b() {
        return null;
    }

    public String getInvName() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.needsUpdate = true;
    }

    public void func_145845_h() {
        if (this.castingDelay > 0) {
            --this.castingDelay;
            if (this.castingDelay == 0) {
                this.castLiquid();
            }
        }
        if (this.renderOffset > 0) {
            this.renderOffset -= 6;
            if (this.renderOffset < 0) {
                this.renderOffset = 0;
            }
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        ++this.tick;
        if (this.tick % 20 == 0) {
            this.tick = 0;
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public abstract SmelteryCastedEvent getCastedEvent(CastingRecipe var1, ItemStack var2);

    public void castLiquid() {
        CastingRecipe recipe = this.liquidCasting.getCastingRecipe(this.liquid, this.inventory[0]);
        if (recipe != null) {
            SmelteryCastedEvent event = this.getCastedEvent(recipe, recipe.getResult());
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.maxCastingDelay = 0;
            this.inventory[1] = event.output;
            if (event.consumeCast) {
                this.inventory[0] = null;
            }
            if (event.output != null && event.output.func_77973_b() instanceof IPattern) {
                this.inventory[1] = this.inventory[0];
                this.inventory[0] = event.output;
            }
            this.liquid = null;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.liquid = tags.func_74767_n("hasLiquid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l("Fluid")) : null;
        this.capacity = tags.func_74767_n("Initialized") ? tags.func_74762_e("Capacity") : this.updateCapacity();
        this.castingDelay = tags.func_74762_e("castingDelay");
        this.maxCastingDelay = tags.func_74762_e("maxCastingDelay");
        this.renderOffset = tags.func_74762_e("RenderOffset");
        this.direction = tags.func_74771_c("direction");
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.liquid.writeToNBT(nbt);
            tags.func_74782_a("Fluid", (NBTBase)nbt);
        }
        tags.func_74757_a("Initialized", this.init);
        tags.func_74768_a("Capacity", this.capacity);
        tags.func_74768_a("castingDelay", this.castingDelay);
        tags.func_74768_a("maxCastingDelay", this.maxCastingDelay);
        tags.func_74768_a("RenderOffset", this.renderOffset);
        tags.func_74774_a("direction", this.direction);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getProgress() {
        if (this.castingDelay == 0 || this.maxCastingDelay == 0) {
            return 0;
        }
        return (int)((double)(this.maxCastingDelay - this.castingDelay) / (double)this.maxCastingDelay * 100.0);
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
                break;
            }
            default: {
                this.direction = (byte)2;
            }
        }
    }
}

