/*
 * Decompiled with CFR 0.152.
 */
package serenetweaks.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapStorage;

public class TimeStampsWorldSavedData
extends WorldSavedData {
    private static Map<String, Integer> timeStampMap = new HashMap<String, Integer>();
    private static final String DATA_NAME = "SereneTweaks_TimeStampData";

    public static void setChunkTimeStamp(Chunk chunk, int timeStamp) {
        if (timeStampMap.isEmpty()) {
            TimeStampsWorldSavedData.get(chunk.field_76637_e);
        }
        String key = chunk.field_76635_g + "_" + chunk.field_76647_h;
        timeStampMap.put(key, timeStamp);
    }

    public static int getChunkTimeStamp(Chunk chunk) {
        String key;
        if (timeStampMap.isEmpty()) {
            TimeStampsWorldSavedData.get(chunk.field_76637_e);
        }
        if (!timeStampMap.containsKey(key = chunk.field_76635_g + "_" + chunk.field_76647_h)) {
            return 0;
        }
        return timeStampMap.get(key);
    }

    public TimeStampsWorldSavedData() {
        super(DATA_NAME);
    }

    public TimeStampsWorldSavedData(String dataName) {
        super(dataName);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        Set keys = nbt.func_150296_c();
        for (String key : keys) {
            int value = nbt.func_74762_e(key);
            timeStampMap.put(key, value);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        Set<String> keys = timeStampMap.keySet();
        for (String key : keys) {
            int value = timeStampMap.get(key);
            nbt.func_74768_a(key, value);
        }
    }

    public static TimeStampsWorldSavedData get(World world) {
        MapStorage storage = world.perWorldStorage;
        TimeStampsWorldSavedData instance = (TimeStampsWorldSavedData)storage.func_75742_a(TimeStampsWorldSavedData.class, DATA_NAME);
        if (instance == null) {
            instance = new TimeStampsWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }
}

