/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import com.google.common.base.Preconditions;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import sereneseasons.api.ISSBlock;
import sereneseasons.api.SSBlocks;
import sereneseasons.block.BlockGreenhouseGlass;
import sereneseasons.block.BlockSeasonSensor;
import sereneseasons.core.SereneSeasons;
import sereneseasons.tileentity.TileEntitySeasonSensor;
import sereneseasons.util.inventory.CreativeTabSS;

public class ModBlocks {
    public static void init() {
        SSBlocks.greenhouse_glass = ModBlocks.registerBlock((Block)new BlockGreenhouseGlass(), "greenhouse_glass");
        SSBlocks.season_sensors[0] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.SPRING), "season_sensor_spring");
        SSBlocks.season_sensors[1] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.SUMMER), "season_sensor_summer").func_149647_a(null);
        SSBlocks.season_sensors[2] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.AUTUMN), "season_sensor_autumn").func_149647_a(null);
        SSBlocks.season_sensors[3] = ModBlocks.registerBlock((Block)new BlockSeasonSensor(BlockSeasonSensor.DetectorType.WINTER), "season_sensor_winter").func_149647_a(null);
        GameRegistry.registerTileEntity(TileEntitySeasonSensor.class, (String)"season_sensor");
    }

    public static void registerBlockItemModel(Block block, String stateName, int stateMeta) {
        Item item = Item.func_150898_a((Block)block);
        SereneSeasons.proxy.registerItemVariantModel(item, stateName, stateMeta);
    }

    public static Block registerBlock(Block block, String blockName) {
        return ModBlocks.registerBlock(block, blockName, CreativeTabSS.instance);
    }

    public static Block registerBlock(Block block, String blockName, CreativeTabs tab) {
        return ModBlocks.registerBlock(block, blockName, tab, true);
    }

    public static Block registerBlock(Block block, String blockName, CreativeTabs tab, boolean registerItemModels) {
        Preconditions.checkNotNull((Object)block, (Object)"Cannot register a null block");
        block.func_149663_c(blockName);
        block.func_149647_a(tab);
        if (block instanceof ISSBlock) {
            ISSBlock bopBlock = (ISSBlock)block;
            ModBlocks.registerBlockWithItem(block, blockName, bopBlock.getItemClass());
            SereneSeasons.proxy.registerBlockSided(block);
        } else {
            ModBlocks.registerBlockWithItem(block, blockName, ItemBlock.class);
            ModBlocks.registerBlockItemModel(block, blockName, 0);
        }
        return block;
    }

    private static void registerBlockWithItem(Block block, String blockName, Class<? extends ItemBlock> clazz) {
        block.func_149663_c(blockName);
        GameRegistry.registerBlock((Block)block, clazz, (String)blockName);
    }
}

