/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.util.BlockPos;
import alternate.current.util.BlockState;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class WorldHelper {
    private static final int Y_MIN = 0;
    private static final int Y_MAX = 256;

    static BlockState getBlockState(WorldServer world, BlockPos pos) {
        int y = pos.y;
        if (y < 0 || y >= 256) {
            return BlockState.AIR;
        }
        int x = pos.x;
        int z = pos.z;
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        ExtendedBlockStorage section = chunk.func_76587_i()[y >> 4];
        if (section == null) {
            return BlockState.AIR;
        }
        Block block = section.func_150819_a(x &= 0xF, y &= 0xF, z &= 0xF);
        if (block == Blocks.field_150350_a) {
            return BlockState.AIR;
        }
        int metadata = section.func_76665_b(x, y, z);
        return new BlockState(block, metadata);
    }

    static boolean setWireState(WorldServer world, BlockPos pos, BlockState state) {
        int prevMetadata;
        Block prevBlock;
        int y = pos.y;
        if (y < 0 || y >= 256) {
            return false;
        }
        int x = pos.x;
        int z = pos.z;
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        ExtendedBlockStorage section = chunk.func_76587_i()[y >> 4];
        if (section == null) {
            return false;
        }
        Block block = state.getBlock();
        if (block != (prevBlock = section.func_150819_a(x &= 0xF, y &= 0xF, z &= 0xF))) {
            return false;
        }
        int metadata = state.get();
        if (metadata == (prevMetadata = section.func_76665_b(x, y, z))) {
            return false;
        }
        section.func_76654_b(x, y, z, metadata);
        world.func_73040_p().func_151250_a(pos.x, pos.y, pos.z);
        chunk.func_76630_e();
        return true;
    }
}

