/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.util;

import alternate.current.util.BlockPos;
import alternate.current.util.Direction;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockState {
    public static final BlockState AIR = new BlockState(Blocks.field_150350_a, 0);
    private final Block block;
    private final int metadata;

    public BlockState(Block block, int metadata) {
        this.block = block;
        this.metadata = metadata;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockState) {
            BlockState state = (BlockState)obj;
            return state.block == this.block && state.metadata == this.metadata;
        }
        return false;
    }

    public Block getBlock() {
        return this.block;
    }

    public boolean is(Block block) {
        return this.block == block;
    }

    public int get() {
        return this.metadata;
    }

    public BlockState with(int metadata) {
        return new BlockState(this.block, metadata);
    }

    public boolean isAir() {
        return this == AIR;
    }

    public boolean isConductor() {
        return this.block.func_149662_c();
    }

    public boolean isSignalSource() {
        return this.block.func_149744_f();
    }

    public int getSignal(World world, BlockPos pos, Direction dir) {
        return this.block.func_149709_b((IBlockAccess)world, pos.x, pos.y, pos.z, dir.index);
    }

    public int getDirectSignal(World world, BlockPos pos, Direction dir) {
        return this.block.func_149748_c((IBlockAccess)world, pos.x, pos.y, pos.z, dir.index);
    }

    public boolean canSurviveAt(World world, BlockPos pos) {
        return this.block.func_149742_c(world, pos.x, pos.y, pos.z);
    }

    public void dropAsItem(World world, BlockPos pos) {
        this.block.func_149697_b(world, pos.x, pos.y, pos.z, 0, 0);
    }

    public void neighborChanged(World world, BlockPos pos, Block neighborBlock) {
        this.block.func_149695_a(world, pos.x, pos.y, pos.z, neighborBlock);
    }
}

