/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale.reflection;

import com.github.basdxz.rightproperguiscale.RightProperGUIScale;
import com.github.basdxz.rightproperguiscale.config.RightProperGUIScaleConfig;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import lombok.NonNull;
import net.minecraft.client.settings.GameSettings;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class GameSettingReflections {
    private static final String[] ENUM_FLOAT_FIELD_NAMES = new String[]{"enumFloat", "field_74385_A"};
    private static final String[] VALUE_MIN_FIELD_NAMES = new String[]{"valueMin", "field_148271_N"};
    private static final String[] VALUE_MAX_FIELD_NAMES = new String[]{"valueMax", "field_148272_O"};
    private static final String[] VALUE_STEP_FIELD_NAMES = new String[]{"valueStep", "field_148270_M"};
    private static final String SUCCESS_INFO = "Successfully Applied changes to GUI_SCALE enum!";
    private static final String NEW_SETTINGS_INFO = "New Settings: [MIN:{}] [MAX:{}] [STEP:{}]";
    private static boolean GUI_SETTING_IS_SLIDER = false;

    public static void apply() {
        GameSettingReflections.guiScaleButtonIntoSlider();
        GameSettingReflections.setNewGUIScaleSliderSettings();
        GameSettingReflections.logSuccess();
        GameSettingReflections.logNewSettings();
    }

    private static void guiScaleButtonIntoSlider() {
        if (GUI_SETTING_IS_SLIDER) {
            return;
        }
        GameSettingReflections.makeGuiScaleSliderStoreFloat();
        GUI_SETTING_IS_SLIDER = true;
    }

    private static void setNewGUIScaleSliderSettings() {
        GameSettingReflections.setGuiScaleSliderMin();
        GameSettingReflections.setGuiScaleSliderMax();
        GameSettingReflections.setGuiScaleSliderStep();
    }

    private static void makeGuiScaleSliderStoreFloat() {
        GameSettingReflections.setGuiScaleOptionField(true, ENUM_FLOAT_FIELD_NAMES);
    }

    private static void setGuiScaleSliderMin() {
        GameSettingReflections.setGuiScaleOptionField(Float.valueOf((float)RightProperGUIScaleConfig.GUI_SCALE_MIN), VALUE_MIN_FIELD_NAMES);
    }

    private static void setGuiScaleSliderMax() {
        GameSettingReflections.setGuiScaleOptionField(Float.valueOf((float)RightProperGUIScaleConfig.GUI_SCALE_MAX), VALUE_MAX_FIELD_NAMES);
    }

    private static void setGuiScaleSliderStep() {
        GameSettingReflections.setGuiScaleOptionField(Float.valueOf((float)RightProperGUIScaleConfig.GUI_SCALE_STEP), VALUE_STEP_FIELD_NAMES);
    }

    private static void setGuiScaleOptionField(@NonNull Object value, String ... fieldNameAliases) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (fieldNameAliases == null) {
            throw new NullPointerException("fieldNameAliases is marked non-null but is null");
        }
        GameSettingReflections.setField(GameSettings.Options.class, GameSettings.Options.GUI_SCALE, value, fieldNameAliases);
    }

    private static <T> void setField(@NonNull Class<T> clazz, @NonNull T target, @NonNull Object value, String ... fieldNameAliases) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (fieldNameAliases == null) {
            throw new NullPointerException("fieldNameAliases is marked non-null but is null");
        }
        Field field = ReflectionHelper.findField(clazz, (String[])fieldNameAliases);
        FieldUtils.removeFinalModifier((Field)field);
        FieldUtils.writeField((Field)field, target, (Object)value);
    }

    private static void logSuccess() {
        RightProperGUIScale.logger.info(SUCCESS_INFO);
    }

    private static void logNewSettings() {
        RightProperGUIScale.logger.info(NEW_SETTINGS_INFO, new Object[]{RightProperGUIScaleConfig.GUI_SCALE_MIN, RightProperGUIScaleConfig.GUI_SCALE_MAX, RightProperGUIScaleConfig.GUI_SCALE_STEP});
    }

    private GameSettingReflections() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

