/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale.mixin.mixins.client.minecraft;

import com.github.basdxz.rightproperguiscale.GUIScale;
import com.github.basdxz.rightproperguiscale.config.RightProperGUIScaleConfig;
import com.github.basdxz.rightproperguiscale.mixin.interfaces.client.minecraft.IScaledResolutionMixin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ScaledResolution.class})
public abstract class ScaledResolutionPatchMixin
implements IScaledResolutionMixin {
    @Unique
    private int screenWidth;
    @Unique
    private int screenHeight;
    @Shadow
    private int field_78330_e;
    @Unique
    private float scaleFactorF;
    @Shadow
    private int field_78333_a;
    @Shadow
    private double field_78332_c;
    @Shadow
    private int field_78331_b;
    @Shadow
    private double field_78329_d;

    @Override
    public float scaleFactor() {
        return this.scaleFactorF;
    }

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="RETURN")}, require=1)
    private void deferredConstructor(Minecraft minecraft, int screenWidth, int screenHeight, CallbackInfo ci) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.updateScaleFactor();
        this.updateScaledWidth();
        this.updateScaledHeight();
        this.updateLastScaledResolution();
    }

    @Unique
    private void updateScaleFactor() {
        float maxWidthScale = Math.max((float)this.screenWidth / (float)RightProperGUIScaleConfig.MIN_SCALED_WIDTH, 1.0f);
        float maxHeightScale = Math.max((float)this.screenHeight / (float)RightProperGUIScaleConfig.MIN_SCALED_HEIGHT, 1.0f);
        float maxDimensionScale = Math.min(maxWidthScale, maxHeightScale);
        this.scaleFactorF = Math.min(GUIScale.value(), maxDimensionScale);
        this.field_78330_e = Math.max(Math.round(this.scaleFactorF), 1);
    }

    @Unique
    private void updateScaledWidth() {
        this.field_78333_a = MathHelper.func_76143_f((double)((float)this.screenWidth / this.scaleFactorF));
        this.field_78332_c = this.field_78333_a;
    }

    @Unique
    private void updateScaledHeight() {
        this.field_78331_b = MathHelper.func_76143_f((double)((float)this.screenHeight / this.scaleFactorF));
        this.field_78329_d = this.field_78331_b;
    }

    @Unique
    private void updateLastScaledResolution() {
        GUIScale.lastScaledResolution(this);
    }

    @Override
    public int scaledWidth() {
        return this.field_78333_a;
    }

    @Override
    public int scaledHeight() {
        return this.field_78331_b;
    }
}

