/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale.mixin.mixins.client.minecraft;

import com.github.basdxz.rightproperguiscale.GUIScale;
import lombok.NonNull;
import net.minecraft.client.settings.GameSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={GameSettings.class})
public abstract class GameSettingGUIScaleLoadSaveMixin {
    @Redirect(method={"loadOptions()V"}, slice=@Slice(from=@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/settings/GameSettings;renderDistanceChunks:I"), to=@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/settings/GameSettings;guiScale:I")), at=@At(value="INVOKE", target="Ljava/lang/Integer;parseInt(Ljava/lang/String;)I"), require=1)
    private int loadGuiScale(String guiScale) {
        this.setGUIScaleFromOptionsFile(guiScale);
        return this.loadedGUIScale();
    }

    private void setGUIScaleFromOptionsFile(@NonNull String guiScale) {
        if (guiScale == null) {
            throw new NullPointerException("guiScale is marked non-null but is null");
        }
        GUIScale.set(this.parseGUIScaleFromOptionsFile(guiScale));
    }

    private float parseGUIScaleFromOptionsFile(@NonNull String guiScale) {
        if (guiScale == null) {
            throw new NullPointerException("guiScale is marked non-null but is null");
        }
        return Float.parseFloat(guiScale);
    }

    private int loadedGUIScale() {
        return GUIScale.vanillaValue();
    }

    @Redirect(method={"saveOptions()V"}, slice=@Slice(from=@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/settings/GameSettings;guiScale:I"), to=@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/settings/GameSettings;particleSetting:I")), at=@At(value="INVOKE", target="Ljava/lang/StringBuilder;append(I)Ljava/lang/StringBuilder;"), require=1)
    private StringBuilder saveGuiScale(StringBuilder instance, int minecraftGuiScale) {
        return this.appendGuiScaleToOptionsFile(instance);
    }

    private StringBuilder appendGuiScaleToOptionsFile(@NonNull StringBuilder optionsFileStringBuilder) {
        if (optionsFileStringBuilder == null) {
            throw new NullPointerException("optionsFileStringBuilder is marked non-null but is null");
        }
        return optionsFileStringBuilder.append(GUIScale.value());
    }
}

