/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale.mixin.mixins.client.betterquesting;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import com.github.basdxz.rightproperguiscale.mixin.interfaces.client.minecraft.IScaledResolutionMixin;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.util.vector.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RenderUtils.class}, remap=false)
public abstract class RenderUtilsScissorAlignmentMixin {
    private static final ThreadLocal<GuiRectangle> cachedRectangle = new ThreadLocal();

    @Inject(method={"startScissor(Lbetterquesting/api2/client/gui/misc/IGuiRect;)V"}, at={@At(value="NEW", target="(IIII)Lbetterquesting/api2/client/gui/misc/GuiRectangle;")}, locals=LocalCapture.CAPTURE_FAILHARD, require=1)
    private static void createScissorRectangle(IGuiRect rect, CallbackInfo ci, Minecraft mc, ScaledResolution r, int f, FloatBuffer fb, Matrix4f fm) {
        IScaledResolutionMixin scaledResolution = (IScaledResolutionMixin)r;
        float scale = scaledResolution.scaleFactor();
        float scaledHeight = scaledResolution.scaledHeight();
        int posX = RenderUtilsScissorAlignmentMixin.safeRound((float)rect.getX() * scale * fm.m00 + fm.m30 * scale);
        int posY = RenderUtilsScissorAlignmentMixin.safeRound((scaledHeight - ((float)(rect.getY() + rect.getHeight()) * fm.m11 + fm.m31)) * scale);
        int width = RenderUtilsScissorAlignmentMixin.safeRound((float)rect.getWidth() * scale * fm.m00);
        int height = RenderUtilsScissorAlignmentMixin.safeRound((float)rect.getHeight() * scale * fm.m11);
        cachedRectangle.set(new GuiRectangle(posX, posY, width, height));
    }

    private static int safeRound(float value) {
        return Math.max(Math.round(value), 1);
    }

    @Redirect(method={"startScissor(Lbetterquesting/api2/client/gui/misc/IGuiRect;)V"}, at=@At(value="NEW", target="(IIII)Lbetterquesting/api2/client/gui/misc/GuiRectangle;"), require=1)
    private static GuiRectangle replaceScissorRectangle(int x, int y, int w, int h) {
        GuiRectangle rect = cachedRectangle.get();
        if (rect == null) {
            new GuiRectangle(x, y, w, h);
        }
        cachedRectangle.remove();
        return rect;
    }
}

