/*
 * Decompiled with CFR 0.152.
 */
package com.github.basdxz.rightproperguiscale.config;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.ConfigurationManager;
import com.github.basdxz.rightproperguiscale.RightProperGUIScale;
import lombok.NonNull;

@Config(modid="rightproperguiscale")
public final class RightProperGUIScaleConfig {
    @Config.Comment(value={"Minimum setting of the GUI Scale."})
    @Config.LangKey(value="config.rightproperguiscale.min")
    @Config.DefaultDouble(value=1.0)
    @Config.RangeDouble(min=0.1, max=1000.0)
    public static double GUI_SCALE_MIN;
    @Config.Comment(value={"Maxiumum setting of the GUI Scale."})
    @Config.LangKey(value="config.rightproperguiscale.max")
    @Config.DefaultDouble(value=10.0)
    @Config.RangeDouble(min=1.0, max=1000.0)
    public static double GUI_SCALE_MAX;
    @Config.Comment(value={"The step size of the GUI Scale slider."})
    @Config.LangKey(value="config.rightproperguiscale.step")
    @Config.DefaultDouble(value=0.1)
    @Config.RangeDouble(min=0.01, max=1000.0)
    public static double GUI_SCALE_STEP;
    @Config.Comment(value={"The Default GUI Scale."})
    @Config.LangKey(value="config.rightproperguiscale.default")
    @Config.DefaultDouble(value=4.0)
    @Config.RangeDouble(min=0.01, max=1000.0)
    public static double GUI_SCALE_DEFAULT;
    @Config.Comment(value={"The minimum width the GUI will scale to."})
    @Config.LangKey(value="config.rightproperguiscale.min_scaled_width")
    @Config.DefaultInt(value=320)
    @Config.RangeInt(min=80, max=15360)
    public static int MIN_SCALED_WIDTH;
    @Config.Comment(value={"The minimum height the GUI will scale to."})
    @Config.LangKey(value="config.rightproperguiscale.min_scaled_height")
    @Config.DefaultInt(value=240)
    @Config.RangeInt(min=60, max=8640)
    public static int MIN_SCALED_HEIGHT;
    @Config.Ignore
    private static final String CONFIG_REGISTRATION_FAILED = "Failed to register config!";

    public static void register() {
        try {
            ConfigurationManager.selfInit();
        }
        catch (Exception e) {
            RightProperGUIScaleConfig.logRegistrationFailure(e);
        }
    }

    private static void logRegistrationFailure(@NonNull Exception e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        RightProperGUIScale.logger.error(CONFIG_REGISTRATION_FAILED, (Throwable)e);
    }

    private RightProperGUIScaleConfig() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        GUI_SCALE_MAX = 10.0;
        GUI_SCALE_STEP = 0.1;
    }
}

