/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.coremods.antiidconflict.managers;

import code.elix_x.coremods.antiidconflict.AntiIdConflictBase;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.ArrayUtils;

public class PotionsManager {
    public static String freePotionIDs = "";
    public static String occupiedPotionIDs = "";
    public static String conflictedIds = "";
    public static boolean crashIfConflict;
    public static boolean debug;
    public static int freeIds;
    public static int occupiedIds;
    public static int IconflictedIds;
    public static ConflictingPotions[] conflicts;

    public static void preinit(FMLPreInitializationEvent event) throws Exception {
        AntiIdConflictBase.potionsFolder = new File(AntiIdConflictBase.mainFolder, "\\potions");
        AntiIdConflictBase.potionsFolder.mkdir();
        PotionsManager.setUpPotionFolder();
    }

    public static void init(FMLInitializationEvent event) {
    }

    public static void postinit(FMLPostInitializationEvent event) throws Exception {
        PotionsManager.updateConflictedArrays();
        PotionsManager.updatePotionFolder();
        PotionsManager.crash();
    }

    public static void setUpPotionFolder() throws Exception {
        File conf = new File(AntiIdConflictBase.potionsFolder, "\\main.cfg");
        conf.createNewFile();
        Configuration config = new Configuration(conf);
        config.load();
        crashIfConflict = config.getBoolean("crashIfConflict", "Settings of reaction to repeated ids", true, "If mod detects potion trying to override old one, force Minecraft to crash.\nRecommendation: do not tuch, may lead to worlds problems");
        debug = config.getBoolean("debug", "Settings of console output", false, "Enable debugging messages in console");
        config.save();
    }

    /*
     * WARNING - void declaration
     */
    public static void updatePotionFolder() throws Exception {
        Object writer;
        block21: {
            void var0_1;
            boolean bl = false;
            while (var0_1 < Potion.field_76425_a.length) {
                if (Potion.field_76425_a[var0_1] == null) {
                    freePotionIDs = freePotionIDs + (int)var0_1 + "\n";
                    ++freeIds;
                }
                ++var0_1;
            }
            for (Potion potion : Potion.field_76425_a) {
                if (potion == null) continue;
                occupiedPotionIDs = occupiedPotionIDs + potion.field_76415_H + " : " + potion.func_76393_a() + " (" + potion.getClass().getName() + ")\n";
                ++occupiedIds;
            }
            for (ConflictingPotions conflictingPotions : conflicts) {
                if (conflictingPotions == null) continue;
                if (debug) {
                    System.out.println("Found potions id conflict for " + conflictingPotions.ID + " : " + conflictingPotions.getCrashMessage());
                }
                conflictedIds = conflictedIds + conflictingPotions.getCrashMessage() + "\n";
                ++IconflictedIds;
            }
            File file = new File(AntiIdConflictBase.potionsFolder, "\\avaibleIDs.txt");
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PrintWriter writer2 = new PrintWriter(file);
            writer2.println("Total amount of free potion ids: " + file);
            writer2.println("List of free potion ids:");
            for (String s : freePotionIDs.split("\n")) {
                writer2.println(s);
            }
            writer2.close();
            int n = occupiedIds;
            File occupiedIds = new File(AntiIdConflictBase.potionsFolder, "\\occupiedIDs.txt");
            if (occupiedIds.exists()) {
                occupiedIds.delete();
            }
            occupiedIds.createNewFile();
            writer = new PrintWriter(occupiedIds);
            ((PrintWriter)writer).println("Total amount of occupied potion ids: " + n);
            ((PrintWriter)writer).println("Table of occupied potion ids and their owners");
            ((PrintWriter)writer).println("id:name(class)");
            String[] stringArray = occupiedPotionIDs.split("\n");
            int n2 = stringArray.length;
            for (int s = 0; s < n2; ++s) {
                String s2 = stringArray[s];
                ((PrintWriter)writer).println(s2);
            }
            ((PrintWriter)writer).close();
            File file2 = new File(AntiIdConflictBase.potionsFolder, "\\conflictedIDs.txt");
            if (file2.exists()) {
                file2.delete();
            }
            file2.createNewFile();
            PrintWriter writer3 = new PrintWriter(file2);
            writer3.println("Total amount of conflicted potion ids: " + IconflictedIds);
            writer3.println("IDs in conflict:\n");
            for (String s : conflictedIds.split("\n")) {
                writer3.println(s);
            }
            writer3.close();
            int n3 = PotionsManager.occupiedIds;
            File all = new File(AntiIdConflictBase.potionsFolder, "\\AllIDs.txt");
            writer = new PrintWriter(all);
            ((PrintWriter)writer).println("Total amount of free potion ids: " + freeIds);
            ((PrintWriter)writer).println("Total amount of occupied potion ids: " + n3);
            ((PrintWriter)writer).println("Total amount of conflicted potion ids: " + IconflictedIds);
            ((PrintWriter)writer).println("All ids and their position:");
            try {
                void var3_19;
                boolean bl2 = false;
                while (var3_19 < Potion.field_76425_a.length) {
                    block20: {
                        try {
                            if (!ArrayUtils.isEmpty((Object[])conflicts) && conflicts[var3_19] != null) {
                                ((PrintWriter)writer).println(conflicts[var3_19].getCrashMessage());
                            } else if (Potion.field_76425_a[var3_19] != null) {
                                ((PrintWriter)writer).println((int)var3_19 + " is Occupied by " + Potion.field_76425_a[var3_19].func_76393_a() + " (" + Potion.field_76425_a[var3_19].getClass().getName() + ")");
                            } else {
                                ((PrintWriter)writer).println((int)var3_19 + " is Avaible");
                            }
                        }
                        catch (Exception e) {
                            if (!debug) break block20;
                            e.printStackTrace();
                        }
                    }
                    ++var3_19;
                }
            }
            catch (Exception exception) {
                if (!debug) break block21;
                exception.printStackTrace();
            }
        }
        ((PrintWriter)writer).close();
    }

    public static int getPotionID(int id) {
        if (Potion.field_76425_a[id] != null) {
            if (debug) {
                System.out.println("Detected potion conflict for id " + id + (crashIfConflict ? " Game will crash!" : ""));
            }
            Potion potion = Potion.field_76425_a[id];
            ConflictingPotions conflict = conflicts[id];
            if (conflict == null) {
                conflict = new ConflictingPotions(id, potion);
            }
            PotionsManager.conflicts[id] = conflict;
        }
        PotionsManager.updateConflictedArrays();
        return id;
    }

    public static void updateConflictedArrays() {
        for (ConflictingPotions conflict : conflicts) {
            if (conflict == null) continue;
            conflict.updateArray();
        }
    }

    private static void crash() throws PotionsIDConflictException {
        if (ArrayUtils.isEmpty((Object[])conflicts)) {
            if (debug) {
                System.out.println("No conflicts found");
            }
            return;
        }
        if (crashIfConflict) {
            for (ConflictingPotions conflict : conflicts) {
                if (conflict == null) continue;
                String report = "Conflict between potions with same id caused game to crash.\nAffected ids:\n" + conflictedIds;
                if (debug) {
                    System.out.println(report);
                }
                CrashReport crash = new CrashReport("Conflicting potions forced game to crash: ", (Throwable)new PotionsIDConflictException(report));
                Minecraft.func_71410_x().func_71404_a(crash);
            }
        }
    }

    static {
        freeIds = 0;
        occupiedIds = 0;
        IconflictedIds = 0;
        conflicts = new ConflictingPotions[1028];
    }

    public static class PotionsIDConflictException
    extends Exception {
        public PotionsIDConflictException(String s) {
            super(s);
        }
    }

    public static class ConflictingPotions {
        public Potion[] potions = new Potion[Potion.field_76425_a.length];
        public int ID;

        public ConflictingPotions(int id, Potion potion) {
            this.ID = id;
            this.potions[0] = potion;
        }

        public void updateArray() {
            Potion potion = Potion.field_76425_a[this.ID];
            if (potion != null) {
                boolean p = ArrayUtils.contains((Object[])this.potions, (Object)potion);
                for (Potion b : this.potions) {
                    if (b == null) continue;
                    p |= b.equals(potion) || b.func_76393_a().equals(potion.func_76393_a()) && b.getClass().getName().equals(potion.getClass().getName());
                }
                if (!p) {
                    this.potions = (Potion[])ArrayUtils.add((Object[])this.potions, (Object)Potion.field_76425_a[this.ID]);
                }
            }
        }

        public String getCrashMessage() {
            String s = "";
            s = s + this.ID + " is asked by: ";
            boolean flag = false;
            for (Potion potion : this.potions) {
                if (potion == null) continue;
                if (flag) {
                    s = s + ", ";
                } else {
                    flag = true;
                }
                s = s + potion.func_76393_a();
                s = s + " (";
                s = s + potion.getClass().getName();
                s = s + ")";
            }
            return s;
        }
    }
}

