/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.coremods.antiidconflict.managers;

import code.elix_x.coremods.antiidconflict.AntiIdConflictBase;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;

public class DimensionsManager {
    public static String avaibleIDs = "";
    public static String occupiedIDs = "";
    public static String conflictedIDs = "";
    public static int lowerLimit = -100;
    public static int upperLimit = 100;

    public static void preinit(FMLPreInitializationEvent event) throws Exception {
        AntiIdConflictBase.dimensionsFolder = new File(AntiIdConflictBase.mainFolder, "\\dimensions");
        AntiIdConflictBase.dimensionsFolder.mkdir();
        DimensionsManager.setUpDimensionsFolder();
    }

    public static void init(FMLInitializationEvent event) {
    }

    public static void postinit(FMLPostInitializationEvent event) throws Exception {
        DimensionsManager.updateDimensionsFolder();
    }

    public static void setUpDimensionsFolder() throws Exception {
        File conf = new File(AntiIdConflictBase.dimensionsFolder, "\\main.cfg");
        conf.createNewFile();
        Configuration config = new Configuration(conf);
        config.load();
        lowerLimit = config.getInt("lowerLimit", "scanning", -100, Integer.MIN_VALUE, Integer.MAX_VALUE, "Lower limit for free id scanning");
        upperLimit = config.getInt("upperLimit", "scanning", 100, Integer.MIN_VALUE, Integer.MAX_VALUE, "Upper limit for free id scanning");
        config.save();
    }

    public static void updateDimensionsFolder() throws Exception {
        Hashtable providers = (Hashtable)ReflectionHelper.getPrivateValue(DimensionManager.class, null, (String[])new String[]{"providers"});
        for (int i = lowerLimit; i <= upperLimit; ++i) {
            if (DimensionManager.isDimensionRegistered((int)i)) {
                try {
                    occupiedIDs = occupiedIDs + i + " : " + DimensionManager.getProvider((int)i).func_80007_l() + ", Provider: (id: " + DimensionManager.getProviderType((int)i) + ", class: " + DimensionManager.getProvider((int)i).getClass() + ")" + "\n";
                }
                catch (Exception e) {
                    int providerId = DimensionManager.getProviderType((int)i);
                    Class clas = (Class)providers.get(providerId);
                    String name = null;
                    try {
                        WorldProvider pr = (WorldProvider)clas.newInstance();
                        name = pr.func_80007_l();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    occupiedIDs = occupiedIDs + i + " : " + (name == null ? "" : name + ", ") + "Provider: (id: " + DimensionManager.getProviderType((int)i) + ", class: " + clas + ")" + "\n";
                }
                continue;
            }
            avaibleIDs = avaibleIDs + i + "\n";
        }
        File freeIds = new File(AntiIdConflictBase.dimensionsFolder, "\\avaibleIDs.txt");
        if (freeIds.exists()) {
            freeIds.delete();
        }
        freeIds.createNewFile();
        PrintWriter writer = new PrintWriter(freeIds);
        writer.println("List of avaible dimension ids:");
        for (String s : avaibleIDs.split("\n")) {
            writer.println(s);
        }
        writer.close();
        File occupiedIds = new File(AntiIdConflictBase.dimensionsFolder, "\\occupiedIDs.txt");
        if (occupiedIds.exists()) {
            occupiedIds.delete();
        }
        occupiedIds.createNewFile();
        writer = new PrintWriter(occupiedIds);
        writer.println("Table of occupied dimension ids and their owners\nid:name(class)");
        for (String s : occupiedIDs.split("\n")) {
            writer.println(s);
        }
        writer.close();
        File all = new File(AntiIdConflictBase.dimensionsFolder, "\\AllIDs.txt");
        writer = new PrintWriter(all);
        Hashtable providers2 = (Hashtable)ReflectionHelper.getPrivateValue(DimensionManager.class, null, (String[])new String[]{"providers"});
        for (int i = lowerLimit; i <= upperLimit; ++i) {
            if (DimensionManager.isDimensionRegistered((int)i)) {
                try {
                    writer.println(i + " is Occupied by: " + DimensionManager.getProvider((int)i).func_80007_l() + ", Provider: (id: " + DimensionManager.getProviderType((int)i) + ", class: " + DimensionManager.getProvider((int)i).getClass() + ")");
                }
                catch (Exception e) {
                    int providerId = DimensionManager.getProviderType((int)i);
                    Class clas = (Class)providers2.get(providerId);
                    String name = null;
                    try {
                        WorldProvider pr = (WorldProvider)clas.newInstance();
                        name = pr.func_80007_l();
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    writer.println(i + " is Occupied by: " + (name == null ? "" : name + ", ") + "Provider: (id: " + DimensionManager.getProviderType((int)i) + ", class: " + clas + ")");
                }
                continue;
            }
            writer.println(i + " is Avaible");
        }
        writer.close();
    }
}

