/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.utils;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;
import net.p455w0rd.wirelesscraftingterminal.items.ItemMagnet;

public class RandomUtils {
    public static boolean isBaublesLoaded = Loader.isModLoaded((String)"Baubles");

    @SideOnly(value=Side.CLIENT)
    public static String color(String color) {
        switch (color) {
            case "white": {
                return EnumChatFormatting.WHITE.toString();
            }
            case "black": {
                return EnumChatFormatting.BLACK.toString();
            }
            case "green": {
                return EnumChatFormatting.GREEN.toString();
            }
            case "red": {
                return EnumChatFormatting.RED.toString();
            }
            case "yellow": {
                return EnumChatFormatting.YELLOW.toString();
            }
            case "aqua": {
                return EnumChatFormatting.AQUA.toString();
            }
            case "blue": {
                return EnumChatFormatting.BLUE.toString();
            }
            case "italics": {
                return EnumChatFormatting.ITALIC.toString();
            }
            case "bold": {
                return EnumChatFormatting.BOLD.toString();
            }
        }
        return EnumChatFormatting.GRAY.toString();
    }

    public static ItemStack getWirelessTerm(InventoryPlayer playerInv) {
        IInventory handler;
        if (playerInv.field_70458_d.func_70694_bm() != null && playerInv.field_70458_d.func_70694_bm().func_77973_b() instanceof IWirelessCraftingTerminalItem) {
            return playerInv.field_70458_d.func_70694_bm();
        }
        ItemStack wirelessTerm = null;
        int invSize = playerInv.func_70302_i_();
        if (invSize <= 0) {
            return null;
        }
        for (int i = 0; i < invSize; ++i) {
            ItemStack item = playerInv.func_70301_a(i);
            if (item == null || !(item.func_77973_b() instanceof IWirelessCraftingTerminalItem)) continue;
            wirelessTerm = item;
            break;
        }
        if (isBaublesLoaded && (handler = BaublesApi.getBaubles((EntityPlayer)playerInv.field_70458_d)) != null) {
            invSize = handler.func_70302_i_();
            for (int i = 0; i < invSize; ++i) {
                ItemStack item = handler.func_70301_a(i);
                if (item == null || !(item.func_77973_b() instanceof IWirelessCraftingTerminalItem)) continue;
                wirelessTerm = item;
                break;
            }
        }
        return wirelessTerm;
    }

    public static ItemStack getMagnet(InventoryPlayer playerInv) {
        NBTTagList magnetSlot;
        ItemStack magnetItem;
        NBTTagCompound nbtTC;
        if (playerInv.field_70458_d.func_70694_bm() != null && playerInv.field_70458_d.func_70694_bm().func_77973_b() instanceof ItemMagnet) {
            return playerInv.field_70458_d.func_70694_bm();
        }
        ItemStack wirelessTerm = RandomUtils.getWirelessTerm(playerInv);
        if (wirelessTerm != null && wirelessTerm.func_77973_b() instanceof IWirelessCraftingTerminalItem && (nbtTC = wirelessTerm.func_77978_p()).func_74764_b("MagnetSlot") && (magnetItem = ItemStack.func_77949_a((NBTTagCompound)(magnetSlot = nbtTC.func_150295_c("MagnetSlot", 10)).func_150305_b(0))) != null && magnetItem.func_77973_b() instanceof ItemMagnet) {
            return magnetItem;
        }
        int invSize = playerInv.func_70302_i_();
        ItemStack magnetItem2 = null;
        if (invSize <= 0) {
            return null;
        }
        for (int i = 0; i < invSize; ++i) {
            ItemStack item = playerInv.func_70301_a(i);
            if (item == null || !(item.func_77973_b() instanceof ItemMagnet)) continue;
            magnetItem2 = item;
            break;
        }
        return magnetItem2;
    }

    public static boolean isMagnetInitialized(ItemStack magnetItem) {
        if (magnetItem != null && magnetItem.func_77973_b() instanceof ItemMagnet && magnetItem.func_77942_o() && magnetItem.func_77978_p().func_74764_b("Initialized")) {
            return magnetItem.func_77978_p().func_74767_n("Initialized");
        }
        return false;
    }

    public static boolean isMagnetInstalled(InventoryPlayer ip) {
        ItemStack magnetItem;
        NBTTagCompound magnetNBTForm = RandomUtils.getWirelessTerm(ip).func_77978_p().func_150295_c("MagnetSlot", 10).func_150305_b(0);
        return magnetNBTForm != null && (magnetItem = ItemStack.func_77949_a((NBTTagCompound)magnetNBTForm)) != null && magnetItem.func_77973_b() instanceof ItemMagnet;
    }

    public static boolean readBoolean(ItemStack is, String key) {
        if (is == null) {
            return false;
        }
        NBTTagCompound tag = RandomUtils.getTag(is);
        return tag.func_74764_b(key) ? tag.func_74767_n(key) : false;
    }

    public static int readInt(ItemStack is, String key) {
        if (is == null) {
            return 0;
        }
        NBTTagCompound tag = RandomUtils.getTag(is);
        return tag.func_74764_b(key) ? tag.func_74762_e(key) : -1;
    }

    public static void writeInt(ItemStack is, String key, int value) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = RandomUtils.getTag(is);
        tag.func_74768_a(key, value);
    }

    public static void writeBoolean(ItemStack is, String key, boolean value) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = RandomUtils.getTag(is);
        tag.func_74757_a(key, value);
    }

    public static void delKey(ItemStack is, String key) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = RandomUtils.getTag(is);
        tag.func_82580_o(key);
    }

    public static NBTTagCompound getTag(ItemStack is) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        return is.func_77978_p();
    }

    public static ItemStack readStack(NBTTagCompound nbtTC, String key) {
        return nbtTC.func_74764_b(key) ? ItemStack.func_77949_a((NBTTagCompound)nbtTC) : null;
    }

    public static void removeTimerTags(ItemStack is) {
        if (is == null || is.func_77978_p() == null) {
            return;
        }
        if (is.func_77978_p().func_74764_b("WCTReset")) {
            is.func_77982_d(null);
        }
        if (is.func_77978_p() != null && is.func_77978_p().func_74764_b("WCTPickupTimer")) {
            is.func_77978_p().func_82580_o("WCTPickupTimer");
        }
    }
}

