/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.plugins.te;

import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import mantle.utils.ItemMetaWrapper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.crafting.Smeltery;
import us.drullk.thermalsmeltery.ThermalSmeltery;
import us.drullk.thermalsmeltery.common.blocks.MachineHelper;
import us.drullk.thermalsmeltery.common.blocks.ModBlocks;
import us.drullk.thermalsmeltery.common.core.handler.TSmeltConfig;
import us.drullk.thermalsmeltery.common.gui.GuiHandler;
import us.drullk.thermalsmeltery.common.items.TSItems;
import us.drullk.thermalsmeltery.common.network.PacketThermalSmeltery;
import us.drullk.thermalsmeltery.common.plugins.te.TE4Helper;

@GameRegistry.ObjectHolder(value="ThermalSmeltery")
@Pulse(id="TSmelt TE", description="Thermal Expansion Integration", modsRequired="ThermalExpansion")
public class TSmeltTE {
    ItemStack nullifier;

    @Handler
    public void preInit(FMLPostInitializationEvent event) {
        MachineHelper.initialize();
        ModBlocks.initialize();
        PacketThermalSmeltery.initialize();
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)ThermalSmeltery.instance, (IGuiHandler)new GuiHandler());
    }

    @Handler
    public void postInit(FMLPostInitializationEvent event) {
        Map smelteryMap = Smeltery.getSmeltingList();
        Map tempMap = Smeltery.getTemperatureList();
        for (Map.Entry entry : smelteryMap.entrySet()) {
            ItemStack input = new ItemStack(((ItemMetaWrapper)entry.getKey()).item, 1, ((ItemMetaWrapper)entry.getKey()).meta.intValue());
            int energy = (Integer)tempMap.get(entry.getKey()) * TSmeltConfig.multiplier;
            TE4Helper.addCrucibleRecipe(energy, input, (FluidStack)entry.getValue());
        }
        this.nullifier = new ItemStack(GameRegistry.findItem((String)"ThermalExpansion", (String)"Device"), 1, 5);
        TE4Helper.addPulverizerRecipe(20000, this.nullifier, new ItemStack((Item)TSItems.itemBase, 1, 0));
        TE4Helper.addPulveriserRecipe(1337, new ItemStack(Items.field_151174_bG), TSItems.potatoesMashed, ItemHelper.cloneStack((ItemStack)TSItems.potatoesWedge, (int)2), 10);
        ModBlocks.postInit();
    }
}

