/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.plugins.eio.smeltery;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import mantle.blocks.BlockUtils;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.Smeltery;
import tconstruct.smeltery.TinkerSmeltery;
import us.drullk.thermalsmeltery.ThermalSmeltery;
import us.drullk.thermalsmeltery.common.core.handler.TSmeltConfig;
import us.drullk.thermalsmeltery.common.plugins.eio.smeltery.FilledBucket;
import us.drullk.thermalsmeltery.common.plugins.eio.smeltery.FluidHelper;

@Pulse(id="TSmelt EIO Smeltery", description="TCon Smeltery Integration for EnderIO", modsRequired="TConstruct;EnderIO")
public class EnderIOSmeltery {
    public static Item buckets;
    public static Fluid moltenEnergeticFluid;
    public static Fluid moltenVibrantFluid;
    public static Fluid moltenConductiveIronFluid;
    public static Fluid moltenPulsatingIronFluid;
    public static Fluid moltenDarkSteelFluid;
    public static Block moltenEnergetic;
    public static Block moltenVibrant;
    public static Block moltenConductiveIron;
    public static Block moltenPulsatingIron;
    public static Block moltenDarkSteel;
    public static Fluid[] fluids;
    public static Block[] fluidBlocks;
    private static FluidStack moltenRedstoneDust;
    private static FluidStack moltenGlowstoneDust;
    private static FluidStack moltenEnder;
    private static FluidStack moltenIronIngot;
    private static FluidStack moltenGoldIngot;
    private static FluidStack moltenSteelIngot;
    private static ItemStack itemSiliconStack;

    @Handler
    public void preInit(FMLPreInitializationEvent event) {
        buckets = new FilledBucket(BlockUtils.getBlockFromItem((Item)buckets));
        GameRegistry.registerItem((Item)buckets, (String)"buckets");
        moltenEnergeticFluid = FluidHelper.registerFluid("EnergeticAlloy");
        moltenEnergetic = moltenEnergeticFluid.getBlock();
        moltenVibrantFluid = FluidHelper.registerFluid("PhasedGold");
        moltenVibrant = moltenVibrantFluid.getBlock();
        moltenConductiveIronFluid = FluidHelper.registerFluid("ConductiveIron");
        moltenConductiveIron = moltenConductiveIronFluid.getBlock();
        moltenPulsatingIronFluid = FluidHelper.registerFluid("PhasedIron");
        moltenPulsatingIron = moltenPulsatingIronFluid.getBlock();
        moltenDarkSteelFluid = FluidHelper.registerFluid("DarkSteel");
        moltenDarkSteel = moltenDarkSteelFluid.getBlock();
        fluids = new Fluid[]{moltenEnergeticFluid, moltenVibrantFluid, moltenConductiveIronFluid, moltenPulsatingIronFluid, moltenDarkSteelFluid};
        fluidBlocks = new Block[]{moltenEnergetic, moltenVibrant, moltenConductiveIron, moltenPulsatingIron, moltenDarkSteel};
        FluidType.registerFluidType((String)"EnergeticAlloy", (Block)GameRegistry.findBlock((String)"EnderIO", (String)"blockIngotStorage"), (int)1, (int)650, (Fluid)moltenEnergeticFluid, (boolean)false);
        FluidType.registerFluidType((String)"PhasedGold", (Block)GameRegistry.findBlock((String)"EnderIO", (String)"blockIngotStorage"), (int)2, (int)750, (Fluid)moltenVibrantFluid, (boolean)false);
        FluidType.registerFluidType((String)"ConductiveIron", (Block)GameRegistry.findBlock((String)"EnderIO", (String)"blockIngotStorage"), (int)4, (int)500, (Fluid)moltenConductiveIronFluid, (boolean)false);
        FluidType.registerFluidType((String)"PhasedIron", (Block)GameRegistry.findBlock((String)"EnderIO", (String)"blockIngotStorage"), (int)5, (int)500, (Fluid)moltenPulsatingIronFluid, (boolean)false);
        FluidType.registerFluidType((String)"DarkSteel", (Block)GameRegistry.findBlock((String)"EnderIO", (String)"blockIngotStorage"), (int)6, (int)850, (Fluid)moltenDarkSteelFluid, (boolean)false);
    }

    @Handler
    public void init(FMLInitializationEvent event) {
        if (TConstruct.pulsar.isPulseLoaded("Tinkers' Smeltery")) {
            moltenRedstoneDust = new FluidStack(FluidRegistry.getFluid((String)"redstone"), 100);
            moltenGlowstoneDust = new FluidStack(FluidRegistry.getFluid((String)"glowstone"), 250);
            moltenEnder = new FluidStack(FluidRegistry.getFluid((String)"ender"), 250);
            moltenIronIngot = new FluidStack(FluidRegistry.getFluid((String)"iron.molten"), 144);
            moltenGoldIngot = new FluidStack(FluidRegistry.getFluid((String)"gold.molten"), 144);
            moltenSteelIngot = new FluidStack(FluidRegistry.getFluid((String)"steel.molten"), 144);
            itemSiliconStack = new ItemStack(GameRegistry.findItem((String)"EnderIO", (String)"itemMaterial"), 1, 0);
            ItemStack ingotcast = new ItemStack(TinkerSmeltery.metalPattern, 1, 0);
            LiquidCasting tableCasting = TConstructRegistry.getTableCasting();
            LiquidCasting basinCasting = TConstructRegistry.getBasinCasting();
            String[] orePrefix = new String[]{"block", "nugget", "ingot"};
            int[] oreAmounts = new int[]{1296, 16, 144};
            String[] fluidNames = new String[]{"EnergeticAlloy", "PhasedGold", "ConductiveIron", "PhasedIron", "DarkSteel"};
            if (TSmeltConfig.EIOAddMetalCasting) {
                for (int c = 0; c < fluidNames.length; ++c) {
                    if (OreDictionary.doesOreNameExist((String)("ingot" + fluidNames[c]))) {
                        tableCasting.addCastingRecipe((ItemStack)OreDictionary.getOres((String)("ingot" + fluidNames[c])).get(0), new FluidStack(fluids[c], 144), ingotcast, 50);
                        ThermalSmeltery.logger.info("Added block" + fluidNames[c] + " to TCon Casting Table");
                    } else {
                        ThermalSmeltery.logger.info("Skipping registration of casting ingot" + fluidNames[c]);
                    }
                    if (OreDictionary.doesOreNameExist((String)("block" + fluidNames[c]))) {
                        basinCasting.addCastingRecipe((ItemStack)OreDictionary.getOres((String)("block" + fluidNames[c])).get(0), new FluidStack(fluids[c], 1296), 150);
                        ThermalSmeltery.logger.info("Added block" + fluidNames[c] + " to TCon Casting Basin");
                    } else {
                        ThermalSmeltery.logger.info("Skipping registration of casting block" + fluidNames[c]);
                    }
                    for (int i = 0; i < orePrefix.length; ++i) {
                        if (!OreDictionary.doesOreNameExist((String)(orePrefix[i] + fluidNames[c]))) continue;
                        Smeltery.addDictionaryMelting((String)(orePrefix[i] + fluidNames[c]), (FluidType)FluidType.getFluidType((Fluid)fluids[c]), (int)0, (int)oreAmounts[i]);
                    }
                    tableCasting.addCastingRecipe(new ItemStack(GameRegistry.findItem((String)"ThermalSmeltery", (String)"buckets"), 1, c), new FluidStack(fluids[c], 1000), new ItemStack(Items.field_151133_ar, 1, 0), true, 50);
                }
            }
            if (TSmeltConfig.EIOElectricalSteelCasting && Loader.isModLoaded((String)"EnderIO")) {
                tableCasting.addCastingRecipe(new ItemStack(GameRegistry.findItem((String)"EnderIO", (String)"itemAlloy"), 1, 0), moltenSteelIngot, itemSiliconStack, true, 60);
            }
            if (TSmeltConfig.EIOEnergeticAlloyRecipe && Loader.isModLoaded((String)"EnderIO")) {
                Smeltery.addAlloyMixing((FluidStack)new FluidStack(moltenEnergeticFluid, 144), (FluidStack[])new FluidStack[]{moltenGoldIngot, moltenRedstoneDust, moltenGlowstoneDust});
            }
            if (TSmeltConfig.EIOVibrantAlloyRecipe && Loader.isModLoaded((String)"EnderIO")) {
                Smeltery.addAlloyMixing((FluidStack)new FluidStack(moltenVibrantFluid, 144), (FluidStack[])new FluidStack[]{new FluidStack(moltenEnergeticFluid, 144), moltenEnder});
            }
            if (TSmeltConfig.EIORedstoneAlloyCasting && Loader.isModLoaded((String)"EnderIO")) {
                tableCasting.addCastingRecipe(new ItemStack(GameRegistry.findItem((String)"EnderIO", (String)"itemAlloy"), 1, 3), moltenRedstoneDust, itemSiliconStack, true, 50);
            }
            if (TSmeltConfig.EIOConductiveIronRecipe && Loader.isModLoaded((String)"EnderIO")) {
                Smeltery.addAlloyMixing((FluidStack)new FluidStack(moltenConductiveIronFluid, 144), (FluidStack[])new FluidStack[]{moltenIronIngot, moltenRedstoneDust});
            }
            if (TSmeltConfig.EIOPulsatingIronRecipe && Loader.isModLoaded((String)"EnderIO")) {
                Smeltery.addAlloyMixing((FluidStack)new FluidStack(moltenPulsatingIronFluid, 144), (FluidStack[])new FluidStack[]{moltenIronIngot, moltenEnder});
            }
            if (TSmeltConfig.EIODarkSteelRecipe && Loader.isModLoaded((String)"EnderIO")) {
                Smeltery.addAlloyMixing((FluidStack)new FluidStack(moltenDarkSteelFluid, 144), (FluidStack[])new FluidStack[]{moltenSteelIngot, new FluidStack(FluidRegistry.getFluid((String)"obsidian.molten"), 288)});
            }
            if (TSmeltConfig.EIOSoulariumCasting && Loader.isModLoaded((String)"EnderIO")) {
                tableCasting.addCastingRecipe(new ItemStack(GameRegistry.findItem((String)"EnderIO", (String)"itemAlloy"), 1, 7), moltenGoldIngot, new ItemStack(Blocks.field_150425_aM, 1, 0), true, 75);
            }
        } else {
            ThermalSmeltery.logger.warn("Tinker's Smeltery is disabled, Adding EIO alloy mixing and casting disabled.");
        }
    }

    static {
        fluids = new Fluid[5];
        fluidBlocks = new Block[5];
    }
}

