/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.gui.container;

import cofh.api.tileentity.IAugmentable;
import cofh.core.block.TileCoFHBase;
import cofh.core.gui.slot.SlotAugment;
import cofh.lib.gui.container.IAugmentableContainer;
import cofh.lib.gui.slot.SlotFalseCopy;
import cofh.lib.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import us.drullk.thermalsmeltery.common.network.PacketThermalSmeltery;

public class ContainerMachineBase
extends Container
implements IAugmentableContainer {
    TileCoFHBase baseTile;
    protected Slot[] augmentSlots = new Slot[0];
    protected boolean[] augmentStatus = new boolean[0];
    protected boolean augmentLock = true;

    public ContainerMachineBase(InventoryPlayer player, TileEntity tile) {
        if (tile instanceof TileCoFHBase) {
            this.baseTile = (TileCoFHBase)tile;
        }
        this.addAugmentSlots();
        this.addPlayerInventory(player);
    }

    protected void addAugmentSlots() {
        if (this.baseTile instanceof IAugmentable) {
            this.augmentSlots = new Slot[((IAugmentable)this.baseTile).getAugmentSlots().length];
            for (int slot = 0; slot < this.augmentSlots.length; ++slot) {
                this.augmentSlots[slot] = this.func_75146_a((Slot)new SlotAugment((IAugmentable)this.baseTile, null, slot, 0, 0));
            }
        }
    }

    protected void addPlayerInventory(InventoryPlayer inventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)inventory, column + i * 9 + 9, 8 + column * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 142));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.baseTile == null || this.baseTile.isUseable(player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.baseTile != null) {
            for (Object crafter : this.field_75149_d) {
                this.baseTile.sendGuiNetworkData((Container)this, (ICrafting)crafter);
            }
        }
    }

    public void func_75137_b(int i, int j) {
        if (this.baseTile != null) {
            this.baseTile.receiveGuiNetworkData(i, j);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        ItemStack stack = null;
        Slot slotObj = (Slot)this.field_75151_b.get(slot);
        int aug = this.augmentSlots.length;
        int playerMain = aug + 27;
        int playerTool = playerMain + 9;
        int tileInv = playerTool + (this.baseTile == null ? 0 : this.baseTile.getInvSlotCount());
        if (slotObj != null && slotObj.func_75216_d()) {
            ItemStack slotStack = slotObj.func_75211_c();
            stack = slotStack.func_77946_l();
            if (slot < aug ? !this.func_75135_a(slotStack, aug, playerTool, true) : (slot < playerTool ? (!this.augmentLock && aug > 0 && AugmentHelper.isAugmentItem((ItemStack)slotStack) ? !this.func_75135_a(slotStack, 0, aug, false) : !this.func_75135_a(slotStack, playerTool, tileInv, false)) : !this.func_75135_a(slotStack, aug, playerTool, true))) {
                return null;
            }
            if (slotStack.field_77994_a <= 0) {
                slotObj.func_75215_d(null);
            } else {
                slotObj.func_75218_e();
            }
            if (slotStack.field_77994_a == stack.field_77994_a) {
                return null;
            }
        }
        return stack;
    }

    public ItemStack func_75144_a(int slot, int mouse, int var3, EntityPlayer player) {
        Slot slotObj;
        Slot slot2 = slotObj = slot < 0 ? null : (Slot)this.field_75151_b.get(slot);
        if (slotObj instanceof SlotFalseCopy) {
            if (mouse == 2) {
                slotObj.func_75215_d(null);
                slotObj.func_75218_e();
            } else {
                slotObj.func_75215_d(player.field_71071_by.func_70445_o() == null ? null : player.field_71071_by.func_70445_o().func_77946_l());
            }
            return player.field_71071_by.func_70445_o();
        }
        return super.func_75144_a(slot, mouse, var3, player);
    }

    protected boolean func_75135_a(ItemStack stack, int start, int end, boolean reverse) {
        ItemStack slotStack;
        Slot slotObj;
        int slot;
        boolean merge = false;
        int n = slot = reverse ? end - 1 : start;
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!reverse && slot < end || reverse && slot >= start)) {
                slotObj = (Slot)this.field_75151_b.get(slot);
                slotStack = slotObj.func_75211_c();
                if (slotObj.func_75214_a(stack) && ItemHelper.itemsEqualWithMetadata((ItemStack)stack, (ItemStack)slotStack, (boolean)true)) {
                    int stackAmount = slotStack.field_77994_a + stack.field_77994_a;
                    int maxAmount = Math.min(stack.func_77976_d(), slotObj.func_75219_a());
                    if (stackAmount <= maxAmount) {
                        stack.field_77994_a = 0;
                        slotStack.field_77994_a = stackAmount;
                        slotObj.func_75218_e();
                        merge = true;
                    } else if (slotStack.field_77994_a < maxAmount) {
                        stack.field_77994_a -= maxAmount - slotStack.field_77994_a;
                        slotStack.field_77994_a = maxAmount;
                        slotObj.func_75218_e();
                        merge = true;
                    }
                }
                slot += reverse ? -1 : 1;
            }
        }
        if (stack.field_77994_a > 0) {
            int n2 = slot = reverse ? end - 1 : start;
            while (!reverse && slot < end || reverse && slot >= start) {
                slotObj = (Slot)this.field_75151_b.get(slot);
                slotStack = slotObj.func_75211_c();
                if (slotObj.func_75214_a(stack) && slotStack == null) {
                    slotObj.func_75215_d(ItemHelper.cloneStack((ItemStack)stack, (int)Math.min(stack.field_77994_a, slotObj.func_75219_a())));
                    slotObj.func_75218_e();
                    if (slotObj.func_75211_c() == null) break;
                    stack.field_77994_a -= slotObj.func_75211_c().field_77994_a;
                    merge = true;
                    break;
                }
                slot += reverse ? -1 : 1;
            }
        }
        return merge;
    }

    public void setAugmentLock(boolean lock) {
        this.augmentLock = lock;
        if (ServerHelper.isClientWorld((World)this.baseTile.func_145831_w())) {
            PacketThermalSmeltery.sendTabAugmentPacketToServer(lock);
        }
    }

    public Slot[] getAugmentSlots() {
        return this.augmentSlots;
    }
}

