/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.gui.client;

import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabAugment;
import cofh.core.gui.element.TabConfiguration;
import cofh.core.gui.element.TabEnergy;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabRedstone;
import cofh.core.gui.element.TabSecurity;
import cofh.core.gui.element.TabTutorial;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.container.IAugmentableContainer;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.StringHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import us.drullk.thermalsmeltery.common.blocks.TileMachineBase;

public class GuiMachineBase
extends GuiBaseAdv {
    protected TileMachineBase myTile;
    protected UUID playerUUID;
    public String myInfo = "";
    public String myTutorial = StringHelper.tutorialTabAugment();
    protected TabBase redstoneTab;
    protected TabBase configTab;

    public GuiMachineBase(Container container, TileEntity tile, EntityPlayer player, ResourceLocation texture) {
        super(container, texture);
        this.myTile = (TileMachineBase)tile;
        this.name = this.myTile.func_145825_b();
        this.playerUUID = player.func_146103_bH().getId();
        if (this.myTile.enableSecurity() && this.myTile.isSecured()) {
            this.myTutorial = this.myTutorial + "\n\n" + StringHelper.tutorialTabSecurity();
        }
        if (this.myTile.augmentRedstoneControl) {
            this.myTutorial = this.myTutorial + "\n\n" + StringHelper.tutorialTabRedstone();
        }
        if (this.myTile.augmentReconfigSides) {
            this.myTutorial = this.myTutorial + "\n\n" + StringHelper.tutorialTabConfiguration();
        }
        if (this.myTile.getMaxEnergyStored(ForgeDirection.UNKNOWN) > 0) {
            this.myTutorial = this.myTutorial + "\n\n" + StringHelper.tutorialTabFluxRequired();
        }
    }

    protected void generateInfo(String var1, int var2) {
        this.myInfo = StringHelper.localize((String)(var1 + "." + 0));
        for (int var3 = 1; var3 < var2; ++var3) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)(var1 + "." + var3));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab((TabBase)new TabAugment((GuiBase)this, (IAugmentableContainer)this.field_147002_h));
        if (this.myTile.enableSecurity() && this.myTile.isSecured()) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)this.myTile, this.playerUUID));
        }
        this.redstoneTab = this.addTab((TabBase)new TabRedstone((GuiBase)this, (IRedstoneControl)this.myTile));
        this.configTab = this.addTab((TabBase)new TabConfiguration((GuiBase)this, (IReconfigurableFacing)this.myTile));
        if (this.myTile.getMaxEnergyStored(ForgeDirection.UNKNOWN) > 0) {
            this.addTab((TabBase)new TabEnergy((GuiBase)this, (IEnergyInfo)this.myTile, false));
        }
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        }
        this.addTab((TabBase)new TabTutorial((GuiBase)this, this.myTutorial));
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.myTile.canAccess()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void updateElementInformation() {
        super.updateElementInformation();
        this.redstoneTab.setVisible(this.myTile.augmentRedstoneControl);
        this.configTab.setVisible(this.myTile.augmentReconfigSides);
    }
}

