/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import us.drullk.thermalsmeltery.common.blocks.TileMachineBase;
import us.drullk.thermalsmeltery.common.core.handler.TSmeltConfig;
import us.drullk.thermalsmeltery.common.gui.client.GuiStamper;
import us.drullk.thermalsmeltery.common.gui.container.ContainerStamper;
import us.drullk.thermalsmeltery.common.plugins.tcon.smeltery.MachineRecipeRegistry;
import us.drullk.thermalsmeltery.common.plugins.tcon.smeltery.StampingRecipe;

public class TileStamper
extends TileMachineBase {
    static final int TYPE = 1;

    public int getType() {
        return 1;
    }

    public static void initialize() {
        TileStamper.defaultSideConfigSmeltery[1] = new TileMachineBase.SideConfig();
        TileStamper.defaultSideConfigSmeltery[1].numGroup = 7;
        TileStamper.defaultSideConfigSmeltery[1].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {3}, {2, 3}, {0}, {1}};
        TileStamper.defaultSideConfigSmeltery[1].allowInsertion = new boolean[]{false, true, false, false, false, true, true};
        TileStamper.defaultSideConfigSmeltery[1].allowExtraction = new boolean[]{false, false, true, true, true, false, false};
        TileStamper.defaultSideConfigSmeltery[1].sideTex = new int[]{0, 1, 2, 3, 4, 5, 6};
        TileStamper.defaultSideConfigSmeltery[1].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        int basePower = 400;
        TileStamper.defaultEnergyConfigSmeltery[1] = new TileMachineBase.EnergyConfig();
        defaultEnergyConfigSmeltery[1].setParams(basePower / 10, basePower, Math.max(480000, basePower * 1200));
        GameRegistry.registerTileEntity(TileStamper.class, (String)"thermalsmeltery.Stamper");
    }

    @Override
    protected int getInventorySize() {
        return 5;
    }

    @Override
    protected int getMaxInputSlot() {
        return 1;
    }

    @Override
    protected boolean hasRoomForOutput() {
        StampingRecipe recipe = this.getRecipe();
        ItemStack main = recipe.getMainResult();
        ItemStack secondary = recipe.getSecondaryResult();
        return this.canFit(main, 2) && this.canFit(secondary, 3);
    }

    @Override
    protected boolean hasValidInput() {
        return this.getRecipe() != null;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.getRecipeTime(this.getRecipe());
    }

    @Override
    protected void processFinish() {
        StampingRecipe recipe = this.getRecipe();
        ItemStack main = recipe.getMainResult();
        ItemStack secondary = recipe.getSecondaryResult();
        if (this.inventory[2] == null) {
            this.inventory[2] = main;
        } else {
            this.inventory[2].field_77994_a += main.field_77994_a;
        }
        if (secondary != null) {
            if (this.inventory[3] == null) {
                this.inventory[3] = secondary;
            } else {
                this.inventory[3].field_77994_a += secondary.field_77994_a;
            }
        }
        this.inventory[0].field_77994_a -= recipe.metal.field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    public boolean isItemValid(ItemStack itemStack, int slot, int i1) {
        return slot == 0 ? MachineRecipeRegistry.isValidMetal(itemStack) : slot == 1 && MachineRecipeRegistry.isValidCast(itemStack);
    }

    private StampingRecipe getRecipe() {
        return MachineRecipeRegistry.getStampingRecipe(this.inventory[0], this.inventory[1]);
    }

    private int getRecipeTime(StampingRecipe recipe) {
        if (recipe == null) {
            return 0;
        }
        return recipe.coolTime * 1000 * TSmeltConfig.stamperMultiplier;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiStamper(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerStamper(inventoryPlayer, (TileEntity)this);
    }
}

