/*
 * Decompiled with CFR 0.152.
 */
package cn.tesseract.mycelium.config;

import cn.tesseract.mycelium.config.Comment;
import cn.tesseract.mycelium.config.Config;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public abstract class ConfigProperties
extends Config {
    public ConfigProperties(File file) {
        super(file);
    }

    public ConfigProperties(String name) {
        super(name + ".properties");
    }

    @Override
    public void read() {
        this.fromProperties(this.readFile());
        this.save();
    }

    @Override
    public void save() {
        this.saveFile(this.toProperties());
    }

    public void from(Field f, String v) {
        Class<?> c = f.getType();
        try {
            if (c == Byte.TYPE) {
                f.set(this, Byte.valueOf(v));
            } else if (c == Short.TYPE) {
                f.set(this, Short.valueOf(v));
            } else if (c == Integer.TYPE) {
                f.set(this, Integer.valueOf(v));
            } else if (c == Long.TYPE) {
                f.set(this, Long.valueOf(v));
            } else if (c == Float.TYPE) {
                f.set(this, Float.valueOf(v));
            } else if (c == Double.TYPE) {
                f.set(this, Double.valueOf(v));
            } else if (c == Boolean.TYPE) {
                f.set(this, Boolean.valueOf(v));
            } else if (c == Character.TYPE) {
                f.set(this, Character.valueOf(v.toCharArray()[0]));
            } else if (c == String.class) {
                f.set(this, v);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String to(Field f, Object v) {
        return v.toString();
    }

    public void fromProperties(String ct) {
        Field[] fields = this.getClass().getDeclaredFields();
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : fields) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            map.put(field.getName(), field);
        }
        for (String line : ct.split("\n")) {
            String t = line.trim();
            if (t.isEmpty() || t.charAt(0) == '#') continue;
            String[] b = t.split("=", -1);
            String k = b[0].trim();
            String v = b[1].trim();
            Field f = (Field)map.get(k);
            if (f == null) continue;
            this.from(f, v);
        }
    }

    public String toProperties() {
        Field[] fields = this.getClass().getDeclaredFields();
        StringBuilder ct = new StringBuilder();
        for (Field field : fields) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            try {
                if (ct.length() != 0) {
                    ct.append("\n");
                }
                if (field.isAnnotationPresent(Comment.class)) {
                    ct.append("#").append(field.getAnnotation(Comment.class).value()).append("\n");
                }
                ct.append(field.getName()).append("=").append(this.to(field, field.get(this)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return ct.toString();
    }
}

