/*
 * Decompiled with CFR 0.152.
 */
package cn.tesseract.mycelium.asm.minecraft;

import cn.tesseract.mycelium.MyceliumCoreMod;
import cn.tesseract.mycelium.asm.AsmHook;
import cn.tesseract.mycelium.asm.HookClassTransformer;
import cn.tesseract.mycelium.asm.HookInjectorClassVisitor;
import cn.tesseract.mycelium.asm.NodeTransformer;
import cn.tesseract.mycelium.asm.minecraft.HookLibPlugin;
import cn.tesseract.mycelium.asm.minecraft.HookLoader;
import cn.tesseract.mycelium.asm.minecraft.PrimaryClassTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class MinecraftClassTransformer
extends HookClassTransformer
implements IClassTransformer {
    public static MinecraftClassTransformer instance;
    private static final List<IClassTransformer> postTransformers;
    public static final HashMap<String, List<NodeTransformer>> transformerMap;

    public MinecraftClassTransformer() {
        instance = this;
        this.classMetadataReader = HookLoader.getDeobfuscationMetadataReader();
        this.hooksMap.putAll(PrimaryClassTransformer.instance.getHooksMap());
        PrimaryClassTransformer.instance.getHooksMap().clear();
        PrimaryClassTransformer.instance.registeredSecondTransformer = true;
    }

    public byte[] transform(String oldName, String newName, byte[] bytecode) {
        bytecode = this.transform(newName, bytecode);
        for (IClassTransformer postTransformer : postTransformers) {
            bytecode = postTransformer.transform(oldName, newName, bytecode);
        }
        List<NodeTransformer> transformers = transformerMap.get(newName);
        if (transformers != null) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(bytecode);
            classReader.accept((ClassVisitor)classNode, 0);
            Iterator<NodeTransformer> it = transformers.iterator();
            while (it.hasNext()) {
                it.next().transform(classNode);
                it.remove();
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            bytecode = classWriter.toByteArray();
            if (MyceliumCoreMod.dumpTransformedClass) {
                MyceliumCoreMod.dumpClassFile(bytecode);
            }
        }
        return bytecode;
    }

    @Override
    protected HookInjectorClassVisitor createInjectorClassVisitor(ClassWriter cw, List<AsmHook> hooks) {
        return new HookInjectorClassVisitor(this, cw, hooks){

            @Override
            protected boolean isTargetMethod(AsmHook hook, String name, String desc) {
                return super.isTargetMethod(hook, HookLibPlugin.getMethodMcpName(name), desc);
            }
        };
    }

    public static void registerPostTransformer(IClassTransformer transformer) {
        postTransformers.add(transformer);
    }

    static {
        postTransformers = new ArrayList<IClassTransformer>();
        transformerMap = new HashMap();
    }
}

