/*
 * Decompiled with CFR 0.152.
 */
package cn.tesseract.mycelium.asm;

import cn.tesseract.mycelium.asm.AsmHook;
import cn.tesseract.mycelium.asm.HookInjectorClassVisitor;
import cn.tesseract.mycelium.asm.minecraft.HookLibPlugin;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

public abstract class HookInjectorMethodVisitor
extends AdviceAdapter {
    protected final AsmHook hook;
    protected final HookInjectorClassVisitor cv;
    public final String methodName;
    public final Type methodType;
    public final boolean isStatic;

    protected HookInjectorMethodVisitor(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv) {
        super(327680, mv, access, name, desc);
        this.hook = hook;
        this.cv = cv;
        this.isStatic = (access & 8) != 0;
        this.methodName = name;
        this.methodType = Type.getMethodType((String)desc);
    }

    protected final void visitHook() {
        if (!this.cv.visitingHook) {
            this.cv.visitingHook = true;
            this.hook.inject(this);
            this.hook.injected = true;
            this.cv.visitingHook = false;
        }
    }

    MethodVisitor getBasicVisitor() {
        return this.mv;
    }

    public static class Invoke
    extends HookInjectorMethodVisitor {
        private final String method;
        private int index;
        private final boolean after;

        public Invoke(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv, String method, int index, boolean after) {
            super(mv, access, name, desc, hook, cv);
            this.method = method;
            this.index = index;
            this.after = after;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            boolean isTarget = false;
            if (this.method.equals("L" + owner + ";" + HookLibPlugin.getMethodMcpName(name) + desc) && this.index != -1 && (this.index == -2 || this.index-- == 0)) {
                isTarget = true;
            }
            if (this.after) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
            if (isTarget) {
                this.visitHook();
            }
            if (!this.after) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    public static class LineNumber
    extends HookInjectorMethodVisitor {
        private int lineNumber;
        private int startLine = -1;

        public LineNumber(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv, int lineNumber) {
            super(mv, access, name, desc, hook, cv);
            this.lineNumber = lineNumber;
        }

        public void visitLineNumber(int line, Label start) {
            super.visitLineNumber(line, start);
            if (this.startLine == -1) {
                this.startLine = line;
            }
            if (line - this.startLine == this.lineNumber) {
                this.visitHook();
            }
        }
    }

    public static class MethodExit
    extends HookInjectorMethodVisitor {
        public MethodExit(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv) {
            super(mv, access, name, desc, hook, cv);
        }

        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.visitHook();
            }
        }
    }

    public static class MethodEnter
    extends HookInjectorMethodVisitor {
        public MethodEnter(MethodVisitor mv, int access, String name, String desc, AsmHook hook, HookInjectorClassVisitor cv) {
            super(mv, access, name, desc, hook, cv);
        }

        protected void onMethodEnter() {
            this.visitHook();
        }
    }
}

