/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms.compiler.ast;

import com.ventooth.swansong.uniforms.Type;
import com.ventooth.swansong.uniforms.compiler.ast.TypedNode;
import com.ventooth.swansong.uniforms.compiler.ast.UntypedNode;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;
import org.joml.Vector4dc;

public interface ConstNode
extends UntypedNode,
TypedNode {

    public static enum Bool implements ConstNode
    {
        True,
        False;


        public static Bool of(boolean value) {
            return value ? True : False;
        }

        public boolean value() {
            boolean bl;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case True: {
                    bl = true;
                    break;
                }
                case False: {
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        @NotNull
        public Type outputType() {
            return Type.Bool;
        }

        public String toString() {
            return Boolean.toString(this.value());
        }
    }

    public static final class Vec4
    implements ConstNode {
        public final double x;
        public final double y;
        public final double z;
        public final double w;

        public Vec4(Vector4dc vec) {
            this(vec.x(), vec.y(), vec.z(), vec.w());
        }

        @Override
        @NotNull
        public Type outputType() {
            return Type.Vec4;
        }

        public Vector4dc value() {
            return new Vector4d(this.x, this.y, this.z, this.w);
        }

        @Generated
        public Vec4(double x, double y, double z, double w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
    }

    public static final class Vec3
    implements ConstNode {
        public final double x;
        public final double y;
        public final double z;

        public Vec3(Vector3dc vec) {
            this(vec.x(), vec.y(), vec.z());
        }

        @Override
        @NotNull
        public Type outputType() {
            return Type.Vec3;
        }

        public Vector3dc value() {
            return new Vector3d(this.x, this.y, this.z);
        }

        @Generated
        public Vec3(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static final class Vec2
    implements ConstNode {
        public final double x;
        public final double y;

        public Vec2(Vector2dc vec) {
            this(vec.x(), vec.y());
        }

        @Override
        @NotNull
        public Type outputType() {
            return Type.Vec2;
        }

        public Vector2dc value() {
            return new Vector2d(this.x, this.y);
        }

        @Generated
        public Vec2(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static final class Float
    implements ConstNode {
        public final double value;

        @Override
        @NotNull
        public Type outputType() {
            return Type.Float;
        }

        @Generated
        public Float(double value) {
            this.value = value;
        }
    }

    public static final class Int
    implements ConstNode {
        public final int value;
        private static final int CACHE_RANGE = 128;
        private static final Int[] posCache = new Int[128];
        private static final Int[] negCache = new Int[128];

        public static Int of(int value) {
            if (value >= 0 && value < 128) {
                return posCache[value];
            }
            if (value < 0 && value >= -128) {
                return negCache[~value];
            }
            return new Int(value);
        }

        @Override
        @NotNull
        public Type outputType() {
            return Type.Int;
        }

        @Generated
        private Int(int value) {
            this.value = value;
        }

        static {
            for (int i = 0; i < 128; ++i) {
                Int.posCache[i] = new Int(i);
                Int.negCache[i] = new Int(~i);
            }
        }
    }
}

