/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms;

import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2dc;
import org.joml.Vector3dc;
import org.joml.Vector4dc;

public enum Type {
    Bool,
    Int,
    Float,
    Vec2,
    Vec3,
    Vec4;

    private static final String DESC_VEC2;
    private static final String DESC_VEC3;
    private static final String DESC_VEC4;

    @Nullable
    public static Type tryCoerce(Type a, Type b) {
        Type type;
        block0 : switch (a) {
            case Bool: {
                switch (b) {
                    case Bool: {
                        type = a;
                        break block0;
                    }
                }
                type = b;
                break;
            }
            case Int: {
                switch (b) {
                    case Bool: 
                    case Int: {
                        type = a;
                        break block0;
                    }
                }
                type = b;
                break;
            }
            case Float: {
                switch (b) {
                    case Bool: 
                    case Int: 
                    case Float: {
                        type = a;
                        break block0;
                    }
                }
                type = b;
                break;
            }
            case Vec2: {
                switch (b) {
                    case Bool: 
                    case Int: 
                    case Float: 
                    case Vec2: {
                        type = a;
                        break block0;
                    }
                }
                type = null;
                break;
            }
            case Vec3: {
                switch (b) {
                    case Bool: 
                    case Int: 
                    case Float: 
                    case Vec3: {
                        type = a;
                        break block0;
                    }
                }
                type = null;
                break;
            }
            case Vec4: {
                switch (b) {
                    case Bool: 
                    case Int: 
                    case Float: 
                    case Vec4: {
                        type = a;
                        break block0;
                    }
                }
                type = null;
                break;
            }
            default: {
                type = null;
            }
        }
        return type;
    }

    @NotNull
    public static Type coerce(Type a, Type b) {
        Type ret = Type.tryCoerce(a, b);
        if (ret == null) {
            throw new TypeCoercionException();
        }
        return ret;
    }

    public String descriptor() {
        String string;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Bool: {
                string = "Z";
                break;
            }
            case Float: {
                string = "D";
                break;
            }
            case Int: {
                string = "I";
                break;
            }
            case Vec2: {
                string = DESC_VEC2;
                break;
            }
            case Vec3: {
                string = DESC_VEC3;
                break;
            }
            case Vec4: {
                string = DESC_VEC4;
            }
        }
        return string;
    }

    public int returnOpcode() {
        int n;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Bool: 
            case Int: {
                n = 172;
                break;
            }
            case Float: {
                n = 175;
                break;
            }
            case Vec2: 
            case Vec3: 
            case Vec4: {
                n = 176;
            }
        }
        return n;
    }

    public static String methodDescriptor(Type returns, Type ... params) {
        StringBuilder result = new StringBuilder("(");
        for (Type param : params) {
            result.append(param.descriptor());
        }
        result.append(")");
        result.append(returns.descriptor());
        return result.toString();
    }

    public static Type of(Class<?> klass) {
        if (Vector2dc.class.isAssignableFrom(klass)) {
            return Vec2;
        }
        if (Vector3dc.class.isAssignableFrom(klass)) {
            return Vec3;
        }
        if (Vector4dc.class.isAssignableFrom(klass)) {
            return Vec4;
        }
        if (Integer.TYPE == klass) {
            return Int;
        }
        if (Double.TYPE == klass) {
            return Float;
        }
        if (Boolean.TYPE == klass) {
            return Bool;
        }
        throw new IllegalArgumentException(klass.getName());
    }

    public static Type of(String shaderPackType) {
        Type type;
        switch (shaderPackType.toLowerCase(Locale.ROOT)) {
            case "float": {
                type = Float;
                break;
            }
            case "int": {
                type = Int;
                break;
            }
            case "bool": {
                type = Bool;
                break;
            }
            case "vec2": {
                type = Vec2;
                break;
            }
            case "vec3": {
                type = Vec3;
                break;
            }
            case "vec4": {
                type = Vec4;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return type;
    }

    @Generated
    private Type() {
    }

    static {
        DESC_VEC2 = org.objectweb.asm.Type.getDescriptor(Vector2dc.class);
        DESC_VEC3 = org.objectweb.asm.Type.getDescriptor(Vector3dc.class);
        DESC_VEC4 = org.objectweb.asm.Type.getDescriptor(Vector4dc.class);
    }

    public static class TypeCoercionException
    extends RuntimeException {
    }
}

