/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.uniforms;

import com.falsepattern.lib.util.MathUtil;
import com.ventooth.swansong.uniforms.UniformFunctionRegistry;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;
import org.joml.Vector4dc;

public final class Builtins {
    public static final UniformFunctionRegistry REGISTRY = Builtins.register();
    private static final double LOG2 = Math.log(2.0);

    private static UniformFunctionRegistry register() {
        Class<Builtins> klass = Builtins.class;
        UniformFunctionRegistry.Single reg = new UniformFunctionRegistry.Single();
        reg.pure(klass.getDeclaredMethod("pi", new Class[0]));
        reg.pure(klass.getDeclaredMethod("vec2", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("vec2", Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("vec3", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("vec3", Double.TYPE, Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("vec4", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("vec4", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("radians", Double.TYPE), "radians", "torad");
        reg.pure(klass.getDeclaredMethod("degrees", Double.TYPE), "degrees", "todeg");
        reg.pure(klass.getDeclaredMethod("sin", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("cos", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("asin", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("acos", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("atan", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("atan2", Double.TYPE, Double.TYPE), "atan2", "atan");
        reg.pure(klass.getDeclaredMethod("exp", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("pow", Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("exp2", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("exp10", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("log", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("log", Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("log2", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("log10", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("sqrt", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("abs", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("abs", Integer.TYPE));
        reg.pure(klass.getDeclaredMethod("abs", Vector2dc.class));
        reg.pure(klass.getDeclaredMethod("abs", Vector3dc.class));
        reg.pure(klass.getDeclaredMethod("abs", Vector4dc.class));
        reg.pure(klass.getDeclaredMethod("signum", Double.TYPE), "signum", "sign");
        reg.pure(klass.getDeclaredMethod("signum", Integer.TYPE), "signum", "sign");
        reg.pure(klass.getDeclaredMethod("floor", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("floor", Vector2dc.class));
        reg.pure(klass.getDeclaredMethod("floor", Vector3dc.class));
        reg.pure(klass.getDeclaredMethod("floor", Vector4dc.class));
        reg.pure(klass.getDeclaredMethod("ceil", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("ceil", Vector2dc.class));
        reg.pure(klass.getDeclaredMethod("ceil", Vector3dc.class));
        reg.pure(klass.getDeclaredMethod("ceil", Vector4dc.class));
        reg.pure(klass.getDeclaredMethod("frac", Double.TYPE));
        reg.pure(klass.getDeclaredMethod("min", Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("min", Integer.TYPE, Integer.TYPE));
        reg.pure(klass.getDeclaredMethod("min", Vector2dc.class, Vector2dc.class));
        reg.pure(klass.getDeclaredMethod("min", Vector3dc.class, Vector3dc.class));
        reg.pure(klass.getDeclaredMethod("min", Vector4dc.class, Vector4dc.class));
        reg.pure(klass.getDeclaredMethod("max", Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("max", Integer.TYPE, Integer.TYPE));
        reg.pure(klass.getDeclaredMethod("max", Vector2dc.class, Vector2dc.class));
        reg.pure(klass.getDeclaredMethod("max", Vector3dc.class, Vector3dc.class));
        reg.pure(klass.getDeclaredMethod("max", Vector4dc.class, Vector4dc.class));
        reg.pure(klass.getDeclaredMethod("clamp", Double.TYPE, Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("clamp", Integer.TYPE, Integer.TYPE, Integer.TYPE));
        reg.pure(klass.getDeclaredMethod("clamp", Vector2dc.class, Vector2dc.class, Vector2dc.class));
        reg.pure(klass.getDeclaredMethod("clamp", Vector3dc.class, Vector3dc.class, Vector3dc.class));
        reg.pure(klass.getDeclaredMethod("clamp", Vector4dc.class, Vector4dc.class, Vector4dc.class));
        reg.pure(klass.getDeclaredMethod("mix", Double.TYPE, Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("edge", Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("edge", Integer.TYPE, Integer.TYPE));
        reg.pure(klass.getDeclaredMethod("fmod", Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("between", Double.TYPE, Double.TYPE, Double.TYPE));
        reg.pure(klass.getDeclaredMethod("equals", Double.TYPE, Double.TYPE, Double.TYPE));
        return reg;
    }

    public static double pi() {
        return Math.PI;
    }

    public static Vector2dc vec2(double s) {
        return new Vector2d(s);
    }

    public static Vector2dc vec2(double x, double y) {
        return new Vector2d(x, y);
    }

    public static Vector3dc vec3(double s) {
        return new Vector3d(s);
    }

    public static Vector3dc vec3(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }

    public static Vector4dc vec4(double s) {
        return new Vector4d(s);
    }

    public static Vector4dc vec4(double x, double y, double z, double w) {
        return new Vector4d(x, y, z, w);
    }

    public static double radians(double deg) {
        return Math.toRadians(deg);
    }

    public static double degrees(double rad) {
        return Math.toDegrees(rad);
    }

    public static double sin(double x) {
        return Math.sin(x);
    }

    public static double cos(double x) {
        return Math.cos(x);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static double atan(double x) {
        return Math.atan(x);
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double exp(double x) {
        return Math.exp(x);
    }

    public static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    public static double exp2(double x) {
        return Math.pow(2.0, x);
    }

    public static double exp10(double x) {
        return Math.pow(10.0, x);
    }

    public static double log(double x) {
        return Math.log(x);
    }

    public static double log(double base, double value) {
        return Math.log(value) / Math.log(base);
    }

    public static double log2(double x) {
        return Math.log(x) / LOG2;
    }

    public static double log10(double x) {
        return Math.log10(x);
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static int abs(int x) {
        return Math.abs(x);
    }

    public static Vector2dc abs(Vector2dc vec) {
        return vec.absolute(new Vector2d());
    }

    public static Vector3dc abs(Vector3dc vec) {
        return vec.absolute(new Vector3d());
    }

    public static Vector4dc abs(Vector4dc vec) {
        return vec.absolute(new Vector4d());
    }

    public static double signum(double x) {
        return Math.signum(x);
    }

    public static int signum(int x) {
        return Integer.compare(x, 0);
    }

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static Vector2dc floor(Vector2dc vec) {
        return vec.floor(new Vector2d());
    }

    public static Vector3dc floor(Vector3dc vec) {
        return vec.floor(new Vector3d());
    }

    public static Vector4dc floor(Vector4dc vec) {
        return vec.floor(new Vector4d());
    }

    public static double ceil(double x) {
        return Math.ceil(x);
    }

    public static Vector2dc ceil(Vector2dc vec) {
        return vec.ceil(new Vector2d());
    }

    public static Vector3dc ceil(Vector3dc vec) {
        return vec.ceil(new Vector3d());
    }

    public static Vector4dc ceil(Vector4dc vec) {
        return vec.ceil(new Vector4d());
    }

    public static double frac(double x) {
        return MathUtil.frac((double)x);
    }

    public static double min(double x, double y) {
        return Math.min(x, y);
    }

    public static int min(int x, int y) {
        return Math.min(x, y);
    }

    public static Vector2dc min(Vector2dc a, Vector2dc b) {
        return a.min(b, new Vector2d());
    }

    public static Vector3dc min(Vector3dc a, Vector3dc b) {
        return a.min(b, new Vector3d());
    }

    public static Vector4dc min(Vector4dc a, Vector4dc b) {
        return a.min(b, new Vector4d());
    }

    public static double max(double x, double y) {
        return Math.max(x, y);
    }

    public static int max(int x, int y) {
        return Math.max(x, y);
    }

    public static Vector2dc max(Vector2dc a, Vector2dc b) {
        return a.max(b, new Vector2d());
    }

    public static Vector3dc max(Vector3dc a, Vector3dc b) {
        return a.max(b, new Vector3d());
    }

    public static Vector4dc max(Vector4dc a, Vector4dc b) {
        return a.max(b, new Vector4d());
    }

    public static double clamp(double x, double min, double max) {
        return MathUtil.clamp((double)x, (double)min, (double)max);
    }

    public static int clamp(int x, int min, int max) {
        return MathUtil.clamp((int)x, (int)min, (int)max);
    }

    public static Vector2dc clamp(Vector2dc x, Vector2dc min, Vector2dc max) {
        return new Vector2d(MathUtil.clamp((double)x.x(), (double)min.x(), (double)max.x()), MathUtil.clamp((double)x.y(), (double)min.y(), (double)max.y()));
    }

    public static Vector3dc clamp(Vector3dc x, Vector3dc min, Vector3dc max) {
        return new Vector3d(MathUtil.clamp((double)x.x(), (double)min.x(), (double)max.x()), MathUtil.clamp((double)x.y(), (double)min.y(), (double)max.y()), MathUtil.clamp((double)x.z(), (double)min.z(), (double)max.z()));
    }

    public static Vector4dc clamp(Vector4dc x, Vector4dc min, Vector4dc max) {
        return new Vector4d(MathUtil.clamp((double)x.x(), (double)min.x(), (double)max.x()), MathUtil.clamp((double)x.y(), (double)min.y(), (double)max.y()), MathUtil.clamp((double)x.z(), (double)min.z(), (double)max.z()), MathUtil.clamp((double)x.w(), (double)min.w(), (double)max.w()));
    }

    public static double mix(double x, double y, double a) {
        return org.joml.Math.fma((double)(y - x), (double)a, (double)x);
    }

    public static double edge(double k, double x) {
        return x < k ? 0.0 : 1.0;
    }

    public static int edge(int k, int x) {
        return x < k ? 0 : 1;
    }

    public static double fmod(double x, double y) {
        return x - y * Builtins.floor(x / y);
    }

    public static boolean between(double a, double min, double max) {
        return a >= min && a <= max;
    }

    public static boolean equals(double a, double b, double epsilon) {
        return Builtins.abs(a - b) <= epsilon;
    }
}

