/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.preprocessor.macro;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.mathparser.ParserException;
import com.ventooth.swansong.shader.preprocessor.Option;
import com.ventooth.swansong.shader.preprocessor.TaggedLine;
import com.ventooth.swansong.shader.preprocessor.macro.MacroExpressionInterpreter;
import com.ventooth.swansong.shader.preprocessor.util.RenderTargetParser;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class MacroInterpreter {
    private final Int2ObjectMap<Option> inOptions;
    private final List<TaggedLine> inCode;
    private final List<String> sourceIndices;
    private final boolean glsl;
    private final Map<String, Option.Value> defines = new HashMap<String, Option.Value>();
    private final BitSet disabled = new BitSet();
    private final BitSet elifChainBranchTaken = new BitSet();
    private int depth = 0;
    private String outVersion = null;
    private final List<String> outExtensions;
    private final Int2ObjectMap<Option> outOptions = new Int2ObjectOpenHashMap();
    private final List<TaggedLine> outCode = new ArrayList<TaggedLine>();
    @Nullable
    private IntList outRenderTargets = null;

    public static Result interpret(Int2ObjectMap<Option> inOptions, List<TaggedLine> inCode, List<String> sourceIndices, Map<String, Option.Value> externalDefines, boolean glsl) {
        MacroInterpreter interpreter = new MacroInterpreter(inOptions, inCode, sourceIndices, glsl);
        interpreter.defines.putAll(externalDefines);
        interpreter.execute();
        return new Result(glsl ? new Result.GLSL(interpreter.outVersion, Collections.unmodifiableList(interpreter.outExtensions), interpreter.outRenderTargets) : null, Collections.unmodifiableList(interpreter.outCode), (Int2ObjectMap<Option>)Int2ObjectMaps.unmodifiable(interpreter.outOptions));
    }

    private MacroInterpreter(Int2ObjectMap<Option> inOptions, List<TaggedLine> inCode, List<String> sourceIndices, boolean glsl) {
        this.inOptions = inOptions;
        this.inCode = inCode;
        this.sourceIndices = sourceIndices;
        this.glsl = glsl;
        this.outExtensions = glsl ? new ArrayList() : null;
    }

    private void execute() {
        int size = this.inCode.size();
        for (int i = 0; i < size; ++i) {
            IntList rt;
            String macro;
            TaggedLine taggedLine = this.inCode.get(i);
            TaggedLine.Tag tag = taggedLine.tag();
            boolean doDisable = tag == TaggedLine.Tag.Macro ? (this.processIfdef(macro = taggedLine.text().trim()) ? true : (this.processIfndef(macro) ? true : (this.processIf(macro, taggedLine) ? true : (this.processElif(macro, taggedLine) ? true : (this.processElse(macro, taggedLine) ? true : (this.processEndif(macro, taggedLine) ? true : (this.processUndef(macro) ? false : (this.processVersion(macro, taggedLine) ? true : (this.processExtension(macro, taggedLine) ? true : (this.processOption(i) ? false : false)))))))))) : (tag == TaggedLine.Tag.Standard && this.processOption(i) ? false : false);
            if (doDisable || !this.disabled.isEmpty()) {
                this.outCode.add(taggedLine.withText("// " + taggedLine.text()));
                continue;
            }
            if (tag == TaggedLine.Tag.MultilineComment && (rt = RenderTargetParser.parseRenderTargetList(taggedLine.text())) != null) {
                this.outRenderTargets = rt;
            }
            this.outCode.add(taggedLine);
        }
    }

    private static String[] split(String macro) {
        return macro.split("\\s+", 2);
    }

    private boolean processIfdef(String macro) {
        if (!macro.startsWith("#ifdef ")) {
            return false;
        }
        ++this.depth;
        if (this.disabled.previousSetBit(this.depth - 1) != -1) {
            return true;
        }
        String[] parts = MacroInterpreter.split(macro);
        boolean res = this.defines.containsKey(parts[1]);
        this.elifChainBranchTaken.set(this.depth, res);
        this.disabled.set(this.depth, !res);
        return true;
    }

    private boolean processIfndef(String macro) {
        if (!macro.startsWith("#ifndef ")) {
            return false;
        }
        ++this.depth;
        if (this.disabled.previousSetBit(this.depth - 1) != -1) {
            return true;
        }
        String[] parts = MacroInterpreter.split(macro);
        boolean res = !this.defines.containsKey(parts[1]);
        this.elifChainBranchTaken.set(this.depth, res);
        this.disabled.set(this.depth, !res);
        return true;
    }

    private boolean processIf(String macro, TaggedLine taggedLine) {
        if (!macro.startsWith("#if ")) {
            return false;
        }
        ++this.depth;
        if (this.disabled.previousSetBit(this.depth - 1) != -1) {
            return true;
        }
        try {
            String[] parts = MacroInterpreter.split(macro);
            boolean res = MacroExpressionInterpreter.interpret(parts[1], this.defines).asBool();
            this.elifChainBranchTaken.set(this.depth, res);
            this.disabled.set(this.depth, !res);
        }
        catch (ParserException e) {
            this.elifChainBranchTaken.clear(this.depth);
            this.disabled.set(this.depth);
            Share.log.error("Failed to process #if macro in file {} line {}", new Object[]{this.sourceIndices.get(taggedLine.file()), taggedLine.line()});
            Share.log.error("Stacktrace:", (Throwable)e);
        }
        return true;
    }

    private boolean processElif(String macro, TaggedLine taggedLine) {
        if (!macro.startsWith("#elif ")) {
            return false;
        }
        if (this.depth < 0) {
            throw new IllegalStateException("Dangling #elif macro in file " + this.sourceIndices.get(taggedLine.file()) + " line " + taggedLine.line());
        }
        if (this.disabled.previousSetBit(this.depth - 1) != -1) {
            return true;
        }
        if (this.elifChainBranchTaken.get(this.depth)) {
            this.disabled.set(this.depth);
        } else {
            try {
                String[] parts = MacroInterpreter.split(macro);
                boolean res = MacroExpressionInterpreter.interpret(parts[1], this.defines).asBool();
                this.elifChainBranchTaken.set(this.depth, res);
                this.disabled.set(this.depth, !res);
            }
            catch (ParserException e) {
                this.disabled.set(this.depth);
                Share.log.error("Failed to process #elif macro in file {} line {}", new Object[]{this.sourceIndices.get(taggedLine.file()), taggedLine.line()});
                Share.log.error("Stacktrace:", (Throwable)e);
            }
        }
        return true;
    }

    private boolean processElse(String macro, TaggedLine taggedLine) {
        if (!macro.startsWith("#else")) {
            return false;
        }
        if (this.disabled.previousSetBit(this.depth - 1) != -1) {
            return true;
        }
        if (this.depth < 0) {
            throw new IllegalStateException("Dangling #else macro in file " + this.sourceIndices.get(taggedLine.file()) + " line " + taggedLine.line());
        }
        if (this.elifChainBranchTaken.get(this.depth)) {
            this.disabled.set(this.depth);
        } else {
            this.disabled.flip(this.depth);
            this.elifChainBranchTaken.set(this.depth);
        }
        return true;
    }

    private boolean processEndif(String macro, TaggedLine taggedLine) {
        if (!macro.startsWith("#endif")) {
            return false;
        }
        if (this.depth < 0) {
            throw new IllegalStateException("Dangling #else macro in file " + this.sourceIndices.get(taggedLine.file()) + " line " + taggedLine.line());
        }
        this.disabled.clear(this.depth);
        this.elifChainBranchTaken.clear(this.depth);
        --this.depth;
        return true;
    }

    private boolean processUndef(String macro) {
        if (!macro.startsWith("#undef ")) {
            return false;
        }
        if (this.disabled.isEmpty()) {
            String[] parts = MacroInterpreter.split(macro);
            this.defines.remove(parts[1]);
        }
        return true;
    }

    private boolean processVersion(String macro, TaggedLine taggedLine) {
        if (!this.glsl || !macro.startsWith("#version ")) {
            return false;
        }
        if (this.disabled.isEmpty()) {
            if (this.outVersion == null) {
                this.outVersion = macro;
            } else {
                Share.log.trace("Multiple version macros defined at file {} line {}", new Object[]{this.sourceIndices.get(taggedLine.file()), taggedLine.line()});
                this.outVersion = macro;
            }
        }
        return true;
    }

    private boolean processExtension(String macro, TaggedLine taggedLine) {
        if (!this.glsl || !macro.startsWith("#extension ")) {
            return false;
        }
        if (this.disabled.isEmpty()) {
            this.outExtensions.add(macro);
        } else {
            Share.log.trace("Disabled extension at file {} line {}", new Object[]{this.sourceIndices.get(taggedLine.file()), taggedLine.line()});
        }
        return true;
    }

    private boolean processOption(int i) {
        if (!this.inOptions.containsKey(i)) {
            return false;
        }
        Option opt = (Option)this.inOptions.get(i);
        if (this.disabled.isEmpty()) {
            this.outOptions.put(this.outCode.size(), (Object)opt.copy(true));
            if (!(opt instanceof Option.Define)) {
                throw new AssertionError();
            }
            Option.Define dir = (Option.Define)opt;
            if (!dir.isToggle() || dir.isEnabled()) {
                this.defines.put(dir.name, dir.getCurrentValue());
            }
        }
        return true;
    }

    @Generated
    private MacroInterpreter(Int2ObjectMap<Option> inOptions, List<TaggedLine> inCode, List<String> sourceIndices, boolean glsl, List<String> outExtensions) {
        this.inOptions = inOptions;
        this.inCode = inCode;
        this.sourceIndices = sourceIndices;
        this.glsl = glsl;
        this.outExtensions = outExtensions;
    }

    public static final class Result {
        @Nullable
        private final GLSL glsl;
        @NotNull
        private final @Unmodifiable List<TaggedLine> code;
        @NotNull
        private final @Unmodifiable Int2ObjectMap<Option> options;

        public Result(@Nullable GLSL glsl, @NotNull @Unmodifiable List<TaggedLine> code, @NotNull @Unmodifiable Int2ObjectMap<Option> options) {
            this.glsl = glsl;
            this.code = code;
            this.options = options;
        }

        @Nullable
        public GLSL glsl() {
            return this.glsl;
        }

        @NotNull
        public @Unmodifiable List<TaggedLine> code() {
            return this.code;
        }

        @NotNull
        public @Unmodifiable Int2ObjectMap<Option> options() {
            return this.options;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Result that = (Result)obj;
            return Objects.equals(this.glsl, that.glsl) && Objects.equals(this.code, that.code) && Objects.equals(this.options, that.options);
        }

        public int hashCode() {
            return Objects.hash(this.glsl, this.code, this.options);
        }

        public String toString() {
            return "Result[glsl=" + this.glsl + ", code=" + this.code + ", options=" + this.options + ']';
        }

        public static final class GLSL {
            @Nullable
            private final String version;
            @NotNull
            private final @Unmodifiable List<String> extensions;
            @Nullable
            private final @Unmodifiable IntList renderTargets;

            public GLSL(@Nullable String version, @NotNull @Unmodifiable List<String> extensions, @Nullable @Unmodifiable IntList renderTargets) {
                this.version = version;
                this.extensions = extensions;
                this.renderTargets = renderTargets;
            }

            @Nullable
            public String version() {
                return this.version;
            }

            @NotNull
            public @Unmodifiable List<String> extensions() {
                return this.extensions;
            }

            @Nullable
            public @Unmodifiable IntList renderTargets() {
                return this.renderTargets;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                GLSL that = (GLSL)obj;
                return Objects.equals(this.version, that.version) && Objects.equals(this.extensions, that.extensions) && Objects.equals(this.renderTargets, that.renderTargets);
            }

            public int hashCode() {
                return Objects.hash(this.version, this.extensions, this.renderTargets);
            }

            public String toString() {
                return "GLSL[version=" + this.version + ", extensions=" + this.extensions + ", renderTargets=" + this.renderTargets + ']';
            }
        }
    }
}

