/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.preprocessor;

import com.falsepattern.lib.util.MathUtil;
import com.ventooth.swansong.MicroCache;
import com.ventooth.swansong.shader.preprocessor.TaggedLine;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;

public abstract class Option {
    public static final List<Value.Bool> TOGGLE_VALUES = Collections.unmodifiableList(Arrays.asList(Value.Bool.False, Value.Bool.True));
    public final String name;
    protected final State state;
    protected final List<? extends Value> legalValues;
    protected final int defaultValue;
    protected int currentValue;
    private static final String REGEX_NAME = "(\\w+)";
    private static final String REGEX_VALUE = "([\\w.-]+)";
    private static final String REGEX_ALLOWED = "\\s*(?://(?:.*?\\[(.*?)])?.*)?$";

    public static void purgeCaches() {
        Const.cacheC.purge();
        Const.cacheNC.purge();
        Define.cache.purge();
    }

    public Value getCurrentValue() {
        return this.legalValues.get(this.currentValue);
    }

    public void setCurrentValue(Value value) {
        if (this.isReadonly()) {
            return;
        }
        this.currentValue = Option.valueIndexOf(value, this.legalValues);
    }

    public void nextValue() {
        if (this.isReadonly()) {
            return;
        }
        this.currentValue = (this.currentValue + 1) % this.legalValues.size();
    }

    public void prevValue() {
        if (this.isReadonly()) {
            return;
        }
        int s = this.legalValues.size();
        this.currentValue = (this.currentValue - 1 + s) % s;
    }

    public Value getDefaultValue() {
        return this.legalValues.get(this.defaultValue);
    }

    public boolean isDefaultValue() {
        return this.defaultValue == this.currentValue;
    }

    public void setToDefault() {
        if (this.isReadonly()) {
            return;
        }
        this.currentValue = this.defaultValue;
    }

    public int getValueCount() {
        return this.legalValues.size();
    }

    public int getValueIndex() {
        return this.currentValue;
    }

    public void setValueIndex(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        if (index < 0 || index >= this.legalValues.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isReadonly()) {
            return;
        }
        this.currentValue = index;
    }

    public Value getValueByIndex(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.legalValues.get(index);
    }

    public boolean isToggle() {
        return this.legalValues == TOGGLE_VALUES;
    }

    public boolean isReadonly() {
        return this.state != State.Mutable;
    }

    public boolean isConfigurable() {
        return this.state != State.Unconfigurable;
    }

    public boolean isEnabled() {
        boolean bl;
        if (!this.isToggle()) {
            throw new IllegalStateException();
        }
        Value.Bool tgl = (Value.Bool)this.getCurrentValue();
        switch (tgl) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case True: {
                bl = true;
                break;
            }
            case False: {
                bl = false;
            }
        }
        return bl;
    }

    public ObjectList<String> valueStrings() {
        ObjectArrayList result = new ObjectArrayList();
        for (Value value : this.legalValues) {
            result.add((Object)value.toString());
        }
        return ObjectLists.unmodifiable((ObjectList)result);
    }

    public String toProps() {
        return this.name + '=' + this.getCurrentValue().toString();
    }

    public abstract Option copy(boolean var1);

    public abstract String toCode();

    public abstract String uniqueName();

    @Nullable
    protected static @Unmodifiable List<? extends Value> tryParseAllowedGroup(Value initialValue, String allowedGroup) {
        if (allowedGroup == null) {
            return null;
        }
        String[] allowedStr = allowedGroup.trim().split("\\s+");
        if (allowedStr.length == 0) {
            return null;
        }
        boolean anyMatch = false;
        ArrayList<Value> allowed = new ArrayList<Value>();
        for (String str : allowedStr) {
            Value v = Value.detect(str);
            if (!anyMatch) {
                anyMatch = Option.valueMatches(v, initialValue);
            }
            allowed.add(v);
        }
        if (allowed.size() == 2 && allowed.get(0) == Value.Bool.False && allowed.get(1) == Value.Bool.True) {
            return TOGGLE_VALUES;
        }
        if (!anyMatch) {
            allowed.add(0, initialValue);
        }
        return Collections.unmodifiableList(allowed);
    }

    private static int valueIndexOf(Value expect, List<? extends Value> possible) {
        int size = possible.size();
        for (int i = 0; i < size; ++i) {
            if (!Option.valueMatches(expect, possible.get(i))) continue;
            return i;
        }
        return 0;
    }

    public static boolean valueMatches(Value a, Value b) {
        boolean bl;
        block0 : switch (a.type()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Toggle: {
                switch (b.type()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Toggle: {
                        if (a == b) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Int: {
                        if ((a == Value.Bool.True ? 1 : 0) == ((Value.Int)b).v) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Double: {
                        if ((double)(a == Value.Bool.True ? 1 : 0) == ((Value.Dbl)b).v) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Str: 
                }
                bl = false;
                break;
            }
            case Int: {
                switch (b.type()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Toggle: {
                        if (((Value.Int)a).v == (b == Value.Bool.True ? 1 : 0)) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Int: {
                        if (((Value.Int)a).v == ((Value.Int)b).v) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Double: {
                        if ((double)((Value.Int)a).v == ((Value.Dbl)b).v) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Str: 
                }
                bl = false;
                break;
            }
            case Double: {
                switch (b.type()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Toggle: {
                        if (((Value.Dbl)a).v == (double)(b == Value.Bool.True ? 1 : 0)) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Int: {
                        if (((Value.Dbl)a).v == (double)((Value.Int)b).v) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Double: {
                        if (((Value.Dbl)a).v == ((Value.Dbl)b).v) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case Str: 
                }
                bl = false;
                break;
            }
            case Str: {
                switch (b.type()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Toggle: 
                    case Int: 
                    case Double: {
                        bl = false;
                        break block0;
                    }
                    case Str: 
                }
                bl = Objects.equals(((Value.Str)a).v, ((Value.Str)b).v);
            }
        }
        return bl;
    }

    @Generated
    public Option(String name, State state, List<? extends Value> legalValues, int defaultValue, int currentValue) {
        this.name = name;
        this.state = state;
        this.legalValues = legalValues;
        this.defaultValue = defaultValue;
        this.currentValue = currentValue;
    }

    public static interface Value {
        public static Value detect(String value) {
            if ("true".equalsIgnoreCase(value)) {
                return Bool.True;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Bool.False;
            }
            if (value.indexOf(46) < 0) {
                try {
                    return new Int(Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                return new Dbl(Double.parseDouble(value));
            }
            catch (NumberFormatException numberFormatException) {
                return new Str(value);
            }
        }

        public ValueType type();

        @Nullable
        public Boolean boolValue();

        @Nullable
        public Integer intValue();

        @Nullable
        public Double doubleValue();

        default public void safeInt(IntConsumer out) {
            Integer v = this.intValue();
            if (v == null) {
                return;
            }
            out.accept(v.intValue());
        }

        default public void safeDouble(DoubleConsumer out) {
            Double v = this.doubleValue();
            if (v == null) {
                return;
            }
            out.accept(v);
        }

        default public void safeDouble(double min, double max, DoubleConsumer out) {
            Double v = this.doubleValue();
            if (v == null) {
                return;
            }
            double clamped = MathUtil.clamp((double)v, (double)min, (double)max);
            out.accept(clamped);
        }

        default public void boolFused(Runnable out) {
            Boolean v = this.boolValue();
            if (v == null || !v.booleanValue()) {
                return;
            }
            out.run();
        }

        default public void boolFused(BooleanConsumer out) {
            this.boolFused(() -> out.accept(true));
        }

        default public void boolFused(BooleanConsumer out1, BooleanConsumer out2) {
            this.boolFused(() -> {
                out1.accept(true);
                out2.accept(true);
            });
        }

        public static enum Bool implements Value
        {
            False,
            True;


            public String toString() {
                String string;
                switch (this) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case True: {
                        string = "true";
                        break;
                    }
                    case False: {
                        string = "false";
                    }
                }
                return string;
            }

            @Override
            public ValueType type() {
                return ValueType.Toggle;
            }

            public Bool toggle() {
                Bool bool;
                switch (this) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case True: {
                        bool = False;
                        break;
                    }
                    case False: {
                        bool = True;
                    }
                }
                return bool;
            }

            public static Bool of(boolean value) {
                return value ? True : False;
            }

            @Override
            public Boolean boolValue() {
                Boolean bl;
                switch (this) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case True: {
                        bl = true;
                        break;
                    }
                    case False: {
                        bl = false;
                    }
                }
                return bl;
            }

            @Override
            public Integer intValue() {
                return null;
            }

            @Override
            public Double doubleValue() {
                return null;
            }
        }

        public static final class Int
        implements Value {
            private final int v;

            public Int(int v) {
                this.v = v;
            }

            public String toString() {
                return Integer.toString(this.v);
            }

            @Override
            public ValueType type() {
                return ValueType.Int;
            }

            @Override
            public Boolean boolValue() {
                return null;
            }

            @Override
            public Integer intValue() {
                return this.v;
            }

            @Override
            public Double doubleValue() {
                return this.v;
            }

            public int v() {
                return this.v;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Int that = (Int)obj;
                return this.v == that.v;
            }

            public int hashCode() {
                return Objects.hash(this.v);
            }
        }

        public static final class Dbl
        implements Value {
            private final double v;

            public Dbl(double v) {
                this.v = v;
            }

            public String toString() {
                return Double.toString(this.v);
            }

            @Override
            public ValueType type() {
                return ValueType.Double;
            }

            @Override
            public Boolean boolValue() {
                return null;
            }

            @Override
            public Integer intValue() {
                return null;
            }

            @Override
            public Double doubleValue() {
                return this.v;
            }

            public double v() {
                return this.v;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Dbl that = (Dbl)obj;
                return Double.doubleToLongBits(this.v) == Double.doubleToLongBits(that.v);
            }

            public int hashCode() {
                return Objects.hash(this.v);
            }
        }

        public static final class Str
        implements Value {
            private final String v;

            public Str(String v) {
                this.v = v;
            }

            public String toString() {
                return this.v;
            }

            @Override
            public ValueType type() {
                return ValueType.Str;
            }

            @Override
            @Nullable
            public Boolean boolValue() {
                return null;
            }

            @Override
            public Integer intValue() {
                return null;
            }

            @Override
            public Double doubleValue() {
                return null;
            }

            public String v() {
                return this.v;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Str that = (Str)obj;
                return Objects.equals(this.v, that.v);
            }

            public int hashCode() {
                return Objects.hash(this.v);
            }
        }
    }

    public static class Const
    extends Option {
        private static final int GROUP_TYPE = 1;
        private static final int GROUP_NAME = 2;
        private static final int GROUP_VALUE = 3;
        private static final int GROUP_ALLOWED = 4;
        private static final Pattern CONST_REGEX = Pattern.compile("^\\s*const\\s+(\\w+)\\s+(\\w+)\\s*=\\s*([\\w.-]+)\\s*;\\s*(?://(?:.*?\\[(.*?)])?.*)?$");
        public final String type;
        public final boolean definedInComment;
        private static final MicroCache<String, Const> cacheC = new MicroCache();
        private static final MicroCache<String, Const> cacheNC = new MicroCache();

        private Const(String type, String name, State state, List<? extends Value> legalValues, boolean definedInComment, int defaultValue, int currentValue) {
            super(name, state, legalValues, defaultValue, currentValue);
            this.type = type;
            this.definedInComment = definedInComment;
        }

        public static Int2ObjectMap<Option> find(List<TaggedLine> code, boolean readonly) {
            Int2ObjectRBTreeMap output = new Int2ObjectRBTreeMap();
            int size = code.size();
            for (int i = 0; i < size; ++i) {
                Const opt;
                TaggedLine line = code.get(i);
                switch (line.tag()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Standard: {
                        Const const_ = Const.get(line.text(), readonly, false);
                        break;
                    }
                    case MultilineComment: {
                        Const const_ = Const.get(line.text(), true, true);
                        break;
                    }
                    case Macro: {
                        Const const_ = opt = null;
                    }
                }
                if (opt == null) continue;
                output.put(i, (Object)opt);
            }
            return output;
        }

        private static Const get(String code, boolean readonly, boolean definedInComment) {
            Const v = definedInComment ? cacheC.getCached(code, c -> Const.getUncached(c, true)) : cacheNC.getCached(code, c -> Const.getUncached(c, false));
            return v == null ? null : v.copy(readonly);
        }

        private static Const getUncached(String code, boolean definedInComment) {
            Matcher match = CONST_REGEX.matcher(code);
            if (!match.matches()) {
                return null;
            }
            String type = match.group(1);
            String name = match.group(2);
            Value value = Value.detect(match.group(3));
            List<? extends Value> allowed = Option.tryParseAllowedGroup(value, match.group(4));
            if (allowed == null) {
                if (value instanceof Value.Bool) {
                    int idx = Option.valueIndexOf(value, Const.TOGGLE_VALUES);
                    return new Const(type, name, State.Unconfigurable, TOGGLE_VALUES, definedInComment, idx, idx);
                }
                return new Const(type, name, State.Unconfigurable, Collections.singletonList(value), definedInComment, 0, 0);
            }
            int idx = Option.valueIndexOf(value, allowed);
            return new Const(type, name, State.Readonly, allowed, definedInComment, idx, idx);
        }

        @Override
        public Const copy(boolean readonly) {
            if (this.state == State.Unconfigurable) {
                return this;
            }
            if (readonly && this.state == State.Readonly) {
                return this;
            }
            return new Const(this.type, this.name, readonly ? State.Readonly : State.Mutable, this.legalValues, this.definedInComment, this.defaultValue, this.currentValue);
        }

        @Override
        public String toCode() {
            return "const " + this.type + " " + this.name + " = " + this.getCurrentValue() + ";";
        }

        @Override
        public String uniqueName() {
            return "C\uffff" + this.name;
        }
    }

    public static class Define
    extends Option {
        private static final int GROUP_DISABLED = 1;
        private static final int GROUP_NAME = 2;
        private static final int GROUP_VALUE = 3;
        private static final int GROUP_ALLOWED = 4;
        private static final Pattern DEFINE_REGEX = Pattern.compile("^\\s*(//)?\\s*#define\\s+(\\w+)(?:\\s+([\\w.-]+))?\\s*(?://(?:.*?\\[(.*?)])?.*)?$");
        private static final MicroCache<String, Define> cache = new MicroCache();

        private Define(String name, State state, List<? extends Value> legalValues, int defaultValue, int currentValue) {
            super(name, state, legalValues, defaultValue, currentValue);
        }

        public static Int2ObjectMap<Option> find(List<TaggedLine> code, boolean readonly) {
            Int2ObjectRBTreeMap output = new Int2ObjectRBTreeMap();
            int size = code.size();
            for (int i = 0; i < size; ++i) {
                Define opt;
                TaggedLine line = code.get(i);
                switch (line.tag()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Standard: 
                    case Macro: {
                        Define define = Define.get(line.text(), readonly);
                        break;
                    }
                    case MultilineComment: {
                        Define define = opt = null;
                    }
                }
                if (opt == null) continue;
                output.put(i, (Object)opt);
            }
            return output;
        }

        private static Define get(String code, boolean readonly) {
            Define v = cache.getCached(code, Define::getUncached);
            return v == null ? null : v.copy(readonly);
        }

        private static Define getUncached(String code) {
            Matcher match = DEFINE_REGEX.matcher(code);
            if (!match.matches()) {
                return null;
            }
            String disabled = match.group(1);
            String name = match.group(2);
            String valueStr = match.group(3);
            if (valueStr != null) {
                if (disabled != null) {
                    return null;
                }
                Value value = Value.detect(valueStr);
                List<? extends Value> allowed = Option.tryParseAllowedGroup(value, match.group(4));
                if (allowed == null) {
                    return new Define(name, State.Unconfigurable, Collections.singletonList(value), 0, 0);
                }
                int idx = Option.valueIndexOf(value, allowed);
                return new Define(name, State.Readonly, allowed, idx, idx);
            }
            int idx = disabled == null ? 1 : 0;
            return new Define(name, State.Readonly, TOGGLE_VALUES, idx, idx);
        }

        @Override
        public Define copy(boolean readonly) {
            if (this.state == State.Unconfigurable) {
                return this;
            }
            if (readonly && this.state == State.Readonly) {
                return this;
            }
            return new Define(this.name, readonly ? State.Readonly : State.Mutable, this.legalValues, this.defaultValue, this.currentValue);
        }

        @Override
        public String toCode() {
            StringBuilder res = new StringBuilder();
            if (this.legalValues == TOGGLE_VALUES) {
                if (this.getCurrentValue() == Value.Bool.False) {
                    res.append("//");
                }
                res.append("#define ").append(this.name);
                return res.toString();
            }
            res.append("#define ").append(this.name).append(' ').append(this.getCurrentValue());
            return res.toString();
        }

        @Override
        public String uniqueName() {
            return "D\uffff" + this.name;
        }
    }

    public static enum State {
        Mutable,
        Readonly,
        Unconfigurable;

    }

    public static enum ValueType {
        Int,
        Double,
        Str,
        Toggle;

    }
}

