/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.mappings;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class IntParsingUtils {
    @Nullable
    public static IntList parseUnsignedIntMulti(@NotNull String s) {
        String[] parts = StringUtils.split((String)s, (char)',');
        IntArrayList res = null;
        for (String part : parts) {
            if (part.indexOf(45) < 0) {
                int value = IntParsingUtils.parseUnsignedInt(part);
                if (value < 0) continue;
                if (res == null) {
                    res = new IntArrayList();
                }
                res.add(value);
                continue;
            }
            String[] subParts = StringUtils.split((String)part, (char)'-');
            if (subParts.length != 2) continue;
            int min = IntParsingUtils.parseUnsignedInt(subParts[0]);
            int max = IntParsingUtils.parseUnsignedInt(subParts[1]);
            if (min < 0 || max < 0 || min > max) continue;
            for (int i = min; i <= max; ++i) {
                if (res == null) {
                    res = new IntArrayList();
                }
                res.add(i);
            }
        }
        return res;
    }

    public static @Range(from=-1L, to=0x7FFFFFFFL) int parseUnsignedInt(@NotNull String s) {
        return IntParsingUtils.parseUnsignedInt(s, 10);
    }

    public static @Range(from=-1L, to=0x7FFFFFFFL) int parseUnsignedInt(@NotNull String s, int radix) {
        char c;
        int i = 0;
        int len = s.length() - 1;
        int limit = -2147483647;
        if (len == -1) {
            return -1;
        }
        while (Character.isWhitespace(c = s.charAt(i))) {
            ++i;
        }
        if (c < '0') {
            return -1;
        }
        int multmin = -2147483647 / radix;
        int result = 0;
        while (!Character.isWhitespace(c)) {
            int digit = Character.digit(c, radix);
            if (digit < 0 || result < multmin) {
                return -1;
            }
            if ((result *= radix) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
            if (i >= len) break;
            c = s.charAt(++i);
        }
        return -result;
    }
}

