/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader.config;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.resources.ShaderPackManager;
import com.ventooth.swansong.shader.config.ConfigEntry;
import com.ventooth.swansong.shader.loader.config.ConfigScreen;
import com.ventooth.swansong.shader.preprocessor.Option;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.resources.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigRootScreen
extends ConfigScreen
implements ConfigEntry.RootScreen {
    private final ObjectList<@NotNull Option> allOptions;
    private final IntList initialValues;

    public ConfigRootScreen(Locale locale, @NotNull ObjectList<@Nullable ConfigEntry> content, @NotNull @NotNull ObjectList<@NotNull Option> allOptions) {
        super(locale, null, content);
        this.allOptions = allOptions;
        this.initialValues = new IntArrayList(allOptions.size());
        for (Option opt : allOptions) {
            this.initialValues.add(opt.getValueIndex());
        }
    }

    @Override
    public void cancel() {
        for (int i = 0; i < this.allOptions.size(); ++i) {
            ((Option)this.allOptions.get(i)).setValueIndex(this.initialValues.getInt(i));
        }
    }

    @Override
    public boolean isModified() {
        for (int i = 0; i < this.allOptions.size(); ++i) {
            if (((Option)this.allOptions.get(i)).getValueIndex() == this.initialValues.getInt(i)) continue;
            return true;
        }
        return false;
    }

    boolean isModified(int index) {
        return ((Option)this.allOptions.get(index)).getValueIndex() != this.initialValues.getInt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Path configFile = ShaderPackManager.resolvePath(ShaderPackManager.currentShaderPackName + ".txt");
        PrintWriter writer = null;
        try {
            for (int i = 0; i < this.allOptions.size(); ++i) {
                Option entry = (Option)this.allOptions.get(i);
                this.initialValues.set(i, entry.getValueIndex());
                if (entry.isDefaultValue()) continue;
                if (writer == null) {
                    writer = new PrintWriter(Files.newBufferedWriter(configFile, new OpenOption[0]));
                }
                writer.println(entry.toProps());
            }
        }
        catch (IOException e) {
            Share.log.error("Failed to save shader configuration", (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            } else {
                try {
                    Files.deleteIfExists(configFile);
                }
                catch (Throwable t) {
                    Share.log.error("Failed to remove empty shader configuration file", t);
                }
            }
        }
    }

    @Override
    public void fullReset() {
        this.reset();
        for (Option entry : this.allOptions) {
            entry.setToDefault();
        }
    }
}

