/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader.loader;

import com.ventooth.swansong.shader.Report;
import com.ventooth.swansong.shader.loader.CompiledProgram;
import com.ventooth.swansong.shader.loader.IShaderPool;
import com.ventooth.swansong.shader.loader.ShaderLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MultiShaderPool
implements IShaderPool {
    private final IShaderPool primary;
    private final LinkedList<Supplier<IShaderPool>> unInitialized;
    private final List<IShaderPool> initialized = new ArrayList<IShaderPool>();
    @Nullable
    private final Report report;

    public MultiShaderPool(IShaderPool primary, Iterable<ShaderLoader> loaders, @Nullable Report report) {
        this.primary = primary;
        this.unInitialized = new LinkedList();
        for (ShaderLoader loader : loaders) {
            this.unInitialized.add(() -> {
                loader.lazyLoad(null);
                return loader.borrowOutShaderPool();
            });
        }
        this.report = report;
    }

    @Override
    public CompiledProgram borrowShader(ResourceLocation loc, boolean essential) {
        CompiledProgram prog = this.primary.borrowShader(loc, essential);
        if (prog != null) {
            return prog;
        }
        if (!essential) {
            return null;
        }
        for (IShaderPool pool : this.initialized) {
            CompiledProgram prog2 = pool.borrowShader(loc, true);
            if (prog2 == null) continue;
            if (this.report != null) {
                this.report.shadersFallbackInternal.add(prog2.path());
            }
            return prog2;
        }
        while (!this.unInitialized.isEmpty()) {
            IShaderPool pool = this.unInitialized.removeFirst().get();
            this.initialized.add(pool);
            CompiledProgram prog3 = pool.borrowShader(loc, true);
            if (prog3 == null) continue;
            if (this.report != null) {
                this.report.shadersFallbackInternal.add(prog3.path());
            }
            return prog3;
        }
        return null;
    }

    @Override
    public void close() {
        this.primary.close();
        this.initialized.forEach(IShaderPool::close);
        this.initialized.clear();
    }
}

