/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.debug.DebugMarker;
import com.ventooth.swansong.debug.GLDebugGroups;
import com.ventooth.swansong.mixin.extensions.WorldRendererExt;
import com.ventooth.swansong.mixin.interfaces.ShaderGameSettings;
import com.ventooth.swansong.resources.ShaderPackManager;
import com.ventooth.swansong.shader.BufferNameUtil;
import com.ventooth.swansong.shader.ClippingHelperShadow;
import com.ventooth.swansong.shader.CompositeTextureData;
import com.ventooth.swansong.shader.DrawBuffers;
import com.ventooth.swansong.shader.FixedEngineState;
import com.ventooth.swansong.shader.MCRenderStage;
import com.ventooth.swansong.shader.Report;
import com.ventooth.swansong.shader.ShaderEntityData;
import com.ventooth.swansong.shader.ShaderState;
import com.ventooth.swansong.shader.ShadersCompositeMesh;
import com.ventooth.swansong.shader.StateGraph;
import com.ventooth.swansong.shader.config.ConfigEntry;
import com.ventooth.swansong.shader.loader.ShaderLoaderOutParams;
import com.ventooth.swansong.shader.shaderobjects.CompositeShader;
import com.ventooth.swansong.shader.shaderobjects.GBufferShader;
import com.ventooth.swansong.shader.shaderobjects.ManagedShader;
import com.ventooth.swansong.shader.shaderobjects.ShadowShader;
import com.ventooth.swansong.shader.texbuf.CompositePipeline;
import com.ventooth.swansong.sufrace.CustomTexture2D;
import com.ventooth.swansong.sufrace.Framebuffer;
import com.ventooth.swansong.sufrace.HFNoiseTexture2D;
import com.ventooth.swansong.sufrace.Texture2D;
import com.ventooth.swansong.uniforms.StatefulBuiltins;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL33;

public final class ShaderEngine {
    public static final boolean DO_GRAPH_LOG = false;
    public static final Logger log = Share.getLogger();
    static final ShaderEntityData shaderData = ShaderEntityData.get();
    private static final Matrix4d tempMat4 = new Matrix4d();
    private static final DoubleBuffer tempDoubleBuffer = BufferUtils.createDoubleBuffer((int)16);
    @Nullable
    static FixedEngineState state;
    private static Map<CompositeTextureData, Texture2D> gbuffersCustomTex;
    private static Map<CompositeTextureData, Texture2D> compositeCustomTex;
    private static Map<CompositeTextureData, Texture2D> deferredCustomTex;
    private static Texture2D noiseTex;
    private static DrawBuffers buffers;
    @Nullable
    private static CompositePipeline deferredPipeline;
    @Nullable
    private static CompositePipeline compositePipeline;
    @Nullable
    private static CompositePipeline finalPipeline;
    private static Framebuffer mcFramebuffer;
    private static Texture2D mcTexture;
    private static int blitSrcSampler;
    private static final AbstractObjectList<ManagedShader> shaderStack;
    public static boolean needsFramebufferResize;
    public static boolean needsShaderPackReload;
    private static boolean useShaderLocked;
    private static int shaderSwitches;
    public static int prevFrameShaderSwitches;
    public static List<StateGraph.Node> graphLog;
    public static StateGraph graph;
    private static final boolean COMBINED_DEPTH = true;
    @Nullable
    public static Frustrum mcFrustrum;
    @Nullable
    private static Frustrum frustrum;
    @Nullable
    private static ClippingHelperShadow ch;
    private static int shadowFrustumCheckOffset;

    public static Locale locale() {
        return state == null ? null : ShaderEngine.state.locale;
    }

    public static ConfigEntry.RootScreen configScreen() {
        return state == null ? null : ShaderEngine.state.configScreen;
    }

    public static boolean isInitialized() {
        return state != null;
    }

    public static boolean shadowPassExists() {
        if (state == null) {
            return false;
        }
        return ShaderEngine.state.shadow != null;
    }

    static void renderHand() {
        ShaderEngine.sampleCenterDepth();
        DebugMarker.GENERIC.insert("PRE_COPY_DEPTH_2");
        ShaderEngine.blitDepth(ShaderEngine.buffers.gDepthTex, ShaderEngine.buffers.depthTex2);
        DebugMarker.GENERIC.insert("POST_COPY_DEPTH_2");
        if (!ShaderState.isHeldItemTranslucent()) {
            Minecraft mc = Minecraft.func_71410_x();
            boolean isGuiVisible = !mc.field_71474_y.field_74319_N;
            boolean isFirstPerson = mc.field_71474_y.field_74320_O == 0;
            boolean isSleeping = mc.field_71451_h.func_70608_bn();
            if (isGuiVisible && isFirstPerson && !isSleeping) {
                ShaderEngine.renderHand(false);
            }
        }
        DebugMarker.GENERIC.insert("PRE_COPY_DEPTH_0");
        ShaderEngine.blitDepth(ShaderEngine.buffers.gDepthTex, ShaderEngine.buffers.depthTex0);
        DebugMarker.GENERIC.insert("POST_COPY_DEPTH_0");
        DebugMarker.GENERIC.insert("PRE_COPY_DEPTH_1");
        ShaderEngine.blitDepth(ShaderEngine.buffers.gDepthTex, ShaderEngine.buffers.depthTex1);
        DebugMarker.GENERIC.insert("POST_COPY_DEPTH_1");
    }

    private static void sampleCenterDepth() {
        assert (state != null) : "Not Initialized";
        if (ShaderEngine.state.depthSampler != null) {
            ShaderEngine.buffers.tempDepth.bindRead();
            GL30.glFramebufferTexture2D((int)36008, (int)36096, (int)3553, (int)ShaderEngine.buffers.gDepthTex.glName(), (int)0);
            Vector2ic viewSize = ShaderState.viewSize();
            int centerX = viewSize.x() / 2;
            int centerY = viewSize.y() / 2;
            ShaderEngine.state.depthSampler.scheduleSample(centerX, centerY);
            GL30.glBindFramebuffer((int)36008, (int)0);
        }
    }

    public static boolean hasPortalShader() {
        if (state == null) {
            return false;
        }
        return !ShaderEngine.state.manager.portal.isFallback();
    }

    public static void beginRenderAllPre() {
        if (ShaderEngine.isInitialized()) {
            return;
        }
        if (!needsShaderPackReload) {
            return;
        }
        ShaderEngine.doShaderPackReload();
    }

    public static void beginRenderAll() {
        needsFramebufferResize = ShaderState.updateViewSize();
        if (needsShaderPackReload) {
            if (!ShaderEngine.doShaderPackReload()) {
                return;
            }
        } else if (needsFramebufferResize) {
            ShaderEngine.doFramebufferResize();
        }
        needsShaderPackReload = false;
        needsFramebufferResize = false;
        assert (state != null) : "Not Initialized";
        prevFrameShaderSwitches = shaderSwitches;
        shaderSwitches = 0;
        ShaderEngine.clearColorBufs();
        ShaderEngine.use(null);
        mcFramebuffer.bind();
    }

    public static void endRenderAll() {
    }

    private static void alphaAndDepthClear() {
        GL11.glPushAttrib((int)1048575);
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glPopAttrib();
    }

    private static void renderHand(boolean isTranslucent) {
        assert (state != null) : "Not Initialized";
        Minecraft mc = Minecraft.func_71410_x();
        float partialTick = ShaderState.getSubTick();
        EntityRenderer entityRenderer = Minecraft.func_71410_x().field_71460_t;
        float anaglyph = ((ShaderGameSettings)mc.field_71474_y).swan$anaglyph();
        int anaglyphField = EntityRenderer.field_78515_b;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        float handDepth = 0.125f;
        double fov = Math.toRadians(entityRenderer.func_78481_a(partialTick, false));
        double aspect = ShaderState.aspectRatio();
        double near = 0.05;
        float far = entityRenderer.field_78530_s * 2.0f;
        tempDoubleBuffer.clear();
        tempMat4.scaling(1.0, 1.0, 0.125);
        if (anaglyph != 0.0f) {
            tempMat4.translate((double)((float)(-(anaglyphField * 2 - 1)) * 0.07f * anaglyph), 0.0, 0.0);
        }
        tempMat4.perspective(fov, aspect, 0.05, (double)far);
        tempMat4.get(tempDoubleBuffer);
        GL11.glLoadMatrix((DoubleBuffer)tempDoubleBuffer);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        if (anaglyph != 0.0f) {
            GL11.glTranslatef((float)((float)(anaglyphField * 2 - 1) * 0.1f * anaglyph), (float)0.0f, (float)0.0f);
        }
        entityRenderer.func_78482_e(partialTick);
        if (mc.field_71474_y.field_74336_f) {
            entityRenderer.func_78475_f(partialTick);
        }
        ManagedShader lastShader = ShaderEngine.state.manager.current();
        if (isTranslucent) {
            ShaderState.updateRenderStage(MCRenderStage.HAND_TRANSLUCENT);
            ShaderEngine.use(ShaderEngine.state.manager.hand_water);
        } else {
            ShaderState.updateRenderStage(MCRenderStage.HAND_SOLID);
            ShaderEngine.use(ShaderEngine.state.manager.hand);
        }
        GL11.glDepthMask((boolean)true);
        entityRenderer.func_78463_b((double)partialTick);
        entityRenderer.field_78516_c.func_78440_a(partialTick);
        entityRenderer.func_78483_a((double)partialTick);
        ShaderEngine.use(lastShader);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        ShaderState.updateRenderStage(MCRenderStage.NONE);
    }

    private static void captureLastDepth() {
        if (ShaderState.isHeldItemTranslucent()) {
            Minecraft mc = Minecraft.func_71410_x();
            boolean isGuiVisible = !mc.field_71474_y.field_74319_N;
            boolean isFirstPerson = mc.field_71474_y.field_74320_O == 0;
            boolean isSleeping = mc.field_71451_h.func_70608_bn();
            if (isGuiVisible && isFirstPerson && !isSleeping) {
                ShaderEngine.renderHand(true);
            }
        }
        DebugMarker.GENERIC.insert("PRE_COPY_DEPTH_0");
        ShaderEngine.blitDepth(ShaderEngine.buffers.gDepthTex, ShaderEngine.buffers.depthTex0);
        DebugMarker.GENERIC.insert("POST_COPY_DEPTH_0");
    }

    private static void renderComposite() {
        assert (state != null) : "Not Initialized";
        if (compositePipeline != null) {
            GLDebugGroups.RENDER_COMPOSITE.push();
            compositePipeline.run();
            GLDebugGroups.RENDER_COMPOSITE.pop();
        }
    }

    private static void renderFinal() {
        assert (state != null) : "Not Initialized";
        float anaglyph = ((ShaderGameSettings)Minecraft.func_71410_x().field_71474_y).swan$anaglyph();
        if (finalPipeline != null) {
            finalPipeline.run();
        } else {
            Texture2D dst;
            Texture2D src = ShaderEngine.buffers.gColor.get(CompositeTextureData.colortex0);
            if (Texture2D.sizeEquals(src, dst = mcTexture)) {
                ShaderEngine.use(ShaderEngine.state.manager.blit_color_identical);
            } else {
                ShaderEngine.use(ShaderEngine.state.manager.blit_color_mismatched);
            }
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
            GL13.glActiveTexture((int)(33984 + CompositeTextureData.blitsrc.gpuIndex()));
            src.bind();
            GL13.glActiveTexture((int)33984);
            if (anaglyph != 0.0f) {
                ShadersCompositeMesh.drawWithAnaglyphField(EntityRenderer.field_78515_b);
            } else {
                ShadersCompositeMesh.drawWithColor();
            }
            if (DebugMarker.isEnabled()) {
                DebugMarker.TEXTURE_COLOR_BLIT.insertFormat("{0} -> {1}", src.name(), mcTexture.name());
            }
        }
    }

    @Nullable
    private static WorldProvider mcDimensionID() {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (world == null) {
            return null;
        }
        WorldProvider provider = world.field_73011_w;
        if (provider == null) {
            return null;
        }
        return provider;
    }

    public static void firstInit() {
        if (state != null) {
            throw new IllegalStateException("First init called twice!");
        }
        log.info("Initializing for the very first time...");
        try {
            ShaderState.updateViewSize();
            ShaderEngine.doShaderPackReload();
        }
        catch (Error | RuntimeException e) {
            log.fatal("Failed to initialize: ", e);
            throw e;
        }
        log.info("Successful Init");
    }

    public static void scheduleShaderPackReload() {
        log.debug("Scheduled ShaderPack Reload");
        needsShaderPackReload = true;
    }

    public static void scheduleFramebufferResize() {
        assert (state != null) : "Not Initialized";
        log.debug("Scheduled Framebuffer Resize");
        needsFramebufferResize = true;
    }

    private static boolean doShaderPackReload() {
        ShaderEngine.deinit();
        if ("(disabled)".equals(ShaderPackManager.currentShaderPackName)) {
            ShaderEngine.reloadMinecraftRenderersSafe();
            needsShaderPackReload = false;
            return false;
        }
        Report report = new Report();
        try {
            ShaderEngine.init(report);
            Vector2ic viewSize = ShaderState.viewSize();
            int width = viewSize.x();
            int height = viewSize.y();
            ShaderEngine.resizeFramebuffers(width, height, report);
            needsShaderPackReload = false;
            needsFramebufferResize = false;
            report.endTime = System.nanoTime();
            report.print();
            return true;
        }
        catch (RuntimeException e) {
            report.endTime = System.nanoTime();
            report.print();
            log.error("Caught internal error while loading shaderpack!");
            log.error("Please report this as a bug:", (Throwable)e);
            ShaderEngine.deinit();
            ShaderPackManager.setShaderPackByName("(disabled)");
            ShaderEngine.reloadMinecraftRenderersSafe();
            needsShaderPackReload = false;
            return false;
        }
    }

    private static void doFramebufferResize() {
        Vector2ic viewSize = ShaderState.viewSize();
        int width = viewSize.x();
        int height = viewSize.y();
        ShaderEngine.resizeFramebuffers(width, height, null);
        needsFramebufferResize = false;
    }

    private static void init(Report report) {
        report.startTime = System.nanoTime();
        state = FixedEngineState.init(ShaderEngine.mcDimensionID(), report);
        ShaderEngine.use(null);
        ShadersCompositeMesh.init();
        gbuffersCustomTex = new EnumMap<CompositeTextureData, Texture2D>(CompositeTextureData.class);
        compositeCustomTex = new EnumMap<CompositeTextureData, Texture2D>(CompositeTextureData.class);
        deferredCustomTex = new EnumMap<CompositeTextureData, Texture2D>(CompositeTextureData.class);
        if (!ShaderEngine.state.textures.isEmpty()) {
            for (ShaderLoaderOutParams.StagedTexture stagedTex : ShaderEngine.state.textures) {
                Map<CompositeTextureData, Texture2D> stagedCustomTexMap;
                CompositeTextureData index = BufferNameUtil.gbufferIndexFromName(stagedTex.bufferName());
                if (index == null) {
                    Share.log.error("Unknown buffer index for custom texture: {}", new Object[]{stagedTex});
                    continue;
                }
                switch (stagedTex.stage()) {
                    case "gbuffers": {
                        Map<CompositeTextureData, Texture2D> map = gbuffersCustomTex;
                        break;
                    }
                    case "composite": {
                        Map<CompositeTextureData, Texture2D> map = compositeCustomTex;
                        break;
                    }
                    case "deferred": {
                        Map<CompositeTextureData, Texture2D> map = deferredCustomTex;
                        break;
                    }
                    default: {
                        Map<CompositeTextureData, Texture2D> map = stagedCustomTexMap = null;
                    }
                }
                if (stagedCustomTexMap == null) {
                    Share.log.error("Unknown stage for custom texture: {}", new Object[]{stagedTex});
                    continue;
                }
                if (stagedCustomTexMap.containsKey((Object)index)) {
                    Share.log.error("Duplicate custom texture {} ignored", new Object[]{stagedTex});
                    continue;
                }
                String path = "/shaders/" + stagedTex.path();
                CustomTexture2D customTex = CustomTexture2D.load(ShaderEngine.state.pack, path);
                if (customTex == null) {
                    Share.log.error("Missing custom texture {}, on exact path: {}", new Object[]{stagedTex, path});
                    continue;
                }
                stagedCustomTexMap.put(index, customTex);
                Share.log.debug("Loaded Custom Texture: {}", new Object[]{stagedTex});
                report.customTextures.put(stagedTex.path(), new Report.TextureInfo(customTex.width(), customTex.height(), BufferNameUtil.gbufferFormatNameFromEnum(customTex.internalFormat())));
            }
        }
        gbuffersCustomTex = gbuffersCustomTex.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(gbuffersCustomTex);
        compositeCustomTex = compositeCustomTex.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(compositeCustomTex);
        deferredCustomTex = deferredCustomTex.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(deferredCustomTex);
        if (ShaderEngine.state.noiseTexPath != null) {
            String path = "/shaders/" + ShaderEngine.state.noiseTexPath;
            noiseTex = CustomTexture2D.load(ShaderEngine.state.pack, path);
            if (noiseTex == null) {
                Share.log.error("Missing noise texture: {}", new Object[]{path});
            } else {
                report.customTextures.put(ShaderEngine.state.noiseTexPath, new Report.TextureInfo(noiseTex.width(), noiseTex.height(), BufferNameUtil.gbufferFormatNameFromEnum(noiseTex.internalFormat())));
            }
        } else if (ShaderEngine.state.noiseTexSize != null) {
            noiseTex = HFNoiseTexture2D.create(ShaderEngine.state.noiseTexSize, ShaderEngine.state.noiseTexSize);
            report.customTextures.put("noise", new Report.TextureInfo(noiseTex.width(), noiseTex.height(), BufferNameUtil.gbufferFormatNameFromEnum(noiseTex.internalFormat())));
        }
        StatefulBuiltins.reset();
        ShaderEngine.reloadMinecraftRenderersSafe();
        blitSrcSampler = GL33.glGenSamplers();
        GL33.glSamplerParameteri((int)blitSrcSampler, (int)10242, (int)10496);
        GL33.glSamplerParameteri((int)blitSrcSampler, (int)10243, (int)10496);
        GL33.glSamplerParameteri((int)blitSrcSampler, (int)10241, (int)9728);
        GL33.glSamplerParameteri((int)blitSrcSampler, (int)10240, (int)9728);
        GL33.glBindSampler((int)CompositeTextureData.blitsrc.gpuIndex(), (int)blitSrcSampler);
    }

    private static void deinit() {
        if (graph.isManaged()) {
            throw new IllegalStateException("Cannot deinit renderer while in managed mode!");
        }
        shaderData.reset();
        for (Texture2D tex : gbuffersCustomTex.values()) {
            tex.deinit();
        }
        gbuffersCustomTex = Collections.emptyMap();
        for (Texture2D tex : compositeCustomTex.values()) {
            tex.deinit();
        }
        compositeCustomTex = Collections.emptyMap();
        for (Texture2D tex : deferredCustomTex.values()) {
            tex.deinit();
        }
        deferredCustomTex = Collections.emptyMap();
        if (noiseTex != null) {
            noiseTex.deinit();
            noiseTex = null;
        }
        ShaderEngine.deinitFramebuffers();
        ShadersCompositeMesh.deinit();
        shaderStack.clear();
        if (state != null) {
            state.deinit();
            state = null;
        }
        if (blitSrcSampler != 0) {
            GL33.glDeleteSamplers((int)blitSrcSampler);
            blitSrcSampler = 0;
        }
    }

    public static void runDeferredPipeline() {
        if (deferredPipeline != null) {
            GLDebugGroups.RENDER_DEFERRED.push();
            deferredPipeline.run();
            GLDebugGroups.RENDER_DEFERRED.pop();
        }
    }

    private static void resizeFramebuffers(int width, int height, @Nullable Report report) {
        assert (state != null) : "Not Initialized";
        if (buffers == null) {
            ShaderEngine.initFramebuffers(width, height, report);
            return;
        }
        buffers.resize(width, height);
        if (deferredPipeline != null) {
            deferredPipeline.resize(width, height);
        }
        if (compositePipeline != null) {
            compositePipeline.resize(width, height);
        }
        if (finalPipeline != null) {
            finalPipeline.resize(width, height);
        }
        if (!DrawBuffers.isMinecraftUpToDate(mcFramebuffer, mcTexture)) {
            mcFramebuffer = DrawBuffers.wrapMinecraft();
            mcTexture = DrawBuffers.wrapMinecraftTexture();
            if (ShaderEngine.state.manager._final != null) {
                ShaderEngine.state.manager._final.framebuffer = mcFramebuffer;
            }
        }
        log.debug("Resized Framebuffer: {}x{}", new Object[]{width, height});
    }

    private static void initFramebuffers(int width, int height, @Nullable Report report) {
        assert (state != null) : "Not Initialized";
        ShaderEngine.deinitFramebuffers();
        DrawBuffers.Builder fbBuilder = DrawBuffers.builder();
        fbBuilder.colorDrawBufferConfigs(ShaderEngine.state.colorDrawBufferConfigs);
        if (ShaderEngine.shadowPassExists()) {
            fbBuilder.shadow(ShaderEngine.state.shadow);
        }
        fbBuilder.width(width).height(height);
        buffers = fbBuilder.build();
        buffers.attachTo((List<GBufferShader>)ShaderEngine.state.manager.gBufferList);
        if (ShaderEngine.state.manager.deferredList != null) {
            deferredPipeline = CompositePipeline.buildPipeline("deferred", "DA_", ShaderEngine.state.colorDrawBufferConfigs, deferredCustomTex, buffers, ShaderEngine.state.manager.deferredList, width, height, report);
        }
        if (ShaderEngine.state.manager.compositeList != null) {
            compositePipeline = CompositePipeline.buildPipeline("composite", "CA_", ShaderEngine.state.colorDrawBufferConfigs, compositeCustomTex, buffers, ShaderEngine.state.manager.compositeList, width, height, report);
        }
        mcTexture = DrawBuffers.wrapMinecraftTexture();
        mcFramebuffer = DrawBuffers.wrapMinecraft();
        if (ShaderEngine.state.manager._final != null) {
            ShaderEngine.state.manager._final.framebuffer = mcFramebuffer;
            finalPipeline = CompositePipeline.buildPipelineFinal(buffers, (ObjectList<CompositeShader>)ObjectLists.singleton((Object)ShaderEngine.state.manager._final), compositeCustomTex, report);
        }
        log.debug("Initialized Framebuffers");
    }

    private static void deinitFramebuffers() {
        if (buffers != null) {
            buffers.deinit();
            buffers = null;
        }
        if (deferredPipeline != null) {
            deferredPipeline.deinit();
            deferredPipeline = null;
        }
        if (compositePipeline != null) {
            compositePipeline.deinit();
            compositePipeline = null;
        }
        if (finalPipeline != null) {
            finalPipeline.deinit();
            finalPipeline = null;
        }
        mcFramebuffer = null;
        if (state != null) {
            DrawBuffers.detach(ShaderEngine.state.manager.gBufferList);
            if (ShaderEngine.state.manager._final != null) {
                ShaderEngine.state.manager._final.framebuffer = null;
            }
        }
        log.debug("Deinitialized Framebuffers");
    }

    public static void beginRenderWorld() {
        assert (state != null) : "Not Initialized";
        graph.moveTo(StateGraph.Node.BeginFrame);
        ShaderEngine.clearColorBufs();
        if (ShaderEngine.state.depthSampler != null) {
            ShaderState.updateCenterDepth(ShaderEngine.state.depthSampler.getSample());
        } else {
            ShaderState.updateCenterDepth(1.0);
        }
        ShaderState.updatePreRenderWorld();
        if (ShaderEngine.state.compiledUniforms != null) {
            ShaderEngine.state.compiledUniforms.update();
        }
        if (noiseTex != null) {
            GL13.glActiveTexture((int)(33984 + CompositeTextureData.noisetex.gpuIndex()));
            noiseTex.bind();
            GL13.glActiveTexture((int)33984);
        }
        ShaderState.updateCelestialAngle();
        ShaderEngine.renderShadowMap();
    }

    public static void preRenderLast() {
        DebugMarker.GENERIC.insert("PRE_SAVE_DEPTH_0");
        ShaderEngine.blitDepth(ShaderEngine.buffers.gDepthTex, ShaderEngine.buffers.depthTex0);
        DebugMarker.GENERIC.insert("POST_SAVE_DEPTH_0");
        DebugMarker.GENERIC.insert("PRE_LOAD_DEPTH_1");
        GL11.glClear((int)256);
        ShaderEngine.blitDepth(ShaderEngine.buffers.depthTex1, ShaderEngine.buffers.gDepthTex);
        DebugMarker.GENERIC.insert("POST_LOAD_DEPTH_1");
    }

    public static void finishRenderFinal() {
        ShaderState.updateRenderStage(MCRenderStage.NONE);
        DebugMarker.GENERIC.insert("PRE_COMBINE_DEPTH");
        ShaderEngine.blitDepth(ShaderEngine.buffers.depthTex0, ShaderEngine.buffers.gDepthTex, true);
        DebugMarker.GENERIC.insert("POST_COMBINE_DEPTH");
        ShaderEngine.captureLastDepth();
        ShaderEngine.renderComposite();
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        ShaderEngine.renderFinal();
        ShaderEngine.use(null);
        ShaderEngine.alphaAndDepthClear();
    }

    private static void clipRenderersByFrustumShadow(WorldRenderer[] wrs) {
        assert (frustrum != null) : "frustrum not initialized";
        int wrsLength = wrs.length;
        for (int i = 0; i < wrsLength; ++i) {
            WorldRenderer wr = wrs[i];
            WorldRendererExt wre = (WorldRendererExt)wr;
            wre.swan$backupFrustum();
            if (wr.func_78906_e() || wr.field_78927_l && (i + shadowFrustumCheckOffset & 0xF) != 0) continue;
            wr.func_78908_a((ICamera)frustrum);
        }
        ++shadowFrustumCheckOffset;
    }

    private static void addWorldToShadowReceivers(WorldRenderer[] wrs) {
        for (WorldRenderer wr : wrs) {
            WorldRendererExt wre = (WorldRendererExt)wr;
            if (wr == null || !wre.swan$initialized() || !wr.field_78936_t || !wr.field_78927_l || wr.func_78906_e()) continue;
            ch.addShadowReceiver(wr);
        }
    }

    private static void renderShadowMap() {
        assert (state != null) : "Not Initialized";
        if (ShaderEngine.state.shadow == null) {
            return;
        }
        if (frustrum == null) {
            frustrum = new Frustrum();
        }
        if (ch == null) {
            ch = new ClippingHelperShadow();
        }
        if (ShaderEngine.frustrum.field_78552_a == null) {
            ShaderEngine.frustrum.field_78552_a = ch;
        }
        GLDebugGroups.RENDER_SHADOW.push();
        float partialTicks = ShaderState.getSubTick();
        EntityRenderer entityRenderer = Minecraft.func_71410_x().field_71460_t;
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL11.glPushAttrib((int)1048575);
        Minecraft mc = Minecraft.func_71410_x();
        RenderGlobal renderGlobal = mc.field_71438_f;
        graph.moveTo(StateGraph.Node.ShadowBegin);
        int preShadowPassThirdPersonView = mc.field_71474_y.field_74320_O;
        mc.field_71474_y.field_74320_O = 1;
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        entityRenderer.func_78479_a(partialTicks, 2);
        ShaderState.setCameraShadow(ShaderEngine.state.shadow.resolution, ShaderEngine.state.shadow.distance, ShaderEngine.state.shadow.fov, ShaderEngine.state.shadow.intervalSize);
        ActiveRenderInfo.func_74583_a((EntityPlayer)mc.field_71439_g, (boolean)false);
        ShaderEngine.buffers.shadow.bindDraw();
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16640);
        WorldRenderer[] wrs = renderGlobal.field_72768_k;
        int numWrs = wrs.length;
        EntityLivingBase viewEntity = mc.field_71451_h;
        ShaderEngine.ch.shadowModelViewMatrix.set(ShaderState.shadowModelView());
        ch.begin();
        ShaderEngine.addWorldToShadowReceivers(wrs);
        if (mcFrustrum != null) {
            try {
                AxisAlignedBB aabb;
                Entity[] entities = mc.field_71441_e.field_72996_f.toArray(new Entity[0]);
                TileEntity[] tileEntities = mc.field_71441_e.field_147482_g.toArray(new TileEntity[0]);
                for (Entity entity : entities) {
                    aabb = entity.field_70121_D;
                    if (!mcFrustrum.func_78546_a(aabb)) continue;
                    ch.addShadowReceiver(aabb);
                }
                for (Entity entity : tileEntities) {
                    aabb = entity.getRenderBoundingBox();
                    if (!mcFrustrum.func_78546_a(aabb)) continue;
                    ch.addShadowReceiver(aabb);
                }
            }
            catch (RuntimeException e) {
                log.error("Caught error while doing the shadow culling: ", (Throwable)e);
            }
        }
        ch.end();
        ShaderEngine.clipRenderersByFrustumShadow(wrs);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)2884);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glEnable((int)3008);
        GLDebugGroups.RENDER_SHADOW_0_TERRAIN.push();
        graph.moveTo(StateGraph.Node.ShadowChunk0);
        renderGlobal.func_72724_a(0, numWrs, 0, (double)partialTicks);
        GLDebugGroups.RENDER_SHADOW_0_TERRAIN.pop();
        GL11.glShadeModel((int)7424);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GLDebugGroups.RENDER_SHADOW_0_ENTITIES.push();
        ForgeHooksClient.setRenderPass((int)0);
        RenderHelper.func_74519_b();
        renderGlobal.func_147589_a(viewEntity, (ICamera)frustrum, partialTicks);
        RenderHelper.func_74518_a();
        GLDebugGroups.RENDER_SHADOW_0_ENTITIES.pop();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        ShaderEngine.unlockShader();
        ShaderEngine.blitDepth(ShaderEngine.buffers.shadowDepthTex0, ShaderEngine.buffers.shadowDepthTex1);
        ShaderEngine.buffers.shadow.bind();
        ShaderEngine.lockShader();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glShadeModel((int)7425);
        GLDebugGroups.RENDER_SHADOW_1_TERRAIN.push();
        graph.moveTo(StateGraph.Node.ShadowChunk1);
        renderGlobal.func_72724_a(0, numWrs, 1, (double)partialTicks);
        GLDebugGroups.RENDER_SHADOW_1_TERRAIN.pop();
        GLDebugGroups.RENDER_SHADOW_1_ENTITIES.push();
        RenderHelper.func_74519_b();
        ForgeHooksClient.setRenderPass((int)1);
        renderGlobal.func_147589_a(viewEntity, (ICamera)frustrum, partialTicks);
        ForgeHooksClient.setRenderPass((int)-1);
        RenderHelper.func_74518_a();
        GLDebugGroups.RENDER_SHADOW_1_ENTITIES.pop();
        GL11.glShadeModel((int)7424);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        graph.moveTo(StateGraph.Node.ShadowLast);
        mc.field_71474_y.field_74320_O = preShadowPassThirdPersonView;
        if (ShaderEngine.state.shadow.depthMipmapEnabled(0)) {
            ShaderEngine.genMipmap(ShaderEngine.buffers.shadowDepthTex0);
        }
        if (ShaderEngine.state.shadow.depthMipmapEnabled(1)) {
            ShaderEngine.genMipmap(ShaderEngine.buffers.shadowDepthTex1);
        }
        if (ShaderEngine.state.shadow.colorMipmapEnabled(0)) {
            ShaderEngine.genMipmap(ShaderEngine.buffers.shadowColorTex0);
        }
        if (ShaderEngine.state.shadow.colorMipmapEnabled(1)) {
            ShaderEngine.genMipmap(ShaderEngine.buffers.shadowColorTex1);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL11.glPopAttrib();
        GLDebugGroups.RENDER_SHADOW.pop();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        for (WorldRenderer wr : wrs) {
            if (wr == null) continue;
            WorldRendererExt wre = (WorldRendererExt)wr;
            wre.swan$restoreFrustum();
        }
    }

    public static void bindCompositeTextures(Map<CompositeTextureData, Texture2D> textures) {
        for (Map.Entry<CompositeTextureData, Texture2D> entry : textures.entrySet()) {
            GL13.glActiveTexture((int)(33984 + entry.getKey().gpuIndex()));
            entry.getValue().bind();
        }
        GL13.glActiveTexture((int)(33984 + CompositeTextureData.depthtex0.gpuIndex()));
        ShaderEngine.buffers.depthTex0.bind();
        GL13.glActiveTexture((int)(33984 + CompositeTextureData.depthtex1.gpuIndex()));
        ShaderEngine.buffers.depthTex1.bind();
        GL13.glActiveTexture((int)(33984 + CompositeTextureData.depthtex2.gpuIndex()));
        ShaderEngine.buffers.depthTex2.bind();
        GL13.glActiveTexture((int)33984);
    }

    public static void genMipmaps(ObjectList<Texture2D> mipInputs) {
        GL11.glPushAttrib((int)1048575);
        GL13.glActiveTexture((int)33984);
        for (Texture2D mipInput : mipInputs) {
            mipInput.bind();
            GL30.glGenerateMipmap((int)3553);
            DebugMarker.TEXTURE_MIP_GEN.insert(mipInput.name());
        }
        GL11.glPopAttrib();
    }

    private static void genMipmap(@Nullable Texture2D tex) {
        if (tex == null) {
            return;
        }
        GL11.glPushAttrib((int)1048575);
        GL13.glActiveTexture((int)33984);
        tex.bind();
        GL30.glGenerateMipmap((int)3553);
        GL11.glPopAttrib();
    }

    public static void blitColors(Int2ObjectMap<Texture2D> src, Int2ObjectMap<Texture2D> dst) {
        Texture2D dstTex;
        Texture2D srcTex;
        if (state == null) {
            Share.log.warn("Tried to blit colors with no state");
            return;
        }
        int count = src.size();
        if (count != dst.size()) {
            throw new AssertionError();
        }
        GL33.glBindSampler((int)CompositeTextureData.blitsrc.gpuIndex(), (int)blitSrcSampler);
        GL13.glActiveTexture((int)(33984 + CompositeTextureData.blitsrc.gpuIndex()));
        ManagedShader lastShader = ShaderEngine.state.manager.current();
        boolean sizeEq = true;
        for (Int2ObjectMap.Entry srcEntry : Int2ObjectMaps.fastIterable(src)) {
            int i = srcEntry.getIntKey();
            srcTex = (Texture2D)srcEntry.getValue();
            if (Texture2D.sizeEquals(srcTex, dstTex = (Texture2D)dst.get(i))) continue;
            sizeEq = false;
            break;
        }
        if (sizeEq) {
            ShaderEngine.use(ShaderEngine.state.manager.blit_color_identical);
        } else {
            ShaderEngine.use(ShaderEngine.state.manager.blit_color_mismatched);
        }
        ShaderEngine.buffers.tempColor.bind();
        for (Int2ObjectMap.Entry srcEntry : Int2ObjectMaps.fastIterable(src)) {
            int index = srcEntry.getIntKey();
            srcTex = (Texture2D)srcEntry.getValue();
            srcTex.bind();
            dstTex = (Texture2D)dst.get(index);
            if (dstTex == null) {
                throw new AssertionError();
            }
            dstTex.attachToFramebufferColor(36064);
            ShadersCompositeMesh.drawWithColor();
            if (!DebugMarker.isEnabled()) continue;
            DebugMarker.TEXTURE_COLOR_BLIT.insertFormat("{0} -> {1}", srcTex.name(), dstTex.name());
        }
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL13.glActiveTexture((int)33984);
        ShaderEngine.use(lastShader);
    }

    public static void blitDepth(Texture2D srcTex, Texture2D dstTex) {
        ShaderEngine.blitDepth(srcTex, dstTex, false);
    }

    public static void blitDepth(Texture2D srcTex, Texture2D dstTex, boolean combine) {
        if (state == null) {
            Share.log.warn("Tried to blit depth with no state");
            return;
        }
        GL33.glBindSampler((int)CompositeTextureData.blitsrc.gpuIndex(), (int)blitSrcSampler);
        GL13.glActiveTexture((int)(33984 + CompositeTextureData.blitsrc.gpuIndex()));
        ManagedShader lastShader = ShaderEngine.state.manager.current();
        if (Texture2D.sizeEquals(srcTex, dstTex)) {
            ShaderEngine.use(ShaderEngine.state.manager.blit_depth_identical);
        } else {
            ShaderEngine.use(ShaderEngine.state.manager.blit_depth_mismatched);
        }
        ShaderEngine.buffers.tempDepth.bind();
        srcTex.bind();
        dstTex.attachToFramebufferDepth();
        if (!combine) {
            GL11.glClear((int)256);
        }
        ShadersCompositeMesh.drawWithDepth(combine);
        if (DebugMarker.isEnabled()) {
            DebugMarker.TEXTURE_DEPTH_BLIT.insertFormat("{0} -> {1}", srcTex.name(), dstTex.name());
        }
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL13.glActiveTexture((int)33984);
        ShaderEngine.use(lastShader);
    }

    public static void clearColorBufs() {
        ShaderEngine.buffers.tempColor.bind();
        ShaderEngine.buffers.gDepthTex.attachToFramebufferDepth();
        GL11.glClear((int)256);
        ShaderEngine.buffers.depthTex0.attachToFramebufferDepth();
        GL11.glClear((int)256);
        ShaderEngine.buffers.depthTex1.attachToFramebufferDepth();
        GL11.glClear((int)256);
        ShaderEngine.buffers.depthTex2.attachToFramebufferDepth();
        GL11.glClear((int)256);
        ShaderEngine.buffers.gColor.clear(ShaderState.fogColor());
    }

    private static void reloadMinecraftRenderersSafe() {
        try {
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
        catch (Throwable t) {
            log.error("Caught exception while reloading minecraft renderers!", t);
        }
    }

    public static void preSkyList() {
        if (!ShaderEngine.isInitialized()) {
            return;
        }
        ShaderState.setUpPosition();
        Vector3dc fogColor = ShaderState.fogColor();
        GL11.glColor3d((double)fogColor.x(), (double)fogColor.y(), (double)fogColor.z());
        Tessellator tess = Tessellator.field_78398_a;
        float farDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16;
        double xzq = (double)farDistance * 0.9238;
        double xzp = (double)farDistance * 0.3826;
        double xzn = -xzp;
        double xzm = -xzq;
        double top = 16.0;
        double bot = -ShaderState.camPos().y();
        tess.func_78382_b();
        tess.func_78377_a(xzn, bot, xzm);
        tess.func_78377_a(xzn, top, xzm);
        tess.func_78377_a(xzm, top, xzn);
        tess.func_78377_a(xzm, bot, xzn);
        tess.func_78377_a(xzm, bot, xzn);
        tess.func_78377_a(xzm, top, xzn);
        tess.func_78377_a(xzm, top, xzp);
        tess.func_78377_a(xzm, bot, xzp);
        tess.func_78377_a(xzm, bot, xzp);
        tess.func_78377_a(xzm, top, xzp);
        tess.func_78377_a(xzn, top, xzp);
        tess.func_78377_a(xzn, bot, xzp);
        tess.func_78377_a(xzn, bot, xzp);
        tess.func_78377_a(xzn, top, xzp);
        tess.func_78377_a(xzp, top, xzq);
        tess.func_78377_a(xzp, bot, xzq);
        tess.func_78377_a(xzp, bot, xzq);
        tess.func_78377_a(xzp, top, xzq);
        tess.func_78377_a(xzq, top, xzp);
        tess.func_78377_a(xzq, bot, xzp);
        tess.func_78377_a(xzq, bot, xzp);
        tess.func_78377_a(xzq, top, xzp);
        tess.func_78377_a(xzq, top, xzn);
        tess.func_78377_a(xzq, bot, xzn);
        tess.func_78377_a(xzq, bot, xzn);
        tess.func_78377_a(xzq, top, xzn);
        tess.func_78377_a(xzp, top, xzm);
        tess.func_78377_a(xzp, bot, xzm);
        tess.func_78377_a(xzp, bot, xzm);
        tess.func_78377_a(xzp, top, xzm);
        tess.func_78377_a(xzn, top, xzm);
        tess.func_78377_a(xzn, bot, xzm);
        tess.func_78381_a();
        Vector3dc skyColor = ShaderState.skyColor();
        GL11.glColor3d((double)skyColor.x(), (double)skyColor.y(), (double)skyColor.z());
    }

    static int getBlockID(Block block, int meta) {
        int blockID = Block.func_149682_b((Block)block);
        FixedEngineState _state = state;
        if (_state != null && _state.remapper != null) {
            return _state.remapper.remap(blockID, meta);
        }
        return blockID;
    }

    static int getBlockEntityID(TileEntity tileEntity) {
        return ShaderEngine.getBlockID(tileEntity.func_145838_q(), tileEntity.func_145832_p());
    }

    static int getEntityID(Entity entity) {
        return EntityList.func_75619_a((Entity)entity);
    }

    public static void useCompositeShader(CompositeShader shader) {
        ShaderEngine.use(shader);
    }

    static void pushShader() {
        shaderStack.push((Object)ShaderEngine.state.manager.current());
    }

    static void popShader() {
        if (shaderStack.isEmpty()) {
            throw new IllegalStateException("Tried to pop empty shader stack");
        }
        ShaderEngine.state.manager.use((ManagedShader)shaderStack.pop());
    }

    static void lockShader() {
        useShaderLocked = true;
    }

    static void unlockShader() {
        useShaderLocked = false;
    }

    static void use(@Nullable ManagedShader shader) {
        if (useShaderLocked) {
            throw new IllegalStateException("Tried to switch shaders while locked!");
        }
        if (state == null) {
            Share.log.warn("Tried to bind shader with no state!");
            return;
        }
        if (!ShaderEngine.state.manager.use(shader)) {
            return;
        }
        ++shaderSwitches;
        if (shader != null) {
            boolean resetTexture = false;
            boolean isGBuffer = shader instanceof GBufferShader;
            boolean isShadow = shader instanceof ShadowShader;
            if (isGBuffer) {
                if (ShaderEngine.buffers.shadowColorTex0 != null) {
                    GL13.glActiveTexture((int)(33984 + CompositeTextureData.shadowcolor0.gpuIndex()));
                    resetTexture = true;
                    ShaderEngine.buffers.shadowColorTex0.bind();
                }
                if (ShaderEngine.buffers.shadowColorTex1 != null) {
                    GL13.glActiveTexture((int)(33984 + CompositeTextureData.shadowcolor1.gpuIndex()));
                    resetTexture = true;
                    ShaderEngine.buffers.shadowColorTex1.bind();
                }
                if (ShaderEngine.buffers.shadowDepthTex0 != null) {
                    GL13.glActiveTexture((int)(33984 + CompositeTextureData.shadowtex0.gpuIndex()));
                    resetTexture = true;
                    ShaderEngine.buffers.shadowDepthTex0.bind();
                }
                if (ShaderEngine.buffers.shadowDepthTex1 != null) {
                    GL13.glActiveTexture((int)(33984 + CompositeTextureData.shadowtex1.gpuIndex()));
                    resetTexture = true;
                    ShaderEngine.buffers.shadowDepthTex1.bind();
                }
            }
            if (isGBuffer || isShadow) {
                for (Map.Entry<CompositeTextureData, Texture2D> entry : gbuffersCustomTex.entrySet()) {
                    GL13.glActiveTexture((int)(33984 + entry.getKey().gpuIndex()));
                    resetTexture = true;
                    entry.getValue().bind();
                }
            }
            if (resetTexture) {
                GL13.glActiveTexture((int)33984);
            }
        }
    }

    @Generated
    private ShaderEngine() {
    }

    static {
        gbuffersCustomTex = Collections.emptyMap();
        compositeCustomTex = Collections.emptyMap();
        deferredCustomTex = Collections.emptyMap();
        shaderStack = new ObjectArrayList();
        useShaderLocked = false;
        shaderSwitches = 0;
        prevFrameShaderSwitches = 0;
        graphLog = new ArrayList<StateGraph.Node>();
        graph = new StateGraph();
        shadowFrustumCheckOffset = 0;
    }
}

