/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.gl.GLTexture;
import com.ventooth.swansong.shader.CompositeTextureData;
import com.ventooth.swansong.shader.ShadowProperties;
import com.ventooth.swansong.shader.shaderobjects.GBufferShader;
import com.ventooth.swansong.shader.texbuf.BufferConfig;
import com.ventooth.swansong.shader.texbuf.ColorBuffers;
import com.ventooth.swansong.sufrace.Framebuffer;
import com.ventooth.swansong.sufrace.Texture2D;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawBuffers {
    @NotNull
    public final ColorBuffers gColor;
    @NotNull
    public final Texture2D gDepthTex;
    @NotNull
    public final Texture2D depthTex0;
    @NotNull
    public final Texture2D depthTex1;
    @NotNull
    public final Texture2D depthTex2;
    public final Texture2D shadowDepthTex0;
    public final Texture2D shadowDepthTex1;
    public final Texture2D shadowColorTex0;
    public final Texture2D shadowColorTex1;
    public final Framebuffer shadow;
    @NotNull
    public final Framebuffer tempColor;
    @NotNull
    public final Framebuffer tempDepth;
    @NotNull
    public final Framebuffer _final;
    private boolean deinited = false;

    public DrawBuffers(@NonNull Map<CompositeTextureData, BufferConfig> colorDrawBufferConfigs, @Nullable ShadowProperties shadow, int width, int height) {
        if (colorDrawBufferConfigs == null) {
            throw new NullPointerException("colorDrawBufferConfigs is marked non-null but is null");
        }
        this.gColor = new ColorBuffers(colorDrawBufferConfigs, "G_", width, height);
        this.gDepthTex = Texture2D.ofDepthDrawBuffer("G_depthtex", width, height);
        this.depthTex0 = Texture2D.ofDepthDrawBuffer("depthtex0", width, height);
        this.depthTex1 = Texture2D.ofDepthDrawBuffer("depthtex1", width, height);
        this.depthTex2 = Texture2D.ofDepthDrawBuffer("depthtex2", width, height);
        this.tempColor = Framebuffer.create("Temp_Color", false);
        this.tempDepth = Framebuffer.create("Temp_Depth", true);
        this._final = Framebuffer.create("Final", this.gColor.get(CompositeTextureData.colortex0));
        if (shadow != null) {
            this.shadowDepthTex0 = Texture2D.ofShadowDepthBuffer("shadow0", shadow.resolution, shadow.resolution, shadow.depthFilterNearest(0), shadow.depthMipmapEnabled(0), shadow.depthHWFilterEnabled(0));
            this.shadowDepthTex1 = Texture2D.ofShadowDepthBuffer("shadow1", shadow.resolution, shadow.resolution, shadow.depthFilterNearest(1), shadow.depthMipmapEnabled(1), shadow.depthHWFilterEnabled(1));
            this.shadowColorTex0 = Texture2D.ofShadowColorBuffer("shadowcolor0", shadow.resolution, shadow.resolution, shadow.colorFilterNearest(0), shadow.colorMipmapEnabled(0));
            this.shadowColorTex1 = Texture2D.ofShadowColorBuffer("shadowcolor1", shadow.resolution, shadow.resolution, shadow.colorFilterNearest(1), shadow.colorMipmapEnabled(1));
            this.shadow = Framebuffer.create("shadow_fb", this.shadowColorTex0, this.shadowColorTex1, this.shadowDepthTex0);
        } else {
            this.shadowDepthTex0 = null;
            this.shadowDepthTex1 = null;
            this.shadowColorTex0 = null;
            this.shadowColorTex1 = null;
            this.shadow = null;
        }
    }

    @Nullable
    public static CompositeTextureData textureFromColorTexIndex(int index) {
        CompositeTextureData compositeTextureData;
        switch (index) {
            case 0: {
                compositeTextureData = CompositeTextureData.colortex0;
                break;
            }
            case 1: {
                compositeTextureData = CompositeTextureData.colortex1;
                break;
            }
            case 2: {
                compositeTextureData = CompositeTextureData.colortex2;
                break;
            }
            case 3: {
                compositeTextureData = CompositeTextureData.colortex3;
                break;
            }
            case 4: {
                compositeTextureData = CompositeTextureData.colortex4;
                break;
            }
            case 5: {
                compositeTextureData = CompositeTextureData.colortex5;
                break;
            }
            case 6: {
                compositeTextureData = CompositeTextureData.colortex6;
                break;
            }
            case 7: {
                compositeTextureData = CompositeTextureData.colortex7;
                break;
            }
            case 8: {
                compositeTextureData = CompositeTextureData.colortex8;
                break;
            }
            case 9: {
                compositeTextureData = CompositeTextureData.colortex9;
                break;
            }
            case 10: {
                compositeTextureData = CompositeTextureData.colortex10;
                break;
            }
            case 11: {
                compositeTextureData = CompositeTextureData.colortex11;
                break;
            }
            case 12: {
                compositeTextureData = CompositeTextureData.colortex12;
                break;
            }
            case 13: {
                compositeTextureData = CompositeTextureData.colortex13;
                break;
            }
            case 14: {
                compositeTextureData = CompositeTextureData.colortex14;
                break;
            }
            case 15: {
                compositeTextureData = CompositeTextureData.colortex15;
                break;
            }
            default: {
                compositeTextureData = null;
            }
        }
        return compositeTextureData;
    }

    public static int colorTexIndexFromTexture(@NotNull CompositeTextureData id) {
        int n;
        switch (id) {
            case colortex0: {
                n = 0;
                break;
            }
            case colortex1: {
                n = 1;
                break;
            }
            case colortex2: {
                n = 2;
                break;
            }
            case colortex3: {
                n = 3;
                break;
            }
            case colortex4: {
                n = 4;
                break;
            }
            case colortex5: {
                n = 5;
                break;
            }
            case colortex6: {
                n = 6;
                break;
            }
            case colortex7: {
                n = 7;
                break;
            }
            case colortex8: {
                n = 8;
                break;
            }
            case colortex9: {
                n = 9;
                break;
            }
            case colortex10: {
                n = 10;
                break;
            }
            case colortex11: {
                n = 11;
                break;
            }
            case colortex12: {
                n = 12;
                break;
            }
            case colortex13: {
                n = 13;
                break;
            }
            case colortex14: {
                n = 14;
                break;
            }
            case colortex15: {
                n = 15;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    @Nullable
    public Texture2D getByID(@NotNull CompositeTextureData id) {
        Texture2D texture2D;
        switch (id) {
            case colortex0: {
                texture2D = this.gColor.get(CompositeTextureData.colortex0);
                break;
            }
            case colortex1: {
                texture2D = this.gColor.get(CompositeTextureData.colortex1);
                break;
            }
            case colortex2: {
                texture2D = this.gColor.get(CompositeTextureData.colortex2);
                break;
            }
            case colortex3: {
                texture2D = this.gColor.get(CompositeTextureData.colortex3);
                break;
            }
            case colortex4: {
                texture2D = this.gColor.get(CompositeTextureData.colortex4);
                break;
            }
            case colortex5: {
                texture2D = this.gColor.get(CompositeTextureData.colortex5);
                break;
            }
            case colortex6: {
                texture2D = this.gColor.get(CompositeTextureData.colortex6);
                break;
            }
            case colortex7: {
                texture2D = this.gColor.get(CompositeTextureData.colortex7);
                break;
            }
            case colortex8: {
                texture2D = this.gColor.get(CompositeTextureData.colortex8);
                break;
            }
            case colortex9: {
                texture2D = this.gColor.get(CompositeTextureData.colortex9);
                break;
            }
            case colortex10: {
                texture2D = this.gColor.get(CompositeTextureData.colortex10);
                break;
            }
            case colortex11: {
                texture2D = this.gColor.get(CompositeTextureData.colortex11);
                break;
            }
            case colortex12: {
                texture2D = this.gColor.get(CompositeTextureData.colortex12);
                break;
            }
            case colortex13: {
                texture2D = this.gColor.get(CompositeTextureData.colortex13);
                break;
            }
            case colortex14: {
                texture2D = this.gColor.get(CompositeTextureData.colortex14);
                break;
            }
            case colortex15: {
                texture2D = this.gColor.get(CompositeTextureData.colortex15);
                break;
            }
            case shadowtex0: {
                texture2D = this.shadowDepthTex0;
                break;
            }
            case shadowtex1: {
                texture2D = this.shadowDepthTex1;
                break;
            }
            case depthtex0: {
                texture2D = this.depthTex0;
                break;
            }
            case depthtex1: {
                texture2D = this.depthTex1;
                break;
            }
            case depthtex2: {
                texture2D = this.depthTex2;
                break;
            }
            case shadowcolor0: {
                texture2D = this.shadowColorTex0;
                break;
            }
            case shadowcolor1: {
                texture2D = this.shadowColorTex1;
                break;
            }
            default: {
                texture2D = null;
            }
        }
        return texture2D;
    }

    public void resize(int width, int height) {
        this.gColor.resize(width, height);
        this.gDepthTex.resize(width, height);
        this.depthTex0.resize(width, height);
        this.depthTex1.resize(width, height);
        this.depthTex2.resize(width, height);
    }

    public void attachTo(List<GBufferShader> gBufferList) {
        for (GBufferShader shader : gBufferList) {
            if (shader.framebuffer != null) {
                shader.framebuffer.deinit();
            }
            shader.framebuffer = Framebuffer.create(shader.loc().func_110623_a(), this.gColor.getFramebufferAttachments(shader.renderTargets()), this.gDepthTex);
        }
    }

    public static void detach(List<GBufferShader> gBufferList) {
        for (GBufferShader shader : gBufferList) {
            if (shader.framebuffer == null) continue;
            shader.framebuffer.deinit();
            shader.framebuffer = null;
        }
    }

    public static Texture2D wrapMinecraftTexture() {
        net.minecraft.client.shader.Framebuffer fb = Minecraft.func_71410_x().func_147110_a();
        GLTexture gl = new GLTexture();
        gl.glName = fb.field_147617_g;
        return new Texture2D("Minecraft", gl, 32856, fb.field_147621_c, fb.field_147618_d);
    }

    public static Framebuffer wrapMinecraft() {
        return Framebuffer.wrap("Minecraft", Minecraft.func_71410_x().func_147110_a().field_147616_f);
    }

    public static boolean isMinecraftUpToDate(Framebuffer fb, Texture2D texture) {
        if (fb == null) {
            return false;
        }
        net.minecraft.client.shader.Framebuffer mc = Minecraft.func_71410_x().func_147110_a();
        return fb.framebuffer.glName == mc.field_147616_f && texture.glName() == mc.field_147617_g && texture.width() == mc.field_147621_c && texture.height() == mc.field_147618_d;
    }

    public void deinit() {
        if (this.deinited) {
            return;
        }
        this.deinited = true;
        this.gColor.deinit();
        this.gDepthTex.deinit();
        this.depthTex0.deinit();
        this.depthTex1.deinit();
        this.depthTex2.deinit();
        this._final.deinit();
        this.tempColor.deinit();
        this.tempDepth.deinit();
        if (this.shadow != null) {
            this.shadow.deinit();
        }
        if (this.shadowDepthTex0 != null) {
            this.shadowDepthTex0.deinit();
        }
        if (this.shadowDepthTex1 != null) {
            this.shadowDepthTex1.deinit();
        }
        if (this.shadowColorTex0 != null) {
            this.shadowColorTex0.deinit();
        }
        if (this.shadowColorTex1 != null) {
            this.shadowColorTex1.deinit();
        }
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public static class Builder {
        @Generated
        private Map<CompositeTextureData, BufferConfig> colorDrawBufferConfigs;
        @Generated
        private ShadowProperties shadow;
        @Generated
        private int width;
        @Generated
        private int height;

        @Generated
        Builder() {
        }

        @Generated
        public Builder colorDrawBufferConfigs(@NonNull Map<CompositeTextureData, BufferConfig> colorDrawBufferConfigs) {
            if (colorDrawBufferConfigs == null) {
                throw new NullPointerException("colorDrawBufferConfigs is marked non-null but is null");
            }
            this.colorDrawBufferConfigs = colorDrawBufferConfigs;
            return this;
        }

        @Generated
        public Builder shadow(@Nullable ShadowProperties shadow) {
            this.shadow = shadow;
            return this;
        }

        @Generated
        public Builder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public Builder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public DrawBuffers build() {
            return new DrawBuffers(this.colorDrawBufferConfigs, this.shadow, this.width, this.height);
        }

        @Generated
        public String toString() {
            return "DrawBuffers.Builder(colorDrawBufferConfigs=" + this.colorDrawBufferConfigs + ", shadow=" + this.shadow + ", width=" + this.width + ", height=" + this.height + ")";
        }
    }
}

