/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.shader;

import com.ventooth.swansong.Share;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public final class DepthSampler {
    private static final Logger log = Share.getLogger();
    private static final int BUFFER_SIZE_BYTES = 64;
    private static final boolean USE_MAPPING = true;
    private static final int DELAY = 5;
    private int @Nullable [] glBuffers = null;
    @Nullable
    private ByteBuffer resultBuf = null;
    private int index = 0;

    public void init() {
        assert (this.glBuffers == null);
        this.glBuffers = new int[5];
        for (int i = 0; i < 5; ++i) {
            int buf;
            this.glBuffers[i] = buf = GL15.glGenBuffers();
            GL15.glBindBuffer((int)35051, (int)buf);
            GL15.glBufferData((int)35051, (long)64L, (int)35041);
        }
        GL15.glBindBuffer((int)35051, (int)0);
        this.index = 0;
        log.debug("Initialized");
        log.debug("Mapped buffers enabled");
        log.debug("Using: {} buffers, each sized at: {} bytes", new Object[]{5, 64});
    }

    public void deinit() {
        assert (this.glBuffers != null);
        for (int i = 0; i < 5; ++i) {
            int buf = this.glBuffers[i];
            GL15.glDeleteBuffers((int)buf);
        }
        this.glBuffers = null;
        this.resultBuf = null;
        this.index = 0;
        log.debug("Deinitialized");
    }

    public void scheduleSample(int centerX, int centerY) {
        assert (this.glBuffers != null);
        int buf = this.glBuffers[this.index];
        this.index = (this.index + 1) % 5;
        GL15.glBindBuffer((int)35051, (int)buf);
        GL11.glReadPixels((int)centerX, (int)centerY, (int)1, (int)1, (int)6402, (int)5126, (long)0L);
        GL15.glBindBuffer((int)35051, (int)0);
    }

    public float getSample() {
        try {
            if (this.glBuffers == null) {
                throw new NullPointerException("glBuffers not initialized!");
            }
            return this.getSampleWithMapping();
        }
        catch (Exception e) {
            log.error("Failed to sample center depth: ", (Throwable)e);
            return 0.0f;
        }
    }

    private float getSampleWithMapping() {
        assert (this.glBuffers != null);
        try {
            int buf = this.glBuffers[this.index];
            GL15.glBindBuffer((int)35051, (int)buf);
            this.resultBuf = GL15.glMapBuffer((int)35051, (int)35000, (long)64L, (ByteBuffer)this.resultBuf);
            float f = this.resultBuf.getFloat(0);
            return f;
        }
        finally {
            GL15.glUnmapBuffer((int)35051);
            GL15.glBindBuffer((int)35051, (int)0);
        }
    }

    private float getSampleNoMapping() {
        assert (this.glBuffers != null);
        assert (this.resultBuf != null);
        try {
            int buf = this.glBuffers[this.index];
            GL15.glBindBuffer((int)35051, (int)buf);
            GL15.glGetBufferSubData((int)35051, (long)0L, (ByteBuffer)this.resultBuf);
            float f = this.resultBuf.getFloat(0);
            return f;
        }
        finally {
            GL15.glBindBuffer((int)35051, (int)0);
        }
    }
}

