/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.mixin.mixins.client.texture;

import com.ventooth.swansong.mixin.interfaces.PBRTextureHolder;
import com.ventooth.swansong.pbr.PBRTextureEngine;
import com.ventooth.swansong.sufrace.PBRTexture2D;
import com.ventooth.swansong.sufrace.TextureMeta;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={AbstractTexture.class})
public abstract class AbstractTextureMixin
implements PBRTextureHolder {
    protected boolean swan$isLoaded;
    protected ResourceLocation swan$base;
    protected TextureMeta swan$meta;
    protected int swan$width;
    protected int swan$height;
    @Nullable
    protected PBRTexture2D.Bundle swan$pbrTex;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=1)
    private void pbr_PostInit(CallbackInfo ci) {
        this.swan$reset();
    }

    @Inject(method={"deleteGlTexture"}, at={@At(value="HEAD")}, require=1)
    private void pbr_TexDeinit(CallbackInfo ci) {
        if (this.swan$pbrTex != null) {
            PBRTextureEngine.deinitPbrTex(this.swan$pbrTex, "On Delete");
        }
        this.swan$reset();
    }

    private void swan$reset() {
        this.swan$isLoaded = false;
        this.swan$meta = null;
        this.swan$base = null;
        this.swan$width = -1;
        this.swan$height = -1;
        this.swan$pbrTex = null;
    }

    @Override
    public ResourceLocation swan$base() throws IllegalStateException {
        this.swan$ensureValid(true);
        return this.swan$base;
    }

    @Override
    public TextureMeta swan$meta() throws IllegalStateException {
        this.swan$ensureValid(true);
        return this.swan$meta;
    }

    @Override
    public int swan$width() throws IllegalStateException {
        this.swan$ensureValid(true);
        return this.swan$width;
    }

    @Override
    public int swan$height() throws IllegalStateException {
        this.swan$ensureValid(true);
        return this.swan$height;
    }

    @Override
    @Nullable
    public PBRTexture2D.Bundle swan$pbrTex() throws IllegalStateException {
        this.swan$ensureValid(true);
        return this.swan$pbrTex;
    }

    @Override
    @Nullable
    public PBRTexture2D.Bundle swan$pbrTex(@Nullable PBRTexture2D.Bundle pbrTex) throws IllegalStateException {
        this.swan$ensureValid(true);
        PBRTexture2D.Bundle old = this.swan$pbrTex;
        this.swan$pbrTex = pbrTex;
        return old;
    }

    @Override
    public boolean swan$isValid() {
        return this.swan$ensureValid(false);
    }

    @Override
    public void swan$baseInit(ResourceLocation base, int width, int height, boolean blur, boolean clamp) {
        if (this.swan$pbrTex != null) {
            PBRTextureEngine.deinitPbrTex(this.swan$pbrTex, "On Re-Init");
            this.swan$pbrTex = null;
        }
        if (this.swan$supportsPbr()) {
            this.swan$isLoaded = true;
            this.swan$base = base;
            this.swan$meta = new TextureMeta(blur, clamp);
            this.swan$width = width;
            this.swan$height = height;
            PBRTextureEngine.logInitialLoad(this);
        }
    }

    @Override
    public String swan$baseToString() {
        if (!this.swan$isLoaded) {
            return "!UNKNOWN!";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("base=");
        if (this.swan$base == null) {
            sb.append("[UNKNOWN]");
        } else {
            sb.append('[').append(this.swan$base).append(']');
        }
        sb.append(" size=");
        if (this.swan$width > 0 && this.swan$height > 0) {
            sb.append('[').append(this.swan$width).append('x').append(this.swan$height).append(']');
        } else {
            sb.append("[UNKNOWN]");
        }
        if (this.swan$meta != null) {
            sb.append(" [blur=").append(this.swan$meta.blur()).append(",clamp=").append(this.swan$meta.clamp()).append(']');
        } else {
            sb.append(" [blur=UNKNOWN,clamp=UNKNOWN]");
        }
        return sb.toString();
    }

    private boolean swan$ensureValid(boolean throwing) throws IllegalStateException {
        if (!this.swan$supportsPbr()) {
            if (throwing) {
                throw new IllegalStateException("Texture does not support PBR");
            }
            return false;
        }
        if (!this.swan$isLoaded) {
            if (throwing) {
                throw new IllegalStateException("Texture not loaded");
            }
            return false;
        }
        if (this.swan$base == null) {
            if (throwing) {
                throw new IllegalStateException("No texture base present");
            }
            return false;
        }
        if (this.swan$meta == null) {
            if (throwing) {
                throw new IllegalStateException("No texture meta present");
            }
            return false;
        }
        if (this.swan$width <= 0) {
            if (throwing) {
                throw new IllegalStateException("Invalid width: " + this.swan$width);
            }
            return false;
        }
        if (this.swan$height <= 0) {
            if (throwing) {
                throw new IllegalStateException("Invalid height: " + this.swan$height);
            }
            return false;
        }
        return true;
    }
}

