/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.image;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.config.ShadersConfig;
import com.ventooth.swansong.image.ImageUtils;
import com.ventooth.swansong.image.RawImage;
import com.ventooth.swansong.mixin.interfaces.PBRTextureHolder;
import com.ventooth.swansong.sufrace.PBRTexture2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

public final class TexDumper {
    public static final Logger log = Share.getLogger();
    private static Path texDumpDir;

    public static void dumpAllMc() {
        log.info("Dumping all textures");
        if (texDumpDir == null) {
            texDumpDir = Minecraft.func_71410_x().field_71412_D.toPath().resolve("swan_tex");
        }
        try {
            Files.createDirectories(texDumpDir, new FileAttribute[0]);
            FileUtils.cleanDirectory((File)texDumpDir.toFile());
        }
        catch (IOException e) {
            log.error("Failed to prepare texture dump dir: ", (Throwable)e);
            return;
        }
        Map<ResourceLocation, ITextureObject> textures = TexDumper.getMcTextures();
        log.info("Found: {} textures", new Object[]{textures.size()});
        textures.forEach(TexDumper::saveTexture);
    }

    private static void saveTexture(ResourceLocation loc, ITextureObject tex) {
        PBRTexture2D spec;
        PBRTexture2D norm;
        String texName = loc.func_110623_a();
        if (texName.endsWith(".png")) {
            texName = texName.substring(0, texName.length() - 4);
        }
        String rootTexName = texName;
        Path domainPath = texDumpDir.resolve(loc.func_110624_b());
        TexDumper.saveTexture((Integer i) -> domainPath.resolve(rootTexName + "_" + i + ".png"), tex.func_110552_b());
        if (!(tex instanceof PBRTextureHolder)) {
            return;
        }
        PBRTextureHolder texIDHolder = (PBRTextureHolder)tex;
        if (!texIDHolder.swan$isValid()) {
            return;
        }
        PBRTexture2D.Bundle multiTex = texIDHolder.swan$pbrTex();
        if (multiTex == null) {
            return;
        }
        if (ShadersConfig.NormalMapping.value && (norm = multiTex.norm()) != null) {
            TexDumper.saveTexture((Integer i) -> domainPath.resolve(rootTexName + "_n_" + i + ".png"), norm.glName());
        }
        if (ShadersConfig.SpecularMapping.value && (spec = multiTex.spec()) != null) {
            TexDumper.saveTexture((Integer i) -> domainPath.resolve(rootTexName + "_s_" + i + ".png"), spec.glName());
        }
    }

    private static void saveTexture(Function<Integer, Path> pathFn, int tex) {
        List<RawImage> rawImgs = ImageUtils.downloadGLTextureLevelsAsBGRA(tex);
        if (rawImgs.isEmpty()) {
            log.error("Failed to download texture (some mod is busted): path={}", new Object[]{pathFn.apply(0)});
            return;
        }
        for (int i = 0; i < rawImgs.size(); ++i) {
            RawImage rawImg = rawImgs.get(i);
            Path path = pathFn.apply(i);
            try {
                BufferedImage bufImg = rawImgs.get(i).asBufImg(true, false);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                ImageIO.write((RenderedImage)bufImg, "png", path.toFile());
                log.info("Saved texture: path={} size=[{}x{}]", new Object[]{path, rawImg.width(), rawImg.height()});
                continue;
            }
            catch (IOException e) {
                log.error("Failed to save texture (file problem): path={}", new Object[]{path});
                log.error("Trace: ", (Throwable)e);
                continue;
            }
            catch (Exception e) {
                log.error("Failed to save texture (unknown problem): path={}", new Object[]{path});
                log.error("Trace: ", (Throwable)e);
            }
        }
    }

    private static Map<ResourceLocation, ITextureObject> getMcTextures() {
        Minecraft mc = Minecraft.func_71410_x();
        Map texMap = mc.func_110434_K().field_110585_a;
        return texMap;
    }

    @Generated
    private TexDumper() {
    }
}

