/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.image;

import java.awt.image.BufferedImage;
import java.util.Objects;

public final class RawImage {
    private final int[] data;
    private final int width;
    private final int height;

    public RawImage(int[] data, int width, int height) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public BufferedImage asBufImg(boolean withAlpha, boolean flipY) {
        BufferedImage img = new BufferedImage(this.width, this.height, withAlpha ? 2 : 1);
        if (flipY) {
            int offset = this.width * this.height;
            for (int y = 0; y < this.height; ++y) {
                img.setRGB(0, y, this.width, 1, this.data, offset -= this.width, this.width);
            }
        } else {
            img.setRGB(0, 0, this.width, this.height, this.data, 0, this.width);
        }
        return img;
    }

    public int[] data() {
        return this.data;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RawImage that = (RawImage)obj;
        return Objects.equals(this.data, that.data) && this.width == that.width && this.height == that.height;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.width, this.height);
    }

    public String toString() {
        return "RawImage[data=" + this.data + ", width=" + this.width + ", height=" + this.height + ']';
    }
}

