/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.image;

import com.ventooth.swansong.Share;
import com.ventooth.swansong.image.RawImage;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.shader.Framebuffer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class ImageUtils {
    public static final Logger log = Share.getLogger();
    private static IntBuffer tempBuf = BufferUtils.createIntBuffer((int)16384);

    @Nullable
    public static RawImage downloadGLTextureAsBGRA(Framebuffer frameBuffer) {
        return ImageUtils.downloadGLTextureAsBGRA(frameBuffer.field_147617_g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static RawImage downloadGLTextureAsBGRA(int tex) {
        if (tex == 0) {
            log.warn("Tried to download zero texture");
            return null;
        }
        if (!GL11.glIsTexture((int)tex)) {
            log.warn("Cannot download uninitialized texture: id={}", new Object[]{tex});
            return null;
        }
        GL11.glPushAttrib((int)1048575);
        try {
            GL11.glBindTexture((int)3553, (int)tex);
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            int bufSize = width * height;
            if (bufSize <= 0) {
                log.debug("Failed to download texture: id={}, invalid size=[{}x{}]", new Object[]{tex, width, height});
                RawImage rawImage = null;
                return rawImage;
            }
            int oldBufSize = tempBuf.capacity();
            if (oldBufSize < bufSize) {
                tempBuf = BufferUtils.createIntBuffer((int)bufSize);
                log.debug("Resized temp texture buffer: ({}) -> ({})", new Object[]{oldBufSize, bufSize});
            }
            tempBuf.clear();
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)tempBuf);
            int[] data = new int[bufSize];
            tempBuf.get(data);
            log.debug("Downloaded texture: id={} size=[{}x{}]", new Object[]{tex, width, height});
            RawImage rawImage = new RawImage(data, width, height);
            return rawImage;
        }
        finally {
            GL11.glPopAttrib();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RawImage> downloadGLTextureLevelsAsBGRA(int tex) {
        ArrayList<RawImage> imgs = new ArrayList<RawImage>();
        if (tex == 0) {
            log.warn("Tried to download zero texture");
            return imgs;
        }
        if (!GL11.glIsTexture((int)tex)) {
            log.warn("Cannot download uninitialized texture: id={}", new Object[]{tex});
            return imgs;
        }
        for (int level = 0; level < 8; ++level) {
            GL11.glPushAttrib((int)1048575);
            try {
                GL11.glBindTexture((int)3553, (int)tex);
                int width = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4096);
                int height = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4097);
                int bufSize = width * height;
                if (bufSize <= 0) {
                    if (level != 0) break;
                    log.debug("Failed to download texture: id={}, invalid size=[{}x{}]", new Object[]{tex, width, height});
                    break;
                }
                int oldBufSize = tempBuf.capacity();
                if (oldBufSize < bufSize) {
                    tempBuf = BufferUtils.createIntBuffer((int)bufSize);
                    log.debug("Resized temp texture buffer: ({}) -> ({})", new Object[]{oldBufSize, bufSize});
                }
                tempBuf.clear();
                GL11.glPixelStorei((int)3333, (int)1);
                GL11.glPixelStorei((int)3317, (int)1);
                GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)tempBuf);
                int[] data = new int[bufSize];
                tempBuf.get(data);
                log.debug("Downloaded texture: id={} level={} size=[{}x{}]", new Object[]{tex, level, width, height});
                imgs.add(new RawImage(data, width, height));
                continue;
            }
            finally {
                GL11.glPopAttrib();
            }
        }
        return imgs;
    }

    @Generated
    private ImageUtils() {
    }
}

