/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.debug;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public final class DebugCommandServer
extends CommandBase {
    private final String name;
    private final List<String> aliases;
    private final String usage;
    private final int permission;
    private final Map<String, Consumer<ICommandSender>> optionMap;
    private final List<String> optionList;

    public DebugCommandServer() {
        this.name = "swan2";
        this.aliases = Collections.singletonList(this.name);
        this.usage = MessageFormat.format("/{0} <option>", this.name);
        this.permission = 0;
        this.optionMap = new LinkedHashMap<String, Consumer<ICommandSender>>();
        this.optionMap.put("smite", sender -> {
            if (!(sender instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            MovingObjectPosition hit = player.func_70614_a(100.0, 0.0f);
            if (hit == null || hit.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
                return;
            }
            World world = player.field_70170_p;
            int posX = hit.field_72311_b;
            int posY = hit.field_72312_c;
            int posZ = hit.field_72309_d;
            EntityLightningBolt bolt = new EntityLightningBolt(world, (double)posX, (double)posY, (double)posZ);
            world.func_72942_c((Entity)bolt);
            sender.func_145747_a((IChatComponent)new ChatComponentText("ZAP!"));
        });
        this.optionList = new ArrayList<String>(this.optionMap.keySet());
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args == null || args.length != 1) {
            return;
        }
        String arg = args[0];
        for (Map.Entry<String, Consumer<ICommandSender>> option : this.optionMap.entrySet()) {
            if (!arg.equals(option.getKey())) continue;
            option.getValue().accept(sender);
            return;
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args == null || args.length != 1) {
            return null;
        }
        String arg = args[0];
        ArrayList<String> completionOptions = new ArrayList<String>();
        this.optionList.stream().filter(opt -> opt.startsWith(arg)).forEach(completionOptions::add);
        return completionOptions.isEmpty() ? null : completionOptions;
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender sender) {
        return this.usage;
    }

    public int func_82362_a() {
        return this.permission;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }
}

