/*
 * Decompiled with CFR 0.152.
 */
package com.ventooth.swansong.FastTextRender;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.BufferUtils;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.GL11;
import sun.misc.Unsafe;

public class TextTess {
    private static final int nativeBufferSize = 0x200000;
    private static final Unsafe UNSAFE;
    private final ByteBuffer buf = BufferUtils.createByteBuffer((int)0x800000);
    private final long address = MemoryUtil.getAddress((ByteBuffer)this.buf);
    private final boolean hasTexture;
    private int rawBufferSize = 0;
    private int vertexCount;
    private int maxVertices;
    private int color;
    private long bufferIndex;
    private boolean isDrawing;

    public TextTess(boolean hasTexture) {
        this.hasTexture = hasTexture;
        long address = this.address;
    }

    public void draw() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.isDrawing = false;
        int stride = this.hasTexture ? 6 : 4;
        int strideBytes = stride * 4;
        if (this.hasTexture) {
            this.buf.position(16);
            GL11.glTexCoordPointer((int)2, (int)5126, (int)strideBytes, (ByteBuffer)this.buf);
            GL11.glEnableClientState((int)32888);
        }
        this.buf.position(12);
        GL11.glColorPointer((int)4, (int)5121, (int)strideBytes, (ByteBuffer)this.buf);
        GL11.glEnableClientState((int)32886);
        this.buf.position(0);
        GL11.glVertexPointer((int)3, (int)5126, (int)strideBytes, (ByteBuffer)this.buf);
        GL11.glEnableClientState((int)32884);
        GL11.glDrawArrays((int)7, (int)0, (int)this.vertexCount);
        GL11.glDisableClientState((int)32884);
        if (this.hasTexture) {
            GL11.glDisableClientState((int)32888);
        }
        GL11.glDisableClientState((int)32886);
        this.reset();
    }

    private void reset() {
        this.vertexCount = 0;
        this.bufferIndex = this.address;
    }

    public void startDrawingQuads() {
        if (this.isDrawing) {
            throw new IllegalStateException("Already tesselating text!");
        }
        this.isDrawing = true;
        this.reset();
        this.vertexCount = 0;
        int maxQuads = 0x200000 / ((this.hasTexture ? 6 : 4) * 4) / 4;
        this.maxVertices = maxQuads * 4;
    }

    public void setColorRGBA_F(float r, float g, float b, float a) {
        this.setColorRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public void setColorRGBA(int red, int green, int blue, int alpha) {
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (alpha < 0) {
            alpha = 0;
        }
        this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? alpha << 24 | blue << 16 | green << 8 | red : red << 24 | green << 16 | blue << 8 | alpha;
    }

    public void addVertexWithUV(float x, float y, float z, float u, float v) {
        this.addVertex(x, y, z);
        UNSAFE.putFloat(this.bufferIndex, u);
        UNSAFE.putFloat(this.bufferIndex + 4L, v);
        this.bufferIndex += 8L;
    }

    public void addVertex(float x, float y, float z) {
        if (this.vertexCount >= this.maxVertices) {
            this.draw();
            this.startDrawingQuads();
        }
        UNSAFE.putFloat(this.bufferIndex, x);
        UNSAFE.putFloat(this.bufferIndex + 4L, y);
        UNSAFE.putFloat(this.bufferIndex + 8L, z);
        UNSAFE.putInt(this.bufferIndex + 12L, this.color);
        this.bufferIndex += 16L;
        ++this.vertexCount;
    }

    static {
        try {
            Field theField = Unsafe.class.getDeclaredField("theUnsafe");
            theField.setAccessible(true);
            UNSAFE = (Unsafe)theField.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

