/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.vanilla;

import com.google.common.base.Objects;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.UsernameCache;

public enum PetProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
        String ownerUUID;
        EntityTameable pet;
        Entity entity = accessor.getEntity();
        if (entity instanceof EntityTameable && (pet = (EntityTameable)entity).func_70909_n() && PluginsConfig.vanilla.pet.showPetSit) {
            tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.sitting"), pet.func_70906_o() ? StatCollector.func_74838_a((String)"hud.msg.wdmla.yes") : StatCollector.func_74838_a((String)"hud.msg.wdmla.no")).tag(VanillaIdentifiers.PET));
        }
        if (Objects.equal((Object)(ownerUUID = accessor.getServerData().func_74779_i("OwnerUUID")), (Object)"") || !PluginsConfig.vanilla.pet.showPetOwner) {
            return;
        }
        String ownerString = UsernameCache.getLastKnownUsername((UUID)UUID.fromString(ownerUUID));
        if (Objects.equal((Object)ownerString, (Object)"")) {
            return;
        }
        tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.owner"), ownerString).tag(VanillaIdentifiers.PET));
    }

    @Override
    public ResourceLocation getUid() {
        return VanillaIdentifiers.PET;
    }

    @Override
    public void appendServerData(NBTTagCompound data, EntityAccessor accessor) {
        accessor.getEntity().func_70109_d(data);
    }
}

