/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.universal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.gtnewhorizons.wdmla.ClientProxy;
import com.gtnewhorizons.wdmla.CommonProxy;
import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.Theme;
import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IClientExtensionProvider;
import com.gtnewhorizons.wdmla.api.provider.IComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerExtensionProvider;
import com.gtnewhorizons.wdmla.api.ui.ComponentAlignment;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.ui.MessageType;
import com.gtnewhorizons.wdmla.api.view.ClientViewGroup;
import com.gtnewhorizons.wdmla.api.view.ItemView;
import com.gtnewhorizons.wdmla.api.view.ViewGroup;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ItemComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.PanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.RectComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.impl.ui.style.PanelStyle;
import com.gtnewhorizons.wdmla.impl.ui.style.RectStyle;
import com.gtnewhorizons.wdmla.plugin.universal.ItemCollector;
import com.gtnewhorizons.wdmla.plugin.universal.ItemIterator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ItemStorageProvider<T extends Accessor>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static final Cache<Object, ItemCollector<?>> targetCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    public static final Cache<Object, ItemCollector<?>> containerCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(120L, TimeUnit.SECONDS).build();

    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static NBTTagCompound encodeGroups(Map.Entry<ResourceLocation, List<ViewGroup<ItemStack>>> entry) {
        List<ViewGroup<ItemStack>> viewGroups = entry.getValue();
        NBTTagList groupsNBT = new NBTTagList();
        for (ViewGroup<ItemStack> viewGroup : viewGroups) {
            groupsNBT.func_74742_a((NBTBase)ItemStorageProvider.encodeGroup(viewGroup));
        }
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a(entry.getKey().toString(), (NBTBase)groupsNBT);
        return root;
    }

    public static NBTTagCompound encodeGroup(ViewGroup<ItemStack> viewGroup) {
        ArrayList<NBTTagCompound> encodedItemStacks = new ArrayList<NBTTagCompound>();
        for (ItemStack item : viewGroup.views) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            item.func_77955_b(itemNBT);
            itemNBT.func_74768_a("intCount", item.field_77994_a);
            encodedItemStacks.add(itemNBT);
        }
        ViewGroup<NBTTagCompound> contentEncodedGroup = new ViewGroup<NBTTagCompound>(encodedItemStacks, viewGroup);
        return ViewGroup.encode(contentEncodedGroup);
    }

    public static Map.Entry<ResourceLocation, List<ViewGroup<ItemStack>>> decodeGroups(NBTTagCompound root) {
        if (root.func_82582_d()) {
            return null;
        }
        String key = (String)root.func_150296_c().iterator().next();
        ResourceLocation resourceLocation = new ResourceLocation(key);
        NBTTagList groupsNBT = root.func_150295_c(key, 10);
        ArrayList<ViewGroup<ItemStack>> viewGroups = new ArrayList<ViewGroup<ItemStack>>();
        for (int i = 0; i < groupsNBT.func_74745_c(); ++i) {
            NBTTagCompound groupNBT = groupsNBT.func_150305_b(i);
            viewGroups.add(ItemStorageProvider.decodeGroup(groupNBT));
        }
        return new AbstractMap.SimpleEntry<ResourceLocation, List<ViewGroup<ItemStack>>>(resourceLocation, viewGroups);
    }

    public static ViewGroup<ItemStack> decodeGroup(NBTTagCompound groupNBT) {
        ViewGroup<NBTTagCompound> contentDecodedGroup = ViewGroup.decode(groupNBT);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (NBTTagCompound itemNBT : contentDecodedGroup.views) {
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
            if (item == null) continue;
            item.field_77994_a = itemNBT.func_74762_e("intCount");
            itemStacks.add(item);
        }
        return new ViewGroup<ItemStack>(itemStacks, contentDecodedGroup);
    }

    public static void append(ITooltip tooltip, Accessor accessor, List<ClientViewGroup<ItemView>> groups) {
        boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            float progress;
            MutableBoolean showName = ItemStorageProvider.getShowName(group);
            PluginsConfig.Universal.ItemStorage config = PluginsConfig.universal.itemStorage;
            if (renderGroup) {
                Theme theme = General.currentTheme.get();
                if (group.title != null) {
                    PanelComponent hPanel = new HPanelComponent().style(new PanelStyle().alignment(ComponentAlignment.CENTER));
                    hPanel.child(new RectComponent().style(new RectStyle().backgroundColor(theme.textColor(MessageType.NORMAL))).size(new Size(20, 1)));
                    hPanel.child(new TextComponent(group.title).scale(0.6f));
                    hPanel.child(new RectComponent().style(new RectStyle().backgroundColor(theme.textColor(MessageType.NORMAL))).size(new Size(30, 1)));
                    theTooltip.child(hPanel);
                } else {
                    tooltip.child(new RectComponent().style(new RectStyle().backgroundColor(theme.textColor(MessageType.NORMAL))).size(new Size(50, 1)));
                }
            }
            if (group.views.isEmpty() && group.extraData != null && (progress = group.extraData.func_74760_g("Collecting")) >= 0.0f && progress < 1.0f) {
                String collectingText = StatCollector.func_74838_a((String)"hud.msg.wdmla.collectingItems");
                if (progress != 0.0f) {
                    collectingText = collectingText + String.format(" %s%%", (int)(progress * 100.0f));
                }
                theTooltip.text(collectingText);
            }
            int drawnCount = 0;
            int realSize = accessor.showDetails() ? config.detailedAmount : config.normalAmount;
            realSize = Math.min(group.views.size(), realSize);
            HPanelComponent elements = new HPanelComponent();
            for (int i = 0; i < realSize; ++i) {
                ItemView itemView = (ItemView)group.views.get(i);
                ItemStack stack = itemView.item;
                if (stack == null) continue;
                if (i > 0 && (showName.isTrue() || drawnCount >= config.itemsPerLine)) {
                    theTooltip.child(elements);
                    elements = new HPanelComponent();
                    drawnCount = 0;
                }
                if (showName.isTrue()) {
                    if (itemView.description != null) {
                        elements.child(ThemeHelper.INSTANCE.smallItem(stack)).child(itemView.description);
                    } else {
                        elements.child(ThemeHelper.INSTANCE.itemStackFullLine(stack));
                    }
                } else if (itemView.amountText != null) {
                    elements.child(new ItemComponent(stack).stackSizeOverride(itemView.amountText));
                } else {
                    elements.item(stack);
                }
                ++drawnCount;
            }
            if (elements.childrenSize() > 0) {
                theTooltip.child(elements);
            }
        });
    }

    public static MutableBoolean getShowName(ClientViewGroup<ItemView> group) {
        MutableBoolean showName = new MutableBoolean(true);
        int showNameAmount = PluginsConfig.universal.itemStorage.showNameAmount;
        int totalSize = 0;
        for (ItemView view : group.views) {
            if (view.amountText != null) {
                showName.setFalse();
            }
            if (view.item == null || totalSize++ != showNameAmount) continue;
            showName.setFalse();
        }
        return showName;
    }

    public static void putData(NBTTagCompound data, Accessor accessor) {
        Map.Entry<ResourceLocation, List<ViewGroup<ItemStack>>> entry = CommonProxy.getServerExtensionData(accessor, WDMlaCommonRegistration.instance().itemStorageProviders);
        if (entry != null) {
            List groups = entry.getValue();
            for (ViewGroup group : groups) {
                if (group.views.size() <= 54) continue;
                group.views = group.views.subList(0, 54);
            }
            data.func_74782_a(Identifiers.ITEM_STORAGE.toString(), (NBTBase)ItemStorageProvider.encodeGroups(entry));
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor) {
        List<ClientViewGroup<ItemView>> groups = ClientProxy.mapToClientGroups(accessor, Identifiers.ITEM_STORAGE, ItemStorageProvider::decodeGroups, WDMlaClientRegistration.instance().itemStorageProviders::get);
        if (groups == null || groups.isEmpty()) {
            return;
        }
        ItemStorageProvider.append(tooltip, accessor, groups);
    }

    @Override
    public void appendServerData(NBTTagCompound data, T accessor) {
        ItemStorageProvider.putData(data, accessor);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 5101;
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        int amount = accessor.showDetails() ? PluginsConfig.universal.itemStorage.detailedAmount : PluginsConfig.universal.itemStorage.normalAmount;
        if (amount == 0) {
            return false;
        }
        return accessor.getTarget() != null && !WDMlaCommonRegistration.instance().itemStorageProviders.wrappedGet((Accessor)accessor).isEmpty();
    }

    public static class ForBlock
    extends ItemStorageProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends ItemStorageProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }

    public static enum Extension implements IServerExtensionProvider<ItemStack>,
    IClientExtensionProvider<ItemStack, ItemView>
    {
        INSTANCE;


        @Override
        public ResourceLocation getUid() {
            return Identifiers.ITEM_STORAGE_DEFAULT;
        }

        @Override
        @Nullable
        public List<ViewGroup<ItemStack>> getGroups(Accessor accessor) {
            ItemCollector itemCollector;
            Object target = accessor.getTarget();
            if (target == null) {
                return CommonProxy.createItemCollector(accessor, containerCache).update(accessor);
            }
            EntityPlayer player = accessor.getPlayer();
            if (target instanceof TileEntityEnderChest) {
                InventoryEnderChest inventory = player.func_71005_bN();
                return new ItemCollector<IInventory>(new ItemIterator.IInventoryItemIterator($ -> inventory, 0)).update(accessor);
            }
            try {
                itemCollector = (ItemCollector)targetCache.get(target, () -> CommonProxy.createItemCollector(accessor, containerCache));
            }
            catch (ExecutionException e) {
                WailaExceptionHandler.handleErr(e, this.getClass().getName(), null);
                return null;
            }
            return itemCollector.update(accessor);
        }

        @Override
        public boolean shouldRequestData(Accessor accessor) {
            return true;
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }

        @Override
        public List<ClientViewGroup<ItemView>> getClientGroups(Accessor accessor, List<ViewGroup<ItemStack>> groups) {
            return ClientViewGroup.map(groups, ItemView::new, null);
        }
    }
}

