/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.storagedrawers;

import com.gtnewhorizons.wdmla.api.ui.ComponentAlignment;
import com.gtnewhorizons.wdmla.api.ui.HighlightTracker;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.RectComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.impl.ui.style.PanelStyle;
import com.gtnewhorizons.wdmla.impl.ui.style.RectStyle;
import com.gtnewhorizons.wdmla.impl.ui.style.TextStyle;
import com.gtnewhorizons.wdmla.util.Color;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import mcp.mobius.waila.overlay.DisplayUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class DrawerInfoHighlighter {
    private final HighlightTracker<Integer> stackCountTracker;
    private final HighlightTracker<Integer> remainderTracker;
    private final HighlightTracker.ItemStack stackTracker;

    public DrawerInfoHighlighter(IDrawer drawer) {
        ItemStack stack = drawer.getStoredItemPrototype();
        if (stack == null || stack.func_77973_b() == null) {
            this.stackCountTracker = new HighlightTracker<Integer>(0);
            this.remainderTracker = new HighlightTracker<Integer>(0);
        } else {
            int stackCount = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
            int remainder = drawer.getStoredItemCount() - stackCount * drawer.getStoredItemStackSize();
            this.stackCountTracker = new HighlightTracker<Integer>(stackCount);
            this.remainderTracker = new HighlightTracker<Integer>(remainder);
        }
        this.stackTracker = new HighlightTracker.ItemStack(stack);
    }

    public IComponent update(IDrawer drawer) {
        ItemStack stack = drawer.getStoredItemPrototype();
        if (stack == null || stack.func_77973_b() == null) {
            return this.updateEmpty();
        }
        int stackCount = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
        int remainder = drawer.getStoredItemCount() - stackCount * drawer.getStoredItemStackSize();
        boolean highlightStacks = this.stackTracker.update(stack);
        boolean highlightStackCount = this.stackCountTracker.update(stackCount) || highlightStacks;
        boolean highlightRemainder = this.remainderTracker.update(remainder) || highlightStacks;
        String stackCountStr = FormatUtil.STANDARD.format(stackCount);
        String remainderStr = FormatUtil.STANDARD.format(remainder);
        String displayName = DisplayUtil.stripSymbols(DisplayUtil.itemDisplayNameShortFormatted(drawer.getStoredItemPrototype()));
        float stackInterpolation = this.stackTracker.getInterpolation();
        IComponent displayNameComponent = this.getHighlightComponent(displayName, highlightStacks, stackInterpolation);
        IComponent stackCountComponent = this.getHighlightComponent(stackCountStr, highlightStackCount, this.stackCountTracker.getInterpolation());
        IComponent remainderComponent = this.getHighlightComponent(remainderStr, highlightRemainder, this.remainderTracker.getInterpolation());
        HPanelComponent itemLine = new HPanelComponent();
        itemLine.child(displayNameComponent);
        itemLine.child(this.getHighlightComponent(" [", highlightStacks, stackInterpolation));
        if (stackCount > 0 && remainder > 0) {
            itemLine.child(stackCountComponent);
            itemLine.child(this.getHighlightComponent("x" + drawer.getStoredItemStackSize() + " + ", highlightStacks, stackInterpolation));
            itemLine.child(remainderComponent);
            itemLine.child(this.getHighlightComponent("]", highlightStacks, stackInterpolation));
        } else if (stackCount > 0) {
            itemLine.child(stackCountComponent);
            itemLine.child(this.getHighlightComponent("x" + drawer.getStoredItemStackSize() + "]", highlightStacks, stackInterpolation));
        } else {
            itemLine.child(remainderComponent);
            itemLine.child(this.getHighlightComponent("]", highlightStacks, stackInterpolation));
        }
        return itemLine;
    }

    private IComponent updateEmpty() {
        boolean highlightStacks = this.stackTracker.update(null);
        this.stackCountTracker.update(0);
        this.remainderTracker.update(0);
        float stackInterpolation = this.stackTracker.getInterpolation();
        return new HPanelComponent().style(new PanelStyle().alignment(ComponentAlignment.CENTER)).child(new RectComponent().style(new RectStyle().backgroundColor(this.getInterpolationColor(stackInterpolation))).size(new Size(25, 1))).child(((TextComponent)this.getHighlightComponent(StatCollector.func_74838_a((String)"hud.msg.wdmla.empty"), highlightStacks, stackInterpolation)).scale(0.6f)).child(new RectComponent().style(new RectStyle().backgroundColor(this.getInterpolationColor(stackInterpolation))).size(new Size(25, 1)));
    }

    private IComponent getHighlightComponent(String text, boolean doHighlight, float interpolation) {
        return new TextComponent(text).style(doHighlight ? new TextStyle().color(this.getInterpolationColor(interpolation)) : new TextStyle().color(General.currentTheme.get().textColors._default));
    }

    private int getInterpolationColor(float interpolation) {
        return Color.setInterporation(General.currentTheme.get().textColors.info, General.currentTheme.get().textColors._default, interpolation > 0.75f ? (interpolation - 0.75f) * 4.0f : 0.0f);
    }
}

