/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.harvestability.proxy;

import com.gtnewhorizons.wdmla.api.Mods;
import com.gtnewhorizons.wdmla.api.harvestability.EffectiveTool;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ProxyGregTech {
    public static final String CASING_ID = "gt.blockcasings";
    public static final String CASING_UNIQUE_IDENTIFIER = Mods.GREGTECH.modID + ":" + "gt.blockcasings";
    public static final String MACHINE_ID = "gt.blockmachines";
    public static final String MACHINE_UNIQUE_IDENTIFIER = Mods.GREGTECH.modID + ":" + "gt.blockmachines";
    private static int wrenchID;
    private static int wireCutterID;
    private static ItemStack iconIronWrench;
    private static ItemStack iconSteelWrench;
    private static ItemStack iconIronWireCutter;
    public static EffectiveTool toolWrench;
    public static EffectiveTool toolWireCutter;

    public static void init() {
        try {
            Class<?> GT_MetaGenerated_Tool = Class.forName("gregtech.api.items.MetaGeneratedTool");
            Field sInstancesField = GT_MetaGenerated_Tool.getField("sInstances");
            ConcurrentHashMap sInstances = (ConcurrentHashMap)sInstancesField.get(null);
            Object metaTool01 = sInstances.get("gt.metatool.01");
            Class<?> Materials = Class.forName("gregtech.api.enums.Materials");
            Method getToolWithStatsMethod = GT_MetaGenerated_Tool.getDeclaredMethod("getToolWithStats", Integer.TYPE, Integer.TYPE, Materials, Materials, long[].class);
            Class<?> GT_MetaGenerated_Tool_01 = Class.forName("gregtech.common.items.IDMetaTool01");
            Field idField = GT_MetaGenerated_Tool_01.getField("ID");
            Object wrenchConstant = Enum.valueOf(GT_MetaGenerated_Tool_01, "WRENCH");
            wrenchID = idField.getInt(wrenchConstant);
            Object wireCutterConstant = Enum.valueOf(GT_MetaGenerated_Tool_01, "WIRECUTTER");
            wireCutterID = idField.getInt(wireCutterConstant);
            Object ironMaterial = Materials.getField("Iron").get(null);
            Object steelMaterial = Materials.getField("Steel").get(null);
            iconIronWrench = (ItemStack)getToolWithStatsMethod.invoke(metaTool01, wrenchID, 1, ironMaterial, ironMaterial, null);
            iconSteelWrench = (ItemStack)getToolWithStatsMethod.invoke(metaTool01, wrenchID, 1, steelMaterial, steelMaterial, null);
            iconIronWireCutter = (ItemStack)getToolWithStatsMethod.invoke(metaTool01, wireCutterID, 1, ironMaterial, ironMaterial, null);
            toolWrench = new EffectiveTool("wrench", Arrays.asList(iconIronWrench, iconIronWrench, iconIronWrench, iconSteelWrench, iconSteelWrench));
            toolWireCutter = new EffectiveTool("cutter", Arrays.asList(iconIronWireCutter, iconIronWireCutter, iconIronWireCutter));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isOreBlock(Block block, int meta) {
        if (!Mods.GREGTECH.isLoaded()) {
            return false;
        }
        try {
            return GTMethods.GTUTIL_IS_ORE.invokeExact(block, meta);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCasing(Block block) {
        return Mods.GREGTECH.isLoaded() && GameRegistry.findUniqueIdentifierFor((Block)block).toString().equals(CASING_UNIQUE_IDENTIFIER);
    }

    public static boolean isMachine(Block block) {
        return Mods.GREGTECH.isLoaded() && GameRegistry.findUniqueIdentifierFor((Block)block).toString().equals(MACHINE_UNIQUE_IDENTIFIER);
    }

    public static boolean isGTTool(ItemStack itemStack) {
        return Mods.GREGTECH.isLoaded() && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("GT.ToolStats");
    }

    public static boolean isWrench(ItemStack itemStack) {
        return ProxyGregTech.isGTTool(itemStack) && itemStack.func_77960_j() == wrenchID;
    }

    public static boolean isWireCutter(ItemStack itemStack) {
        return ProxyGregTech.isGTTool(itemStack) && itemStack.func_77960_j() == wireCutterID;
    }

    private static class GTMethods {
        public static final MethodHandle GTUTIL_IS_ORE;

        private GTMethods() {
        }

        static {
            try {
                GTUTIL_IS_ORE = MethodHandles.lookup().findStatic(Class.forName("gregtech.api.util.GTUtility"), "isOre", MethodType.methodType(Boolean.TYPE, Block.class, Integer.TYPE));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

