/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.overlay;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizons.wdmla.util.HotSwapUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL11;

public class GuiBlockDraw {
    public BlockPos renderedBlock;
    private final Vector3f eyePos = new Vector3f(0.0f, 0.0f, -10.0f);
    private final Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private final Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector4i rect = new Vector4i();
    private final RenderBlocks bufferBuilder = new RenderBlocks();
    private static final GuiBlockDraw instance = new GuiBlockDraw();
    public static final float ZOOM = 2.3f;

    public static void drawWorldBlock(int x, int y, int width, int height, int blockX, int blockY, int blockZ, float rotationYaw, float rotationPitch) {
        Vector3f center = new Vector3f((float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int windowWidth = GuiBlockDraw.getScaledX(mc, resolution, width);
        int windowHeight = GuiBlockDraw.getScaledY(mc, resolution, height);
        int windowX = GuiBlockDraw.getScaledX(mc, resolution, x);
        int windowY = mc.field_71440_d - GuiBlockDraw.getScaledY(mc, resolution, y) - windowHeight;
        GuiBlockDraw.instance.renderedBlock = new BlockPos(blockX, blockY, blockZ);
        instance.setCameraLookAt(center, 2.3f, Math.toRadians(rotationPitch), Math.toRadians(rotationYaw));
        instance.render(windowX, windowY, windowWidth, windowHeight);
    }

    private void render(int x, int y, int width, int height) {
        this.rect.set(x, y, width, height);
        this.setupCamera();
        this.drawWorld();
        GuiBlockDraw.resetCamera();
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        this.lookAt.set((Vector3fc)lookAt);
        this.eyePos.set((float)Math.cos(rotationPitch), 0.0f, (float)Math.sin(rotationPitch)).add(0.0f, (float)(Math.tan(rotationYaw) * (double)this.eyePos.length()), 0.0f).normalize().mul((float)radius).add((Vector3fc)lookAt);
    }

    private static int getScaledX(Minecraft mc, ScaledResolution res, int x) {
        return (int)((double)x / ((double)res.func_78326_a() * 1.0) * (double)mc.field_71443_c);
    }

    private static int getScaledY(Minecraft mc, ScaledResolution res, int y) {
        return (int)((double)y / ((double)res.func_78328_b() * 1.0) * (double)mc.field_71440_d);
    }

    public void setupCamera() {
        int x = this.rect.x;
        int y = this.rect.y;
        int width = this.rect.z;
        int height = this.rect.w;
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushClientAttrib((int)-1);
        mc.field_71460_t.func_78483_a(0.0);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
        this.scissorView(x, y, width, height);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        HotSwapUtil.gluPerspective(60.0f, aspectRatio, 0.1f, 10000.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        HotSwapUtil.gluLookat(this.eyePos.x, this.eyePos.y, this.eyePos.z, this.lookAt.x, this.lookAt.y, this.lookAt.z, this.worldUp.x, this.worldUp.y, this.worldUp.z);
    }

    protected void scissorView(int x, int y, int width, int height) {
        GL11.glEnable((int)3089);
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
        GL11.glDisable((int)3089);
    }

    public static void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GL11.glViewport((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopClientAttrib();
        GL11.glPopAttrib();
    }

    protected void drawWorld() {
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)32826);
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_78483_a(0.0);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        Tessellator tessellator = Tessellator.field_78398_a;
        this.renderBlocks(tessellator, this.renderedBlock);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)2896);
        TileEntityRendererDispatcher tesr = TileEntityRendererDispatcher.field_147556_a;
        for (int pass = 0; pass < 2; ++pass) {
            ForgeHooksClient.setRenderPass((int)pass);
            int finalPass = pass;
            int x = this.renderedBlock.x;
            int y = this.renderedBlock.y;
            int z = this.renderedBlock.z;
            GuiBlockDraw.setDefaultPassRenderState(finalPass);
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
            if (tile == null || !tesr.func_147545_a(tile) || !tile.shouldRenderInPass(finalPass)) continue;
            tesr.func_147549_a(tile, (double)x, (double)y, (double)z, 0.0f);
        }
        ForgeHooksClient.setRenderPass((int)-1);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderBlocks(Tessellator tessellator, BlockPos blocksToRender) {
        if (blocksToRender == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        int savedAo = mc.field_71474_y.field_74348_k;
        mc.field_71474_y.field_74348_k = 0;
        tessellator.func_78382_b();
        try {
            tessellator.func_78380_c(0xF000F0);
            for (int i = 0; i < 2; ++i) {
                int x = blocksToRender.x;
                int y = blocksToRender.y;
                int z = blocksToRender.z;
                Block block = Minecraft.func_71410_x().field_71441_e.func_147439_a(x, y, z);
                if (block.equals(Blocks.field_150350_a) || !block.canRenderInPass(i)) continue;
                this.bufferBuilder.field_147845_a = Minecraft.func_71410_x().field_71441_e;
                this.bufferBuilder.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                this.bufferBuilder.field_147837_f = true;
                this.bufferBuilder.func_147805_b(block, x, y, z);
            }
        }
        finally {
            mc.field_71474_y.field_74348_k = savedAo;
            tessellator.func_78381_a();
            tessellator.func_78373_b(0.0, 0.0, 0.0);
        }
    }

    public static void setDefaultPassRenderState(int pass) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass == 0) {
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
        } else {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthMask((boolean)false);
        }
    }
}

