/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.drawable;

import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.sizer.IArea;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.overlay.GuiDraw;
import mcp.mobius.waila.Waila;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class EntityDrawable
implements IDrawable {
    @NotNull
    private final Entity entity;

    public EntityDrawable(@NotNull Entity entity) {
        this.entity = entity;
    }

    @Override
    public void draw(IArea area) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2929);
        float autoScale = Math.max(PluginsConfig.core.defaultEntity.iconDefaultScale, 0.1f) / Math.max(this.entity.field_70130_N, this.entity.field_70131_O);
        GL11.glPushMatrix();
        try {
            Entity entity = this.entity;
            if (entity instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)entity;
                String bossName = BossStatus.field_82827_c;
                int bossTimeout = BossStatus.field_82826_b;
                boolean bossHasColorModifier = BossStatus.field_82825_d;
                float renderTagRange = RendererLivingEntity.NAME_TAG_RANGE;
                float renderTagRangeSneaking = RendererLivingEntity.NAME_TAG_RANGE_SNEAK;
                RendererLivingEntity.NAME_TAG_RANGE = 0.0f;
                RendererLivingEntity.NAME_TAG_RANGE_SNEAK = 0.0f;
                GL11.glTranslatef((float)area.getX(), (float)(area.getY() + area.getH()), (float)0.0f);
                if (PluginsConfig.core.defaultEntity.iconAutoScale) {
                    GL11.glScalef((float)autoScale, (float)autoScale, (float)1.0f);
                }
                GuiInventory.func_147046_a((int)0, (int)0, (int)((int)area.getW()), (float)135.0f, (float)0.0f, (EntityLivingBase)living);
                RendererLivingEntity.NAME_TAG_RANGE = renderTagRange;
                RendererLivingEntity.NAME_TAG_RANGE_SNEAK = renderTagRangeSneaking;
                BossStatus.field_82827_c = bossName;
                BossStatus.field_82826_b = bossTimeout;
                BossStatus.field_82825_d = bossHasColorModifier;
            } else {
                GL11.glTranslatef((float)area.getX(), (float)(area.getY() + area.getH() - area.getW() / 2.0f), (float)0.0f);
                if (PluginsConfig.core.defaultEntity.iconAutoScale) {
                    GL11.glScalef((float)autoScale, (float)autoScale, (float)1.0f);
                }
                GuiDraw.drawNonLivingEntity(0, 0, (int)area.getW(), 135 + this.entity.field_70173_aa * PluginsConfig.core.defaultEntity.rendererRotationSpeed % 360, 0.0f, this.entity);
            }
        }
        catch (Exception e) {
            Waila.log.error("Error rendering instance of entity", (Throwable)e);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2929);
    }
}

